/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.AdobePDFSchema;
import org.apache.xmpbox.schema.DublinCoreSchema;
import org.apache.xmpbox.schema.XMPBasicSchema;
import org.apache.xmpbox.xml.XmpSerializer;

public class AddMetadataFromDocInfo {
    private AddMetadataFromDocInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            AddMetadataFromDocInfo.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load((String)args[0]);
                if (document.isEncrypted()) {
                    System.err.println("Error: Cannot add metadata to encrypted document.");
                    System.exit(1);
                }
                PDDocumentCatalog catalog = document.getDocumentCatalog();
                PDDocumentInformation info = document.getDocumentInformation();
                XMPMetadata metadata = XMPMetadata.createXMPMetadata();
                AdobePDFSchema pdfSchema = metadata.createAndAddAdobePDFSchema();
                pdfSchema.setKeywords(info.getKeywords());
                pdfSchema.setProducer(info.getProducer());
                XMPBasicSchema basicSchema = metadata.createAndAddXMPBasicSchema();
                basicSchema.setModifyDate(info.getModificationDate());
                basicSchema.setCreateDate(info.getCreationDate());
                basicSchema.setCreatorTool(info.getCreator());
                basicSchema.setMetadataDate((Calendar)new GregorianCalendar());
                DublinCoreSchema dcSchema = metadata.createAndAddDublinCoreSchema();
                dcSchema.setTitle(info.getTitle());
                dcSchema.addCreator("PDFBox");
                dcSchema.setDescription(info.getSubject());
                PDMetadata metadataStream = new PDMetadata(document);
                catalog.setMetadata(metadataStream);
                XmpSerializer serializer = new XmpSerializer();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                serializer.serialize(metadata, (OutputStream)baos, false);
                metadataStream.importXMPMetadata(baos.toByteArray());
                document.save(args[1]);
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.examples.pdmodel.AddMetadataFromDocInfo <input-pdf> <output-pdf>");
    }
}

