/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.documentmanipulation;

import java.awt.geom.AffineTransform;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;
import org.apache.pdfbox.util.LayerUtility;

public class SuperimposePage {
    public static void main(String[] args) {
        try {
            PDDocument aDoc = new PDDocument();
            PDPage aPage = new PDPage();
            PDRectangle cropBox = aPage.findCropBox();
            aDoc.addPage(aPage);
            PDPageContentStream aContent = new PDPageContentStream(aDoc, aPage);
            PDType1Font font = PDType1Font.HELVETICA_BOLD;
            aContent.beginText();
            aContent.setFont((PDFont)font, 12.0f);
            aContent.moveTextPositionByAmount(2.0f, 5.0f);
            aContent.drawString("Import a pdf file:");
            aContent.endText();
            aContent.close();
            LayerUtility layerUtility = new LayerUtility(aDoc);
            PDDocument toBeImported = PDDocument.load((String)args[0]);
            PDXObjectForm mountable = layerUtility.importPageAsForm(toBeImported, 0);
            mountable.getPDStream().addCompression();
            PDPageContentStream contentStream = new PDPageContentStream(aDoc, aPage, true, true);
            contentStream.appendRawCommands("q\n".getBytes("ISO-8859-1"));
            AffineTransform transform = new AffineTransform(0.0, 0.5, -0.5, 0.0, (double)cropBox.getWidth(), 0.0);
            contentStream.drawXObject((PDXObject)mountable, transform);
            transform = new AffineTransform(0.5, 0.5, -0.5, 0.5, 0.5 * (double)cropBox.getWidth(), 0.2 * (double)cropBox.getHeight());
            contentStream.drawXObject((PDXObject)mountable, transform);
            contentStream.appendRawCommands("Q\n".getBytes("ISO-8859-1"));
            contentStream.close();
            toBeImported.close();
            aDoc.save(args[1]);
            aDoc.close();
        }
        catch (Exception e) {
            System.out.println(" error creating pdf file." + e.toString());
        }
    }
}

