/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.SuperProperties;

public final class PropertyPlaceHolderHelper {
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";
    private static final Properties CACHE = new Properties();
    public static final StrSubstitutor SUBSTITUTOR = new StrSubstitutor((StrLookup)new PropertiesLookup());

    private PropertyPlaceHolderHelper() {
    }

    public static String simpleValue(String raw) {
        if (raw == null || !raw.contains(PREFIX) || !raw.contains(SUFFIX)) {
            return raw;
        }
        String value = SUBSTITUTOR.replace(raw);
        if (!value.equals(raw) && value.startsWith("java:")) {
            value = value.substring(5);
        }
        return value;
    }

    public static String value(String aw) {
        if (aw == null || !aw.contains(PREFIX) || !aw.contains(SUFFIX)) {
            return aw;
        }
        String value = CACHE.getProperty(aw);
        if (value != null) {
            return value;
        }
        value = PropertyPlaceHolderHelper.simpleValue(aw);
        CACHE.setProperty(aw, value);
        return value;
    }

    public static Properties holds(Properties properties) {
        SuperProperties updated = new SuperProperties();
        if (properties == null) {
            return updated;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object rawValue = entry.getValue();
            if (rawValue instanceof String) {
                ((Properties)updated).put(entry.getKey(), PropertyPlaceHolderHelper.value((String)rawValue));
                continue;
            }
            ((Properties)updated).put(entry.getKey(), rawValue);
        }
        return updated;
    }

    public static void holdsWithUpdate(Properties props) {
        Properties toUpdate = PropertyPlaceHolderHelper.holds(props);
        props.putAll((Map<?, ?>)toUpdate);
    }

    private static class PropertiesLookup
    extends StrLookup<Object> {
        private static final Properties PROPERTIES = SystemInstance.get().getProperties();
        private static final Map<String, String> ENV = System.getenv();

        private PropertiesLookup() {
        }

        public String lookup(String key) {
            String value = PROPERTIES.getProperty(key);
            if (value != null) {
                return value;
            }
            value = ENV.get(key);
            if (value != null) {
                return value;
            }
            return key;
        }
    }
}

