/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.openejb.log.LoggerCreator;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.Logger;

public class JuliLogStream
implements LogStream {
    protected final LoggerCreator logger;
    protected final AtomicBoolean debug = new AtomicBoolean(false);
    protected final AtomicBoolean info = new AtomicBoolean(false);

    public JuliLogStream(LogCategory logCategory) {
        this.logger = new LoggerCreator(logCategory.getName());
    }

    @Override
    public boolean isFatalEnabled() {
        return LoggerCreator.Get.exec(this.logger, this.debug, this.info).isLoggable(Level.SEVERE);
    }

    @Override
    public void fatal(String message) {
        this.log(Level.SEVERE, message, null);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return LoggerCreator.Get.exec(this.logger, this.debug, this.info).isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String message) {
        this.log(Level.SEVERE, message, null);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return LoggerCreator.Get.exec(this.logger, this.debug, this.info).isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String message) {
        this.log(Level.WARNING, message, null);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    @Override
    public boolean isInfoEnabled() {
        LoggerCreator.Get.exec(this.logger, this.debug, this.info);
        return this.info.get();
    }

    @Override
    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        LoggerCreator.Get.levels(this.logger, this.debug, this.info);
        return this.debug.get();
    }

    @Override
    public void debug(String message) {
        this.log(Level.FINE, message, null);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    private void log(Level level, String message, Throwable t) {
        java.util.logging.Logger log = LoggerCreator.Get.exec(this.logger, this.debug, this.info);
        if (log.isLoggable(level)) {
            OpenEJBLogRecord logRecord = new OpenEJBLogRecord(level, message);
            if (t != null) {
                logRecord.setThrown(t);
            }
            log.log(logRecord);
        }
    }

    public static class OpenEJBLogRecord
    extends LogRecord {
        private String sourceClassName;
        private String sourceMethodName;
        private transient boolean sourceInited = false;

        public OpenEJBLogRecord(Level level, String message) {
            super(level, message);
        }

        @Override
        public String getSourceClassName() {
            this.initSource();
            return this.sourceClassName;
        }

        @Override
        public void setSourceClassName(String sourceClassName) {
            this.sourceInited = true;
            this.sourceClassName = sourceClassName;
        }

        @Override
        public String getSourceMethodName() {
            this.initSource();
            return this.sourceMethodName;
        }

        @Override
        public void setSourceMethodName(String sourceMethodName) {
            this.sourceInited = true;
            this.sourceMethodName = sourceMethodName;
        }

        private void initSource() {
            if (!this.sourceInited) {
                int i;
                StackTraceElement[] elements = new Throwable().getStackTrace();
                String current = null;
                for (i = 0; i < elements.length && !(current = elements[i].getClassName()).equals(Logger.class.getName()); ++i) {
                }
                while (++i < elements.length && elements[i].getClassName().equals(current)) {
                }
                if (i < elements.length) {
                    this.sourceClassName = elements[i].getClassName();
                    this.sourceMethodName = elements[i].getMethodName();
                }
                this.sourceInited = true;
            }
        }
    }
}

