/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.finder.ResourceFinder;

public final class EventHelper {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, EventHelper.class);

    private EventHelper() {
    }

    public static Collection<Class<?>> findExtensions(ResourceFinder finder) {
        try {
            return finder.findAvailableClasses("org.apache.openejb.extension");
        }
        catch (IOException e) {
            LOGGER.error("Extension scanning of 'META-INF/org.apache.openejb.extension' files failed", e);
            return Collections.emptySet();
        }
    }

    public static void installExtensions(ResourceFinder finder) {
        try {
            List classes = finder.findAvailableClasses("org.apache.openejb.extension");
            EventHelper.addEventClasses(classes);
        }
        catch (IOException e) {
            LOGGER.error("Extension scanning of 'META-INF/org.apache.openejb.extension' files failed", e);
        }
    }

    public static void addEventClasses(ClassLoader loader, Collection<String> classes) {
        for (String clazz : classes) {
            try {
                Object object = loader.loadClass(clazz).newInstance();
                SystemInstance.get().addObserver(object);
            }
            catch (Throwable t) {
                LOGGER.error("Extension construction failed" + clazz, t);
            }
        }
    }

    public static void addEventClasses(Collection<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            try {
                Object object = clazz.newInstance();
                SystemInstance.get().addObserver(object);
            }
            catch (Throwable t) {
                LOGGER.error("Extension construction failed" + clazz.getName(), t);
            }
        }
    }
}

