/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.resource.jdbc.dbcp.DbcpDataSourceCreator;
import org.apache.openejb.resource.jdbc.logging.LoggingSqlDataSource;
import org.apache.openejb.resource.jdbc.pool.DataSourceCreator;
import org.apache.openejb.resource.jdbc.pool.DefaultDataSourceCreator;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SuperProperties;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;

public class DataSourceFactory {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, DataSourceFactory.class);
    public static final String LOG_SQL_PROPERTY = "LogSql";
    public static final String GLOBAL_LOG_SQL_PROPERTY = "openejb.jdbc.log";
    public static final String POOL_PROPERTY = "openejb.datasource.pool";
    public static final String DATA_SOURCE_CREATOR_PROP = "DataSourceCreator";
    private static final Map<CommonDataSource, DataSourceCreator> creatorByDataSource = new HashMap<CommonDataSource, DataSourceCreator>();
    private static final Map<String, String> KNOWN_CREATORS = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER){
        {
            this.put("dbcp", "org.apache.openejb.resource.jdbc.pool.DefaultDataSourceCreator");
            this.put("dbcp-alternative", "org.apache.openejb.resource.jdbc.dbcp.DbcpDataSourceCreator");
            this.put("tomcat", "org.apache.tomee.jdbc.TomEEDataSourceCreator");
            this.put("bonecp", "org.apache.openejb.bonecp.BoneCPDataSourceCreator");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonDataSource create(String name, boolean configuredManaged, Class impl, String definition, Duration maxWaitTime, Duration timeBetweenEvictionRuns, Duration minEvictableIdleTime) throws IllegalAccessException, InstantiationException, IOException {
        Properties properties = DataSourceFactory.asProperties(definition);
        DataSourceFactory.convert(properties, maxWaitTime, "maxWaitTime", "maxWait");
        DataSourceFactory.convert(properties, timeBetweenEvictionRuns, "timeBetweenEvictionRuns", "timeBetweenEvictionRunsMillis");
        DataSourceFactory.convert(properties, minEvictableIdleTime, "minEvictableIdleTime", "minEvictableIdleTimeMillis");
        properties.remove("Definition");
        properties.remove("JtaManaged");
        properties.remove("ServiceId");
        boolean managed = configuredManaged;
        if (properties.containsKey("transactional")) {
            managed = Boolean.parseBoolean((String)properties.remove("transactional")) || managed;
        }
        boolean logSql = SystemInstance.get().getOptions().get(GLOBAL_LOG_SQL_PROPERTY, "true".equalsIgnoreCase((String)properties.remove(LOG_SQL_PROPERTY)));
        DataSourceCreator creator = DataSourceFactory.creator(properties.remove(DATA_SOURCE_CREATOR_PROP), logSql);
        boolean useContainerLoader = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.resources.use-container-loader", "true")) && (impl == null || impl.getClassLoader() == DataSourceFactory.class.getClassLoader());
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        if (useContainerLoader) {
            Thread.currentThread().setContextClassLoader(DataSourceFactory.class.getClassLoader());
        }
        try {
            CommonDataSource ds;
            if (DataSourceFactory.createDataSourceFromClass(impl)) {
                DataSourceFactory.trimNotSupportedDataSourceProperties(properties);
                ObjectRecipe recipe = new ObjectRecipe(impl);
                recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
                recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
                recipe.allow(Option.NAMED_PARAMETERS);
                recipe.setAllProperties((Map)properties);
                if (!properties.containsKey("url") && properties.containsKey("JdbcUrl")) {
                    recipe.setProperty("url", (Object)properties.getProperty("JdbcUrl"));
                }
                DataSource dataSource = (DataSource)recipe.create();
                ds = managed ? (DataSourceFactory.usePool(properties) ? creator.poolManaged(name, dataSource, properties) : creator.managed(name, dataSource)) : (DataSourceFactory.usePool(properties) ? creator.pool(name, dataSource, properties) : dataSource);
            } else {
                XAResourceWrapper xaResourceWrapper;
                ds = managed ? ((xaResourceWrapper = (XAResourceWrapper)SystemInstance.get().getComponent(XAResourceWrapper.class)) != null ? creator.poolManagedWithRecovery(name, xaResourceWrapper, impl.getName(), properties) : creator.poolManaged(name, impl.getName(), properties)) : creator.pool(name, impl.getName(), properties);
            }
            creatorByDataSource.put(ds, creator);
            if (logSql) {
                ds = (DataSource)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{DataSource.class}, (InvocationHandler)new LoggingSqlDataSource(ds));
            }
            CommonDataSource commonDataSource = ds;
            return commonDataSource;
        }
        finally {
            if (useContainerLoader) {
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }

    private static void convert(Properties properties, Duration duration, String key, String oldKey) {
        properties.remove(key);
        if (properties.contains(oldKey)) {
            return;
        }
        properties.remove(oldKey);
        if (duration == null) {
            return;
        }
        if (duration.getUnit() == null) {
            duration.setUnit(TimeUnit.MILLISECONDS);
        }
        long milliseconds = TimeUnit.MILLISECONDS.convert(duration.getTime(), duration.getUnit());
        properties.put(oldKey, milliseconds + "");
    }

    public static DataSourceCreator creator(Object creatorName, boolean willBeProxied) {
        DataSourceCreator defaultCreator = (DataSourceCreator)SystemInstance.get().getComponent(DataSourceCreator.class);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (creatorName != null && creatorName instanceof String && (defaultCreator == null || !creatorName.equals(defaultCreator.getClass().getName()))) {
            String clazz = KNOWN_CREATORS.get(creatorName);
            if (clazz == null) {
                clazz = (String)creatorName;
            }
            if (willBeProxied && clazz.equals(DefaultDataSourceCreator.class.getName())) {
                clazz = DbcpDataSourceCreator.class.getName();
            }
            try {
                return (DataSourceCreator)loader.loadClass(clazz).newInstance();
            }
            catch (Throwable e) {
                LOGGER.error("can't create '" + creatorName + "', the default one will be used: " + defaultCreator, e);
            }
        }
        if (defaultCreator instanceof DefaultDataSourceCreator && willBeProxied) {
            try {
                return (DataSourceCreator)loader.loadClass(DbcpDataSourceCreator.class.getName()).newInstance();
            }
            catch (Throwable e) {
                LOGGER.error("can't create '" + creatorName + "', the default one will be used: " + defaultCreator, e);
            }
        }
        return defaultCreator;
    }

    private static boolean createDataSourceFromClass(Class<?> impl) {
        return DataSource.class.isAssignableFrom(impl) && !SystemInstance.get().getOptions().get("org.apache.openejb.resource.jdbc.hot.deploy", false);
    }

    private static boolean usePool(Properties properties) {
        return "true".equalsIgnoreCase(properties.getProperty(POOL_PROPERTY, "true"));
    }

    private static Properties asProperties(String definition) throws IOException {
        SuperProperties properties = new SuperProperties();
        properties.caseInsensitive(true);
        properties.putAll((Map<?, ?>)IO.readProperties((InputStream)IO.read((String)definition), (Properties)new Properties()));
        return properties;
    }

    public static void trimNotSupportedDataSourceProperties(Properties properties) {
        properties.remove("LoginTimeout");
    }

    public static boolean knows(Object object) {
        return object instanceof CommonDataSource && creatorByDataSource.containsKey(object);
    }

    public static ObjectRecipe forgetRecipe(Object rawObject, ObjectRecipe defaultValue) {
        Object object = DataSourceFactory.realInstance(rawObject);
        DataSourceCreator creator = creatorByDataSource.get(object);
        ObjectRecipe recipe = null;
        if (creator != null) {
            recipe = creator.clearRecipe(object);
        }
        if (recipe == null) {
            return defaultValue;
        }
        return recipe;
    }

    public static void destroy(Object o) throws Throwable {
        Object instance = DataSourceFactory.realInstance(o);
        if (instance == null) {
            return;
        }
        DataSourceCreator remove = creatorByDataSource.remove(instance);
        remove.destroy(instance);
    }

    private static Object realInstance(Object o) {
        InvocationHandler handler;
        if (o == null || !(o instanceof DataSource)) {
            return o;
        }
        if (Proxy.isProxyClass(o.getClass()) && (handler = Proxy.getInvocationHandler(o)) instanceof LoggingSqlDataSource) {
            return ((LoggingSqlDataSource)handler).getDelegate();
        }
        return o;
    }
}

