/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.XATerminator;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.geronimo.connector.GeronimoBootstrapContext;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.connector.work.HintsContextHandler;
import org.apache.geronimo.connector.work.TransactionContextHandler;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.XAWork;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentContext;
import org.apache.openejb.DuplicateDeploymentIdException;
import org.apache.openejb.Injection;
import org.apache.openejb.JndiConstants;
import org.apache.openejb.MethodContext;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ApplicationExceptionInfo;
import org.apache.openejb.assembler.classic.AssemblerTool;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.CmpJarBuilder;
import org.apache.openejb.assembler.classic.CommonInfoObject;
import org.apache.openejb.assembler.classic.ConnectionManagerInfo;
import org.apache.openejb.assembler.classic.ConnectorInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.ContainerSystemInfo;
import org.apache.openejb.assembler.classic.DeployTimeEnhancer;
import org.apache.openejb.assembler.classic.DeploymentExceptionManager;
import org.apache.openejb.assembler.classic.DeploymentListener;
import org.apache.openejb.assembler.classic.EjbJarBuilder;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EjbResolver;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.FacilitiesInfo;
import org.apache.openejb.assembler.classic.ImportSql;
import org.apache.openejb.assembler.classic.InjectionBuilder;
import org.apache.openejb.assembler.classic.JaccPermissionsBuilder;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.assembler.classic.JndiContextInfo;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.LazyValidator;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.MethodConcurrencyBuilder;
import org.apache.openejb.assembler.classic.MethodTransactionBuilder;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.OpenEjbConfigurationFactory;
import org.apache.openejb.assembler.classic.PersistenceBuilder;
import org.apache.openejb.assembler.classic.PersistenceUnitInfo;
import org.apache.openejb.assembler.classic.PolicyContext;
import org.apache.openejb.assembler.classic.ProxyFactoryInfo;
import org.apache.openejb.assembler.classic.ReloadableEntityManagerFactory;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.apache.openejb.assembler.classic.ValidatorBuilder;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.assembler.classic.event.AssemblerAfterApplicationCreated;
import org.apache.openejb.assembler.classic.event.AssemblerBeforeApplicationDestroyed;
import org.apache.openejb.assembler.classic.event.AssemblerCreated;
import org.apache.openejb.assembler.classic.event.AssemblerDestroyed;
import org.apache.openejb.assembler.classic.event.ContainerSystemPostCreate;
import org.apache.openejb.assembler.classic.event.ContainerSystemPreDestroy;
import org.apache.openejb.assembler.monitoring.JMXContainer;
import org.apache.openejb.async.AsynchronousPool;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiBuilder;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.openejb.cdi.CdiScanner;
import org.apache.openejb.cdi.CustomELAdapter;
import org.apache.openejb.cdi.ManagedSecurityService;
import org.apache.openejb.cdi.OpenEJBJndiService;
import org.apache.openejb.cdi.OpenEJBTransactionService;
import org.apache.openejb.cdi.OptimizedLoaderService;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.CompositeClassLoaderConfigurer;
import org.apache.openejb.component.ClassLoaderEnricher;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.QuickJarsTxtParser;
import org.apache.openejb.config.TldScanner;
import org.apache.openejb.core.ConnectorReference;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.CoreUserTransaction;
import org.apache.openejb.core.JndiFactory;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.SimpleTransactionSynchronizationRegistry;
import org.apache.openejb.core.TransactionSynchronizationRegistryWrapper;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.ivm.naming.ContextualJndiReference;
import org.apache.openejb.core.ivm.naming.IvmContext;
import org.apache.openejb.core.ivm.naming.IvmJndiFactory;
import org.apache.openejb.core.security.SecurityContextHandler;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.MemoryTimerStore;
import org.apache.openejb.core.timer.NullEjbTimerServiceImpl;
import org.apache.openejb.core.timer.ScheduleData;
import org.apache.openejb.core.timer.TimerStore;
import org.apache.openejb.core.transaction.JtaTransactionPolicyFactory;
import org.apache.openejb.core.transaction.SimpleBootstrapContext;
import org.apache.openejb.core.transaction.SimpleWorkManager;
import org.apache.openejb.core.transaction.TransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.javaagent.Agent;
import org.apache.openejb.jpa.integration.MakeTxLookup;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.DynamicMBeanWrapper;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.monitoring.remote.RemoteResourceMonitor;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.persistence.PersistenceClassLoaderHandler;
import org.apache.openejb.resource.GeronimoConnectionManagerFactory;
import org.apache.openejb.resource.jdbc.DataSourceFactory;
import org.apache.openejb.resource.jdbc.managed.local.ManagedDataSource;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Contexts;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.EventHelper;
import org.apache.openejb.util.JndiTreeBrowser;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.OpenEJBErrorHandler;
import org.apache.openejb.util.PropertiesHelper;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.openejb.util.References;
import org.apache.openejb.util.SafeToolkit;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.proxy.ProxyFactory;
import org.apache.openejb.util.proxy.ProxyManager;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.logger.JULLoggerFactory;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.xbean.finder.ClassLoaders;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.UnsetPropertiesRecipe;
import org.quartz.Scheduler;

public class Assembler
extends AssemblerTool
implements org.apache.openejb.spi.Assembler,
JndiConstants {
    public static final String OPENEJB_URL_PKG_PREFIX;
    public static final Logger logger;
    public static final String OPENEJB_JPA_DEPLOY_TIME_ENHANCEMENT_PROP = "openejb.jpa.deploy-time-enhancement";
    public static final String PROPAGATE_APPLICATION_EXCEPTIONS = "openejb.propagate.application-exceptions";
    private static final String GLOBAL_UNIQUE_ID = "global";
    public static final String TIMER_STORE_CLASS = "timerStore.class";
    private static final ReentrantLock lock;
    private final boolean skipLoaderIfPossible;
    Messages messages = new Messages(Assembler.class.getPackage().getName());
    private final CoreContainerSystem containerSystem;
    private final PersistenceClassLoaderHandler persistenceClassLoaderHandler;
    private final JndiBuilder jndiBuilder;
    private TransactionManager transactionManager;
    private org.apache.openejb.spi.SecurityService securityService;
    protected OpenEjbConfigurationFactory configFactory;
    private final Map<String, AppInfo> deployedApplications = new HashMap<String, AppInfo>();
    private final Map<ObjectName, CreationalContext> creationalContextForAppMbeans = new HashMap<ObjectName, CreationalContext>();
    private final Set<String> moduleIds = new HashSet<String>();
    private final Set<ObjectName> containerObjectNames = new HashSet<ObjectName>();
    private final RemoteResourceMonitor remoteResourceMonitor = new RemoteResourceMonitor();
    protected SafeToolkit toolkit = SafeToolkit.getToolkit("Assembler");
    protected OpenEjbConfiguration config;
    private static final ThreadLocal<Map<String, Object>> context;

    @Override
    public ContainerSystem getContainerSystem() {
        return this.containerSystem;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public org.apache.openejb.spi.SecurityService getSecurityService() {
        return this.securityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeploymentListener(DeploymentListener deploymentListener) {
        ReentrantLock l = lock;
        l.lock();
        try {
            logger.warning("DeploymentListener API is replaced by @Observes event");
            SystemInstance.get().addObserver((Object)new DeploymentListenerObserver(deploymentListener));
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeploymentListener(DeploymentListener deploymentListener) {
        ReentrantLock l = lock;
        l.lock();
        try {
            SystemInstance.get().removeObserver((Object)new DeploymentListenerObserver(deploymentListener));
        }
        finally {
            l.unlock();
        }
    }

    public Assembler() {
        this(new IvmJndiFactory());
    }

    public Assembler(JndiFactory jndiFactory) {
        this.skipLoaderIfPossible = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.classloader.skip-app-loader-if-possible", "true"));
        this.persistenceClassLoaderHandler = new PersistenceClassLoaderHandlerImpl();
        Assembler.installNaming();
        SystemInstance system = SystemInstance.get();
        system.setComponent(org.apache.openejb.spi.Assembler.class, (Object)this);
        system.setComponent(Assembler.class, (Object)this);
        this.containerSystem = new CoreContainerSystem(jndiFactory);
        system.setComponent(ContainerSystem.class, (Object)this.containerSystem);
        this.jndiBuilder = new JndiBuilder(this.containerSystem.getJNDIContext());
        this.setConfiguration(new OpenEjbConfiguration());
        ApplicationServer appServer = (ApplicationServer)system.getComponent(ApplicationServer.class);
        if (appServer == null) {
            system.setComponent(ApplicationServer.class, (Object)new ServerFederation());
        }
        system.setComponent(EjbResolver.class, (Object)new EjbResolver(null, EjbResolver.Scope.GLOBAL, new EjbJarInfo[0]));
        this.installExtensions();
        system.fireEvent((Object)new AssemblerCreated());
    }

    private void installExtensions() {
        try {
            List urls = NewLoaderLogic.applyBuiltinExcludes(new UrlSet(Assembler.class.getClassLoader()).excludeJvm()).getUrls();
            EventHelper.installExtensions(new ResourceFinder("META-INF", urls.toArray(new URL[urls.size()])));
            return;
        }
        catch (MalformedURLException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        EventHelper.installExtensions(new ResourceFinder("META-INF"));
    }

    private void setConfiguration(OpenEjbConfiguration config) {
        this.config = config;
        if (config.containerSystem == null) {
            config.containerSystem = new ContainerSystemInfo();
        }
        if (config.facilities == null) {
            config.facilities = new FacilitiesInfo();
        }
        SystemInstance.get().setComponent(OpenEjbConfiguration.class, (Object)this.config);
    }

    @Override
    public void init(Properties props) throws OpenEJBException {
        this.props = new Properties(props);
        Options options = new Options(props, SystemInstance.get().getOptions());
        String className = options.get("openejb.configurator", "org.apache.openejb.config.ConfigurationFactory");
        this.configFactory = "org.apache.openejb.config.ConfigurationFactory".equals(className) ? new ConfigurationFactory() : (OpenEjbConfigurationFactory)this.toolkit.newInstance(className);
        this.configFactory.init(props);
        SystemInstance.get().setComponent(OpenEjbConfigurationFactory.class, (Object)this.configFactory);
    }

    public static void installNaming() {
        if (SystemInstance.get().hasProperty("openejb.geronimo")) {
            return;
        }
        Assembler.installNaming(OPENEJB_URL_PKG_PREFIX);
    }

    public static void installNaming(String prefix) {
        Assembler.installNaming(prefix, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installNaming(String prefix, boolean clean) {
        ReentrantLock l = lock;
        l.lock();
        try {
            Properties systemProperties = System.getProperties();
            String str = systemProperties.getProperty("java.naming.factory.url.pkgs");
            if (str == null || clean) {
                str = prefix;
            } else if (!str.contains(prefix)) {
                str = str + ":" + prefix;
            }
            systemProperties.setProperty("java.naming.factory.url.pkgs", str);
        }
        finally {
            l.unlock();
        }
    }

    public static void setContext(Map<String, Object> map) {
        context.set(map);
    }

    public static Map<String, Object> getContext() {
        Map<String, Object> map = context.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            context.set(map);
        }
        return map;
    }

    @Override
    public void build() throws OpenEJBException {
        Assembler.setContext(new HashMap<String, Object>());
        try {
            OpenEjbConfiguration config = this.getOpenEjbConfiguration();
            this.buildContainerSystem(config);
        }
        catch (OpenEJBException ae) {
            throw ae;
        }
        catch (Exception e) {
            OpenEJBErrorHandler.handleUnknownError(e, "Assembler");
            throw new OpenEJBException(e);
        }
        finally {
            context.set(null);
        }
    }

    protected OpenEjbConfiguration getOpenEjbConfiguration() throws OpenEJBException {
        return this.configFactory.getOpenEjbConfiguration();
    }

    public void buildContainerSystem(OpenEjbConfiguration configInfo) throws Exception {
        if (SystemInstance.get().getOptions().get(OPENEJB_JPA_DEPLOY_TIME_ENHANCEMENT_PROP, false)) {
            SystemInstance.get().addObserver((Object)new DeployTimeEnhancer());
        }
        for (ServiceInfo serviceInfo : configInfo.facilities.services) {
            this.createService(serviceInfo);
        }
        ContainerSystemInfo containerSystemInfo = configInfo.containerSystem;
        if (configInfo.facilities.intraVmServer != null) {
            this.createProxyFactory(configInfo.facilities.intraVmServer);
        }
        for (JndiContextInfo contextInfo : configInfo.facilities.remoteJndiContexts) {
            this.createExternalContext(contextInfo);
        }
        this.createTransactionManager(configInfo.facilities.transactionService);
        this.createSecurityService(configInfo.facilities.securityService);
        for (ResourceInfo resourceInfo : configInfo.facilities.resources) {
            this.createResource(resourceInfo);
        }
        for (ContainerInfo serviceInfo : containerSystemInfo.containers) {
            this.createContainer(serviceInfo);
        }
        this.createJavaGlobal();
        for (AppInfo appInfo : containerSystemInfo.applications) {
            try {
                this.createApplication(appInfo, this.createAppClassLoader(appInfo));
            }
            catch (DuplicateDeploymentIdException e) {
            }
            catch (Throwable e) {
                logger.error("appNotDeployed", e, appInfo.path);
                DeploymentExceptionManager exceptionManager = (DeploymentExceptionManager)SystemInstance.get().getComponent(DeploymentExceptionManager.class);
                if (exceptionManager == null || !(e instanceof Exception)) continue;
                exceptionManager.saveDeploymentException(appInfo, (Exception)e);
            }
        }
        SystemInstance.get().fireEvent((Object)new ContainerSystemPostCreate());
    }

    private void createJavaGlobal() {
        try {
            this.containerSystem.getJNDIContext().createSubcontext(GLOBAL_UNIQUE_ID);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public boolean isDeployed(String path) {
        return this.deployedApplications.containsKey(ProvisioningUtil.realLocation((String)path));
    }

    public Collection<AppInfo> getDeployedApplications() {
        return new ArrayList<AppInfo>(this.deployedApplications.values());
    }

    public AppContext createApplication(EjbJarInfo ejbJar) throws NamingException, IOException, OpenEJBException {
        return this.createEjbJar(ejbJar);
    }

    public AppContext createEjbJar(EjbJarInfo ejbJar) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = ejbJar.path;
        appInfo.appId = ejbJar.moduleName;
        appInfo.ejbJars.add(ejbJar);
        return this.createApplication(appInfo);
    }

    public AppContext createApplication(EjbJarInfo ejbJar, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        return this.createEjbJar(ejbJar, classLoader);
    }

    public AppContext createEjbJar(EjbJarInfo ejbJar, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = ejbJar.path;
        appInfo.appId = ejbJar.moduleName;
        appInfo.ejbJars.add(ejbJar);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createClient(ClientInfo clientInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = clientInfo.path;
        appInfo.appId = clientInfo.moduleId;
        appInfo.clients.add(clientInfo);
        return this.createApplication(appInfo);
    }

    public AppContext createClient(ClientInfo clientInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = clientInfo.path;
        appInfo.appId = clientInfo.moduleId;
        appInfo.clients.add(clientInfo);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createConnector(ConnectorInfo connectorInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = connectorInfo.path;
        appInfo.appId = connectorInfo.moduleId;
        appInfo.connectors.add(connectorInfo);
        return this.createApplication(appInfo);
    }

    public AppContext createConnector(ConnectorInfo connectorInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = connectorInfo.path;
        appInfo.appId = connectorInfo.moduleId;
        appInfo.connectors.add(connectorInfo);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createWebApp(WebAppInfo webAppInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = webAppInfo.path;
        appInfo.appId = webAppInfo.moduleId;
        appInfo.webApps.add(webAppInfo);
        return this.createApplication(appInfo);
    }

    public AppContext createWebApp(WebAppInfo webAppInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = webAppInfo.path;
        appInfo.appId = webAppInfo.moduleId;
        appInfo.webApps.add(webAppInfo);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createApplication(AppInfo appInfo) throws OpenEJBException, IOException, NamingException {
        return this.createApplication(appInfo, this.createAppClassLoader(appInfo));
    }

    public AppContext createApplication(AppInfo appInfo, ClassLoader classLoader) throws OpenEJBException, IOException, NamingException {
        return this.createApplication(appInfo, classLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AppContext createApplication(AppInfo appInfo, ClassLoader classLoader, boolean start) throws OpenEJBException, IOException, NamingException {
        if (appInfo.appId == null) {
            throw new IllegalArgumentException("AppInfo.appId cannot be null");
        }
        if (appInfo.path == null) {
            appInfo.path = appInfo.appId;
        }
        EventHelper.addEventClasses(classLoader, appInfo.eventClassesNeedingAppClassloader);
        logger.info("createApplication.start", appInfo.path);
        ArrayList<String> used = new ArrayList<String>();
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            for (EnterpriseBeanInfo beanInfo : ejbJarInfo.enterpriseBeans) {
                if (this.containerSystem.getBeanContext(beanInfo.ejbDeploymentId) == null) continue;
                used.add(beanInfo.ejbDeploymentId);
            }
        }
        if (used.size() > 0) {
            String message = logger.error("createApplication.appFailedDuplicateIds", appInfo.path);
            for (String id : used) {
                logger.error("createApplication.deploymentIdInUse", id);
                message = message + "\n    " + id;
            }
            throw new DuplicateDeploymentIdException(message);
        }
        InjectionBuilder injectionBuilder = new InjectionBuilder(classLoader);
        HashSet<Injection> injections = new HashSet<Injection>();
        injections.addAll(injectionBuilder.buildInjections(appInfo.globalJndiEnc));
        injections.addAll(injectionBuilder.buildInjections(appInfo.appJndiEnc));
        JndiEncBuilder globalBuilder = new JndiEncBuilder(appInfo.globalJndiEnc, injections, appInfo.appId, null, GLOBAL_UNIQUE_ID, classLoader);
        Map<String, Object> globalBindings = globalBuilder.buildBindings(JndiEncBuilder.JndiScope.global);
        Context globalJndiContext = globalBuilder.build(globalBindings);
        JndiEncBuilder appBuilder = new JndiEncBuilder(appInfo.appJndiEnc, injections, appInfo.appId, null, appInfo.appId, classLoader);
        Map<String, Object> appBindings = appBuilder.buildBindings(JndiEncBuilder.JndiScope.app);
        Context appJndiContext = appBuilder.build(appBindings);
        try {
            ReloadableEntityManagerFactory factory;
            CmpJarBuilder cmpJarBuilder = new CmpJarBuilder(appInfo, classLoader);
            File generatedJar = cmpJarBuilder.getJarFile();
            if (generatedJar != null) {
                classLoader = ClassLoaderUtil.createClassLoader(appInfo.path, new URL[]{generatedJar.toURI().toURL()}, classLoader);
            }
            AppContext appContext = new AppContext(appInfo.appId, SystemInstance.get(), classLoader, globalJndiContext, appJndiContext, appInfo.standaloneModule);
            appContext.getProperties().putAll((Map<?, ?>)appInfo.properties);
            appContext.getInjections().addAll(injections);
            appContext.getBindings().putAll(globalBindings);
            appContext.getBindings().putAll(appBindings);
            this.containerSystem.addAppContext(appContext);
            appContext.set(AsynchronousPool.class, AsynchronousPool.create(appContext));
            Context containerSystemContext = this.containerSystem.getJNDIContext();
            if (!SystemInstance.get().hasProperty("openejb.geronimo")) {
                ArrayList<CommonInfoObject> vfs = new ArrayList<CommonInfoObject>();
                for (ClientInfo clientInfo : appInfo.clients) {
                    vfs.add(clientInfo);
                }
                for (ConnectorInfo connectorInfo : appInfo.connectors) {
                    vfs.add(connectorInfo);
                }
                for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
                    vfs.add(ejbJarInfo);
                }
                for (WebAppInfo webAppInfo : appInfo.webApps) {
                    vfs.add(webAppInfo);
                }
                HashMap<String, ReloadableEntityManagerFactory> validatorFactories = new HashMap<String, ReloadableEntityManagerFactory>();
                for (CommonInfoObject commonInfoObject : vfs) {
                    factory = null;
                    try {
                        factory = ValidatorBuilder.buildFactory(classLoader, commonInfoObject.validationInfo);
                    }
                    catch (ValidationException ve) {
                        logger.warning("can't build the validation factory for module " + commonInfoObject.uniqueId, ve);
                    }
                    if (factory == null) continue;
                    validatorFactories.put(commonInfoObject.uniqueId, factory);
                }
                this.moduleIds.addAll(validatorFactories.keySet());
                for (Map.Entry entry : validatorFactories.entrySet()) {
                    String id = (String)entry.getKey();
                    ValidatorFactory factory2 = (ValidatorFactory)entry.getValue();
                    try {
                        Validator validator;
                        containerSystemContext.bind("openejb/ValidatorFactory/" + id, (Object)factory2);
                        try {
                            validator = factory2.usingContext().getValidator();
                        }
                        catch (Exception e) {
                            validator = (Validator)Proxy.newProxyInstance(appContext.getClassLoader(), new Class[]{Validator.class}, (InvocationHandler)new LazyValidator(factory2));
                        }
                        containerSystemContext.bind("openejb/Validator/" + id, (Object)validator);
                    }
                    catch (NameAlreadyBoundException e) {
                        throw new OpenEJBException("ValidatorFactory already exists for module " + id, e);
                    }
                    catch (Exception e) {
                        throw new OpenEJBException(e);
                    }
                }
            }
            HashMap<String, String> units = new HashMap<String, String>();
            PersistenceBuilder persistenceBuilder = new PersistenceBuilder(this.persistenceClassLoaderHandler);
            for (PersistenceUnitInfo persistenceUnitInfo : appInfo.persistenceUnits) {
                try {
                    factory = persistenceBuilder.createEntityManagerFactory(persistenceUnitInfo, classLoader);
                    this.containerSystem.getJNDIContext().bind("openejb/PersistenceUnit/" + persistenceUnitInfo.id, (Object)factory);
                    units.put(persistenceUnitInfo.name, "openejb/PersistenceUnit/" + persistenceUnitInfo.id);
                }
                catch (NameAlreadyBoundException e) {
                    throw new OpenEJBException("PersistenceUnit already deployed: " + persistenceUnitInfo.persistenceUnitRootUrl);
                }
                catch (Exception e) {
                    throw new OpenEJBException(e);
                }
                factory.register();
            }
            logger.debug("Loaded peristence units: " + units);
            for (ConnectorInfo connectorInfo : appInfo.connectors) {
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    if (connectorInfo.resourceAdapter != null) {
                        this.createResource(connectorInfo.resourceAdapter);
                    }
                    for (ResourceInfo outbound : connectorInfo.outbound) {
                        this.createResource(outbound);
                        outbound.properties.setProperty("openejb.connector", "true");
                    }
                    for (MdbContainerInfo inbound : connectorInfo.inbound) {
                        this.createContainer(inbound);
                    }
                    for (ResourceInfo adminObject : connectorInfo.adminObject) {
                        this.createResource(adminObject);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
            List<BeanContext> allDeployments = this.initEjbs(classLoader, appInfo, appContext, injections, new ArrayList<BeanContext>(), null);
            if ("true".equalsIgnoreCase(SystemInstance.get().getProperty(PROPAGATE_APPLICATION_EXCEPTIONS, appInfo.properties.getProperty(PROPAGATE_APPLICATION_EXCEPTIONS, "false")))) {
                this.propagateApplicationExceptions(appInfo, classLoader, allDeployments);
            }
            if ("true".equalsIgnoreCase(appInfo.properties.getProperty("openejb.cdi.activated", "true"))) {
                new CdiBuilder().build(appInfo, appContext, allDeployments);
                this.ensureWebBeansContext(appContext);
                appJndiContext.bind("app/BeanManager", (Object)appContext.getBeanManager());
                appContext.getBindings().put("app/BeanManager", appContext.getBeanManager());
            }
            this.startEjbs(start, allDeployments);
            for (ClientInfo clientInfo : appInfo.clients) {
                List<Injection> clientInjections = injectionBuilder.buildInjections(clientInfo.jndiEnc);
                JndiEncBuilder jndiEncBuilder = new JndiEncBuilder(clientInfo.jndiEnc, clientInjections, "Bean", clientInfo.moduleId, null, clientInfo.uniqueId, classLoader);
                if (clientInfo.remoteClients.size() > 0 || clientInfo.localClients.size() == 0) {
                    jndiEncBuilder.setClient(true);
                }
                jndiEncBuilder.setUseCrossClassLoaderRef(false);
                Context context = jndiEncBuilder.build(JndiEncBuilder.JndiScope.comp);
                containerSystemContext.bind("openejb/client/" + clientInfo.moduleId, (Object)context);
                if (clientInfo.path != null) {
                    context.bind("info/path", (Object)clientInfo.path);
                }
                if (clientInfo.mainClass != null) {
                    context.bind("info/mainClass", (Object)clientInfo.mainClass);
                }
                if (clientInfo.callbackHandler != null) {
                    context.bind("info/callbackHandler", (Object)clientInfo.callbackHandler);
                }
                context.bind("info/injections", clientInjections);
                for (String clientClassName : clientInfo.remoteClients) {
                    containerSystemContext.bind("openejb/client/" + clientClassName, (Object)clientInfo.moduleId);
                }
                for (String clientClassName : clientInfo.localClients) {
                    containerSystemContext.bind("openejb/client/" + clientClassName, (Object)clientInfo.moduleId);
                    logger.getChildLogger("client").info("createApplication.createLocalClient", clientClassName, clientInfo.moduleId);
                }
            }
            SystemInstance systemInstance = SystemInstance.get();
            WebAppBuilder webAppBuilder = (WebAppBuilder)systemInstance.getComponent(WebAppBuilder.class);
            if (webAppBuilder != null) {
                webAppBuilder.deployWebApps(appInfo, classLoader);
            }
            if (start) {
                EjbResolver globalEjbResolver = (EjbResolver)systemInstance.getComponent(EjbResolver.class);
                globalEjbResolver.addAll(appInfo.ejbJars);
            }
            this.bindGlobals(appContext.getBindings());
            for (String mbean : appInfo.mbeans) {
                this.deployMBean(appContext.getWebBeansContext(), classLoader, mbean, appInfo.jmx, appInfo.appId);
            }
            for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
                for (String mbean : ejbJarInfo.mbeans) {
                    this.deployMBean(appContext.getWebBeansContext(), classLoader, mbean, appInfo.jmx, ejbJarInfo.moduleName);
                }
            }
            for (ConnectorInfo connectorInfo : appInfo.connectors) {
                for (String mbean : connectorInfo.mbeans) {
                    this.deployMBean(appContext.getWebBeansContext(), classLoader, mbean, appInfo.jmx, appInfo.appId + ".add-lib");
                }
            }
            this.deployedApplications.put(appInfo.path, appInfo);
            systemInstance.fireEvent((Object)new AssemblerAfterApplicationCreated(appInfo, allDeployments));
            logger.info("createApplication.success", appInfo.path);
            this.resumePersistentSchedulers(appContext);
            return appContext;
        }
        catch (ValidationException ve) {
            throw ve;
        }
        catch (Throwable t) {
            try {
                this.destroyApplication(appInfo);
            }
            catch (Exception e1) {
                logger.debug("createApplication.undeployFailed", e1, appInfo.path);
            }
            throw new OpenEJBException(this.messages.format("createApplication.failed", appInfo.path), t);
        }
    }

    public void bindGlobals(Map<String, Object> bindings) throws NamingException {
        Context containerSystemContext = this.containerSystem.getJNDIContext();
        for (Map.Entry<String, Object> value : bindings.entrySet()) {
            String path = value.getKey();
            if (path.startsWith("module/") || path.startsWith("app/") || path.startsWith("comp/") || path.equalsIgnoreCase("global/dummy")) continue;
            Context lastContext = Contexts.createSubcontexts(containerSystemContext, path);
            try {
                lastContext.rebind(path.substring(path.lastIndexOf("/") + 1, path.length()), value.getValue());
            }
            catch (NameAlreadyBoundException nabe) {
                nabe.printStackTrace();
            }
            containerSystemContext.rebind(path, value.getValue());
        }
    }

    private void propagateApplicationExceptions(AppInfo appInfo, ClassLoader classLoader, List<BeanContext> allDeployments) {
        for (BeanContext context : allDeployments) {
            if (BeanContext.Comp.class.equals((Object)context.getBeanClass())) continue;
            for (EjbJarInfo jar : appInfo.ejbJars) {
                for (ApplicationExceptionInfo exception : jar.applicationException) {
                    try {
                        Class<?> exceptionClass = classLoader.loadClass(exception.exceptionClass);
                        context.addApplicationException(exceptionClass, exception.rollback, exception.inherited);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private void resumePersistentSchedulers(AppContext appContext) {
        Scheduler globalScheduler = (Scheduler)SystemInstance.get().getComponent(Scheduler.class);
        ArrayList<Scheduler> schedulers = new ArrayList<Scheduler>();
        for (BeanContext ejb : appContext.getBeanContexts()) {
            Scheduler scheduler = ejb.get(Scheduler.class);
            if (scheduler == null || scheduler == globalScheduler || schedulers.contains(scheduler)) continue;
            schedulers.add(scheduler);
            try {
                scheduler.resumeAll();
            }
            catch (Exception e) {
                logger.warning("Can't resume scheduler for " + ejb.getEjbName(), e);
            }
        }
    }

    public List<BeanContext> initEjbs(ClassLoader classLoader, AppInfo appInfo, AppContext appContext, Set<Injection> injections, List<BeanContext> allDeployments, String webappId) throws OpenEJBException {
        EjbJarBuilder ejbJarBuilder = new EjbJarBuilder(this.props, appContext);
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            boolean skip = false;
            if (!appInfo.webAppAlone) {
                if (webappId == null) {
                    skip = ejbJar.webapp;
                } else if (!ejbJar.webapp || !ejbJar.moduleId.equals(webappId)) {
                    skip = true;
                }
            }
            if (skip) continue;
            HashMap<String, BeanContext> deployments = ejbJarBuilder.build(ejbJar, injections, classLoader);
            JaccPermissionsBuilder jaccPermissionsBuilder = new JaccPermissionsBuilder();
            PolicyContext policyContext = jaccPermissionsBuilder.build(ejbJar, deployments);
            jaccPermissionsBuilder.install(policyContext);
            TransactionPolicyFactory transactionPolicyFactory = this.createTransactionPolicyFactory(ejbJar, classLoader);
            for (BeanContext beanContext : deployments.values()) {
                beanContext.setTransactionPolicyFactory(transactionPolicyFactory);
            }
            MethodTransactionBuilder methodTransactionBuilder = new MethodTransactionBuilder();
            methodTransactionBuilder.build(deployments, ejbJar.methodTransactions);
            MethodConcurrencyBuilder methodConcurrencyBuilder = new MethodConcurrencyBuilder();
            methodConcurrencyBuilder.build(deployments, ejbJar.methodConcurrency);
            for (BeanContext beanContext : deployments.values()) {
                this.containerSystem.addDeployment(beanContext);
            }
            this.jndiBuilder.build(ejbJar, deployments);
            for (BeanContext beanContext : deployments.values()) {
                if (beanContext.getComponentType() != BeanType.STATEFUL) {
                    Method ejbTimeout = beanContext.getEjbTimeout();
                    boolean timerServiceRequired = false;
                    if (ejbTimeout != null) {
                        if (beanContext.getTransactionType(ejbTimeout) == TransactionType.RequiresNew) {
                            beanContext.setMethodTransactionAttribute(ejbTimeout, TransactionType.Required);
                        }
                        timerServiceRequired = true;
                    }
                    Iterator<Map.Entry<Method, MethodContext>> it = beanContext.iteratorMethodContext();
                    while (it.hasNext()) {
                        Map.Entry<Method, MethodContext> entry = it.next();
                        MethodContext methodContext = entry.getValue();
                        if (methodContext.getSchedules().size() <= 0) continue;
                        timerServiceRequired = true;
                        Method method = entry.getKey();
                        if (beanContext.getTransactionType(method) != TransactionType.RequiresNew) continue;
                        beanContext.setMethodTransactionAttribute(method, TransactionType.Required);
                    }
                    if (timerServiceRequired) {
                        EjbTimerServiceImpl timerService = new EjbTimerServiceImpl(beanContext, Assembler.newTimerStore(beanContext));
                        TimerStore timerStore = timerService.getTimerStore();
                        Iterator<Map.Entry<Method, MethodContext>> it2 = beanContext.iteratorMethodContext();
                        while (it2.hasNext()) {
                            Map.Entry<Method, MethodContext> entry = it2.next();
                            MethodContext methodContext = entry.getValue();
                            for (ScheduleData scheduleData : methodContext.getSchedules()) {
                                timerStore.createCalendarTimer(timerService, (String)beanContext.getDeploymentID(), null, entry.getKey(), scheduleData.getExpression(), scheduleData.getConfig(), true);
                            }
                        }
                        beanContext.setEjbTimerService(timerService);
                    } else {
                        beanContext.setEjbTimerService(new NullEjbTimerServiceImpl());
                    }
                }
                Iterator<Map.Entry<Method, MethodContext>> it = beanContext.iteratorMethodContext();
                while (it.hasNext()) {
                    Map.Entry<Method, MethodContext> entry = it.next();
                    if (!entry.getValue().isAsynchronous() || beanContext.getTransactionType(entry.getKey()) != TransactionType.RequiresNew) continue;
                    beanContext.setMethodTransactionAttribute(entry.getKey(), TransactionType.Required);
                }
            }
            for (ApplicationExceptionInfo exceptionInfo : ejbJar.applicationException) {
                try {
                    Class<?> exceptionClass = classLoader.loadClass(exceptionInfo.exceptionClass);
                    for (BeanContext beanContext : deployments.values()) {
                        beanContext.addApplicationException(exceptionClass, exceptionInfo.rollback, exceptionInfo.inherited);
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.error("createApplication.invalidClass", e, exceptionInfo.exceptionClass, e.getMessage());
                }
            }
            allDeployments.addAll(deployments.values());
        }
        List<BeanContext> ejbs = Assembler.sort(allDeployments);
        appContext.getBeanContexts().addAll(ejbs);
        return ejbs;
    }

    private static TimerStore newTimerStore(BeanContext beanContext) {
        for (DeploymentContext context : Arrays.asList(beanContext, beanContext.getModuleContext(), beanContext.getModuleContext().getAppContext())) {
            String timerStoreClass = context.getProperties().getProperty(TIMER_STORE_CLASS);
            if (timerStoreClass == null) continue;
            logger.info("Found timer class: " + timerStoreClass);
            try {
                Class<?> clazz = beanContext.getClassLoader().loadClass(timerStoreClass);
                try {
                    Constructor<?> constructor = clazz.getConstructor(TransactionManager.class);
                    return (TimerStore)TimerStore.class.cast(constructor.newInstance(EjbTimerServiceImpl.getDefaultTransactionManager()));
                }
                catch (Exception ignored) {
                    return (TimerStore)TimerStore.class.cast(clazz.newInstance());
                }
            }
            catch (Exception e) {
                logger.error("Can't instantiate " + timerStoreClass + ", using default memory timer store");
            }
        }
        return new MemoryTimerStore(EjbTimerServiceImpl.getDefaultTransactionManager());
    }

    public void startEjbs(boolean start, List<BeanContext> allDeployments) throws OpenEJBException {
        if (start) {
            Container container;
            ArrayList<BeanContext> toStart = new ArrayList<BeanContext>();
            for (BeanContext deployment : allDeployments) {
                try {
                    container = deployment.getContainer();
                    if (container.getBeanContext(deployment.getDeploymentID()) != null) continue;
                    container.deploy(deployment);
                    if (!((String)deployment.getDeploymentID()).endsWith(".Comp") && !deployment.isHidden()) {
                        logger.info("createApplication.createdEjb", deployment.getDeploymentID(), deployment.getEjbName(), container.getContainerID());
                    }
                    if (logger.isDebugEnabled()) {
                        for (Map.Entry<Object, Object> entry : deployment.getProperties().entrySet()) {
                            logger.info("createApplication.createdEjb.property", deployment.getEjbName(), entry.getKey(), entry.getValue());
                        }
                    }
                    toStart.add(deployment);
                }
                catch (Throwable t) {
                    throw new OpenEJBException("Error deploying '" + deployment.getEjbName() + "'.  Exception: " + t.getClass() + ": " + t.getMessage(), t);
                }
            }
            for (BeanContext deployment : toStart) {
                try {
                    container = deployment.getContainer();
                    container.start(deployment);
                    if (((String)deployment.getDeploymentID()).endsWith(".Comp") || deployment.isHidden()) continue;
                    logger.info("createApplication.startedEjb", deployment.getDeploymentID(), deployment.getEjbName(), container.getContainerID());
                }
                catch (Throwable t) {
                    throw new OpenEJBException("Error starting '" + deployment.getEjbName() + "'.  Exception: " + t.getClass() + ": " + t.getMessage(), t);
                }
            }
        }
    }

    private void deployMBean(WebBeansContext wc, ClassLoader cl, String mbeanClass, Properties appMbeans, String id) {
        if (LocalMBeanServer.isJMXActive()) {
            CreationalContext creationalContext;
            Object instance;
            Bean bean;
            BeanManagerImpl bm;
            Class<?> clazz;
            try {
                clazz = cl.loadClass(mbeanClass);
            }
            catch (ClassNotFoundException e) {
                throw new OpenEJBRuntimeException(e);
            }
            if (wc == null) {
                bm = null;
                bean = null;
            } else {
                bm = wc.getBeanManagerImpl();
                Set beans = bm.getBeans(clazz, new Annotation[0]);
                bean = bm.resolve(beans);
            }
            if (bean == null) {
                try {
                    instance = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    logger.error("the mbean " + mbeanClass + " can't be registered because it can't be instantiated", e);
                    return;
                }
                catch (IllegalAccessException e) {
                    logger.error("the mbean " + mbeanClass + " can't be registered because it can't be accessed", e);
                    return;
                }
                creationalContext = null;
            } else {
                creationalContext = bm.createCreationalContext(bean);
                instance = bm.getReference(bean, clazz, creationalContext);
            }
            MBeanServer server = LocalMBeanServer.get();
            try {
                ObjectName leaf = new ObjectNameBuilder("openejb.user.mbeans").set("application", id).set("group", clazz.getPackage().getName()).set("name", clazz.getSimpleName()).build();
                server.registerMBean(new DynamicMBeanWrapper(wc, instance), leaf);
                appMbeans.put(mbeanClass, leaf.getCanonicalName());
                if (creationalContext != null && (bean.getScope() == null || Dependent.class.equals((Object)bean.getScope()))) {
                    this.creationalContextForAppMbeans.put(leaf, creationalContext);
                }
                logger.info("Deployed MBean(" + leaf.getCanonicalName() + ")");
            }
            catch (Exception e) {
                logger.error("the mbean " + mbeanClass + " can't be registered", e);
            }
        }
    }

    private void ensureWebBeansContext(AppContext appContext) {
        WebBeansContext webBeansContext = appContext.get(WebBeansContext.class);
        if (webBeansContext == null) {
            webBeansContext = appContext.getWebBeansContext();
        }
        if (webBeansContext == null) {
            HashMap<Class, Object> services = new HashMap<Class, Object>();
            services.put(JNDIService.class, new OpenEJBJndiService());
            services.put(AppContext.class, appContext);
            services.put(TransactionService.class, new OpenEJBTransactionService());
            services.put(ContextsService.class, (Object)new CdiAppContextsService(webBeansContext, true));
            services.put(ResourceInjectionService.class, new CdiResourceInjectionService(webBeansContext));
            services.put(ScannerService.class, new CdiScanner());
            services.put(ELAdaptor.class, new CustomELAdapter(appContext));
            services.put(LoaderService.class, new OptimizedLoaderService());
            Properties properties = new Properties();
            properties.setProperty(SecurityService.class.getName(), ManagedSecurityService.class.getName());
            webBeansContext = new WebBeansContext(services, properties);
            appContext.setCdiEnabled(false);
            ((OpenEJBTransactionService)OpenEJBTransactionService.class.cast(services.get(TransactionService.class))).setWebBeansContext(webBeansContext);
        }
        appContext.set(WebBeansContext.class, webBeansContext);
        appContext.setWebBeansContext(webBeansContext);
    }

    private TransactionPolicyFactory createTransactionPolicyFactory(EjbJarInfo ejbJar, ClassLoader classLoader) {
        TransactionPolicyFactory factory = null;
        Object value = ejbJar.properties.get(TransactionPolicyFactory.class.getName());
        if (value instanceof TransactionPolicyFactory) {
            factory = (TransactionPolicyFactory)value;
        } else if (value instanceof String) {
            try {
                String[] parts = ((String)value).split(":", 2);
                ResourceFinder finder = new ResourceFinder("META-INF", classLoader);
                Map plugins = finder.mapAvailableImplementations(TransactionPolicyFactory.class);
                Class clazz = (Class)plugins.get(parts[0]);
                if (clazz != null) {
                    factory = parts.length == 1 ? (TransactionPolicyFactory)clazz.getConstructor(String.class).newInstance(parts[1]) : (TransactionPolicyFactory)clazz.newInstance();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (factory == null) {
            factory = new JtaTransactionPolicyFactory(this.transactionManager);
        }
        return factory;
    }

    private static List<BeanContext> sort(List<BeanContext> deployments) {
        Collections.sort(deployments, new Comparator<BeanContext>(){

            @Override
            public int compare(BeanContext a, BeanContext b) {
                int aa = a.getComponentType() == BeanType.SINGLETON ? 1 : 0;
                int bb = b.getComponentType() == BeanType.SINGLETON ? 1 : 0;
                return aa - bb;
            }
        });
        deployments = References.sort(deployments, new References.Visitor<BeanContext>(){

            @Override
            public String getName(BeanContext t) {
                return (String)t.getDeploymentID();
            }

            @Override
            public Set<String> getReferences(BeanContext t) {
                return t.getDependsOn();
            }
        });
        Collections.sort(deployments, new Comparator<BeanContext>(){

            @Override
            public int compare(BeanContext a, BeanContext b) {
                int aa = a.getComponentType() == BeanType.MESSAGE_DRIVEN ? 1 : 0;
                int bb = b.getComponentType() == BeanType.MESSAGE_DRIVEN ? 1 : 0;
                return aa - bb;
            }
        });
        return deployments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ReentrantLock l = lock;
        l.lock();
        try {
            SystemInstance.get().fireEvent((Object)new ContainerSystemPreDestroy());
            try {
                EjbTimerServiceImpl.shutdown();
            }
            catch (Exception e) {
                logger.warning("Unable to shutdown scheduler", e);
            }
            logger.debug("Undeploying Applications");
            Assembler assembler = this;
            ArrayList<AppInfo> deployedApps = new ArrayList<AppInfo>(assembler.getDeployedApplications());
            Collections.reverse(deployedApps);
            for (AppInfo appInfo : deployedApps) {
                try {
                    assembler.destroyApplication(appInfo.path);
                }
                catch (UndeployException e) {
                    logger.error("Undeployment failed: " + appInfo.path, e);
                }
                catch (NoSuchApplicationException e) {}
            }
            Iterator<ObjectName> it = this.containerObjectNames.iterator();
            MBeanServer server = LocalMBeanServer.get();
            while (it.hasNext()) {
                try {
                    server.unregisterMBean(it.next());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                it.remove();
            }
            try {
                this.remoteResourceMonitor.unregister();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            NamingEnumeration<Binding> namingEnumeration = null;
            try {
                namingEnumeration = this.containerSystem.getJNDIContext().listBindings("openejb/Resource");
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            this.destroyResourceTree(namingEnumeration);
            try {
                this.containerSystem.getJNDIContext().unbind("java:global");
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            SystemInstance.get().removeComponent(OpenEjbConfiguration.class);
            SystemInstance.get().removeComponent(JtaEntityManagerRegistry.class);
            SystemInstance.get().removeComponent(TransactionSynchronizationRegistry.class);
            SystemInstance.get().removeComponent(EjbResolver.class);
            SystemInstance.get().fireEvent((Object)new AssemblerDestroyed());
            SystemInstance.reset();
        }
        finally {
            l.unlock();
        }
    }

    private void destroyResourceTree(NamingEnumeration<Binding> namingEnumeration) {
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.nextElement();
            Object object = binding.getObject();
            if (Context.class.isInstance(object)) {
                try {
                    this.destroyResourceTree(((Context)Context.class.cast(object)).listBindings(""));
                }
                catch (Exception ignored) {}
                continue;
            }
            Assembler.destroyResource(binding.getName(), binding.getClassName(), object);
        }
    }

    private static void destroyResource(String name, String className, Object object) {
        if (object instanceof ResourceAdapter) {
            ResourceAdapter resourceAdapter = (ResourceAdapter)object;
            try {
                logger.info("Stopping ResourceAdapter: " + name);
                if (logger.isDebugEnabled()) {
                    logger.debug("Stopping ResourceAdapter: " + className);
                }
                resourceAdapter.stop();
            }
            catch (Throwable t) {
                logger.fatal("ResourceAdapter Shutdown Failed: " + name, t);
            }
        } else if (DataSourceFactory.knows(object)) {
            logger.info("Closing DataSource: " + name);
            try {
                DataSourceFactory.destroy(object);
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (object instanceof ManagedDataSource) {
                ((ManagedDataSource)object).clean();
            }
        } else if (object instanceof ConnectorReference) {
            ConnectorReference cr = (ConnectorReference)((Object)object);
            try {
                ConnectionManager cm = cr.getConnectionManager();
                if (cm != null && cm instanceof AbstractConnectionManager) {
                    ((AbstractConnectionManager)cm).doStop();
                }
            }
            catch (Exception e) {
                logger.debug("Not processing resource on destroy: " + className, e);
            }
        } else if (ExecutorService.class.isInstance(object)) {
            ((ExecutorService)ExecutorService.class.cast(object)).shutdown();
        } else if (!DataSource.class.isInstance(object) && logger.isDebugEnabled()) {
            logger.debug("Not processing resource on destroy: " + className);
        }
        try {
            OpenEjbConfiguration configuration = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
            Iterator<ResourceInfo> iterator = configuration.facilities.resources.iterator();
            while (iterator.hasNext()) {
                ResourceInfo info = iterator.next();
                if (!name.equals(info.id)) continue;
                iterator.remove();
                break;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to purge resource on destroy: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApplication(String filePath) throws UndeployException, NoSuchApplicationException {
        ReentrantLock l = lock;
        l.lock();
        try {
            AppInfo appInfo = this.deployedApplications.remove(filePath);
            if (appInfo == null) {
                throw new NoSuchApplicationException(filePath);
            }
            this.destroyApplication(appInfo);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApplication(AppContext appContext) throws UndeployException {
        ReentrantLock l = lock;
        l.lock();
        try {
            AppInfo appInfo = this.deployedApplications.remove(appContext.getId());
            if (appInfo == null) {
                throw new IllegalStateException(String.format("Cannot find AppInfo for app: %s", appContext.getId()));
            }
            this.destroyApplication(appInfo);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApplication(AppInfo appInfo) throws UndeployException {
        ReentrantLock l = lock;
        l.lock();
        try {
            String name;
            Container container;
            String deploymentID;
            this.deployedApplications.remove(appInfo.path);
            logger.info("destroyApplication.start", appInfo.path);
            SystemInstance.get().fireEvent((Object)new AssemblerBeforeApplicationDestroyed(appInfo));
            Context globalContext = this.containerSystem.getJNDIContext();
            AppContext appContext = this.containerSystem.getAppContext(appInfo.appId);
            if (null == appContext) {
                logger.warning("Application id '" + appInfo.appId + "' not found in: " + Arrays.toString(this.containerSystem.getAppContextKeys()));
                return;
            }
            WebBeansContext webBeansContext = appContext.getWebBeansContext();
            if (webBeansContext != null) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(appContext.getClassLoader());
                try {
                    ((ContainerLifecycle)webBeansContext.getService(ContainerLifecycle.class)).stopApplication(null);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            Map<String, Object> cb = appContext.getBindings();
            for (Map.Entry<String, Object> value : cb.entrySet()) {
                String path = value.getKey();
                if (path.startsWith(GLOBAL_UNIQUE_ID)) {
                    path = "java:" + path;
                }
                if (!path.startsWith("java:global")) continue;
                this.unbind(globalContext, path);
                this.unbind(globalContext, "openejb/global/" + path.substring("java:".length()));
                this.unbind(globalContext, path.substring("java:global".length()));
            }
            if (appInfo.appId != null && !appInfo.appId.isEmpty() && !"openejb".equals(appInfo.appId)) {
                this.unbind(globalContext, "global/" + appInfo.appId);
                this.unbind(globalContext, appInfo.appId);
            }
            EjbResolver globalResolver = new EjbResolver(null, EjbResolver.Scope.GLOBAL, new EjbJarInfo[0]);
            for (AppInfo info : this.deployedApplications.values()) {
                globalResolver.addAll(info.ejbJars);
            }
            SystemInstance.get().setComponent(EjbResolver.class, (Object)globalResolver);
            UndeployException undeployException = new UndeployException(this.messages.format("destroyApplication.failed", appInfo.path));
            WebAppBuilder webAppBuilder = (WebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
            if (webAppBuilder != null && !appInfo.webAppAlone) {
                try {
                    webAppBuilder.undeployWebApps(appInfo);
                }
                catch (Exception e) {
                    undeployException.getCauses().add(new Exception("App: " + appInfo.path + ": " + e.getMessage(), e));
                }
            }
            List<BeanContext> deployments = new ArrayList<BeanContext>();
            for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
                for (EnterpriseBeanInfo beanInfo : ejbJarInfo.enterpriseBeans) {
                    String deploymentId = beanInfo.ejbDeploymentId;
                    BeanContext beanContext = this.containerSystem.getBeanContext(deploymentId);
                    if (beanContext == null) {
                        undeployException.getCauses().add(new Exception("deployment not found: " + deploymentId));
                        continue;
                    }
                    deployments.add(beanContext);
                }
            }
            deployments = Assembler.sort(deployments);
            Collections.reverse(deployments);
            for (BeanContext deployment : deployments) {
                deploymentID = deployment.getDeploymentID() + "";
                try {
                    container = deployment.getContainer();
                    container.stop(deployment);
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception("bean: " + deploymentID + ": " + t.getMessage(), t));
                }
            }
            for (BeanContext bean : deployments) {
                deploymentID = bean.getDeploymentID() + "";
                try {
                    container = bean.getContainer();
                    container.undeploy(bean);
                    bean.setContainer(null);
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception("bean: " + deploymentID + ": " + t.getMessage(), t));
                }
                finally {
                    bean.setDestroyed(true);
                }
            }
            if (webAppBuilder != null && appInfo.webAppAlone) {
                try {
                    webAppBuilder.undeployWebApps(appInfo);
                }
                catch (Exception e) {
                    undeployException.getCauses().add(new Exception("App: " + appInfo.path + ": " + e.getMessage(), e));
                }
            }
            ArrayList<String> clientIds = new ArrayList<String>();
            for (ClientInfo clientInfo : appInfo.clients) {
                clientIds.add(clientInfo.moduleId);
                for (String className : clientInfo.localClients) {
                    clientIds.add(className);
                }
                for (String className : clientInfo.remoteClients) {
                    clientIds.add(className);
                }
            }
            if (appContext != null) {
                for (WebContext webContext : appContext.getWebContexts()) {
                    this.containerSystem.removeWebContext(webContext);
                }
                TldScanner.forceCompleteClean(appContext.getClassLoader());
            }
            for (BeanContext deployment : deployments) {
                JndiBuilder.Bindings bindings;
                String deploymentID2 = deployment.getDeploymentID() + "";
                try {
                    this.containerSystem.removeBeanContext(deployment);
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception(deploymentID2, t));
                }
                if ((bindings = deployment.get(JndiBuilder.Bindings.class)) == null) continue;
                for (String name2 : bindings.getBindings()) {
                    try {
                        globalContext.unbind(name2);
                    }
                    catch (Throwable t) {
                        undeployException.getCauses().add(new Exception("bean: " + deploymentID2 + ": " + t.getMessage(), t));
                    }
                }
            }
            AsynchronousPool pool = appContext.get(AsynchronousPool.class);
            if (pool != null) {
                pool.stop();
            }
            for (String sId : this.moduleIds) {
                try {
                    globalContext.unbind("openejb/ValidatorFactory/" + sId);
                    globalContext.unbind("openejb/Validator/" + sId);
                }
                catch (NamingException e) {
                    undeployException.getCauses().add(new Exception("validator: " + sId + ": " + e.getMessage(), e));
                }
            }
            this.moduleIds.clear();
            try {
                if (globalContext instanceof IvmContext) {
                    IvmContext ivmContext = (IvmContext)globalContext;
                    ivmContext.prune("openejb/Deployment");
                    ivmContext.prune("openejb/local");
                    ivmContext.prune("openejb/remote");
                    ivmContext.prune("openejb/global");
                }
            }
            catch (NamingException e) {
                undeployException.getCauses().add(new Exception("Unable to prune openejb/Deployments and openejb/local namespaces, this could cause future deployments to fail.", e));
            }
            deployments.clear();
            for (String clientId : clientIds) {
                try {
                    globalContext.unbind("/openejb/client/" + clientId);
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception("client: " + clientId + ": " + t.getMessage(), t));
                }
            }
            MBeanServer server = LocalMBeanServer.get();
            for (Object objectName : appInfo.jmx.values()) {
                try {
                    CreationalContext cc;
                    ObjectName on = new ObjectName((String)objectName);
                    if (server.isRegistered(on)) {
                        server.unregisterMBean(on);
                    }
                    if ((cc = this.creationalContextForAppMbeans.remove(on)) == null) continue;
                    cc.release();
                }
                catch (InstanceNotFoundException e) {
                    logger.warning("can't unregister " + objectName + " because the mbean was not found", e);
                }
                catch (MBeanRegistrationException e) {
                    logger.warning("can't unregister " + objectName, e);
                }
                catch (MalformedObjectNameException mone) {
                    logger.warning("can't unregister because the ObjectName is malformed: " + objectName, mone);
                }
            }
            for (PersistenceUnitInfo unitInfo : appInfo.persistenceUnits) {
                try {
                    Object object = globalContext.lookup("openejb/PersistenceUnit/" + unitInfo.id);
                    globalContext.unbind("openejb/PersistenceUnit/" + unitInfo.id);
                    ReloadableEntityManagerFactory remf = (ReloadableEntityManagerFactory)object;
                    remf.close();
                    this.persistenceClassLoaderHandler.destroy(unitInfo.id);
                    remf.unregister();
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception("persistence-unit: " + unitInfo.id + ": " + t.getMessage(), t));
                }
            }
            for (String id : appInfo.resourceAliases) {
                name = "openejb/Resource/" + id;
                ContextualJndiReference.followReference.set(false);
                try {
                    Object object;
                    try {
                        object = globalContext.lookup(name);
                    }
                    finally {
                        ContextualJndiReference.followReference.remove();
                    }
                    if (object instanceof ContextualJndiReference) {
                        ContextualJndiReference contextualJndiReference = (ContextualJndiReference)((Object)ContextualJndiReference.class.cast(object));
                        contextualJndiReference.removePrefix(appContext.getId());
                        if (!contextualJndiReference.hasNoMorePrefix()) continue;
                        globalContext.unbind(name);
                        continue;
                    }
                    globalContext.unbind(name);
                }
                catch (NamingException e) {
                    logger.warning("can't unbind resource '{0}'", id);
                }
            }
            for (String id : appInfo.resourceIds) {
                name = "openejb/Resource/" + id;
                try {
                    this.destroyLookedUpResource(globalContext, id, name);
                }
                catch (NamingException e) {
                    logger.warning("can't unbind resource '{0}'", id);
                }
            }
            for (ConnectorInfo connector : appInfo.connectors) {
                if (connector.resourceAdapter == null || connector.resourceAdapter.id == null) continue;
                name = "openejb/Resource/" + connector.resourceAdapter.id;
                try {
                    this.destroyLookedUpResource(globalContext, connector.resourceAdapter.id, name);
                }
                catch (NamingException e) {
                    logger.warning("can't unbind resource '{0}'", connector);
                }
            }
            this.containerSystem.removeAppContext(appInfo.appId);
            ClassLoaderUtil.destroyClassLoader(appInfo.appId, appInfo.path);
            if (undeployException.getCauses().size() > 0) {
                throw undeployException;
            }
            logger.debug("destroyApplication.success", appInfo.path);
        }
        finally {
            l.unlock();
        }
    }

    private void destroyLookedUpResource(Context globalContext, String id, String name) throws NamingException {
        Object object = globalContext.lookup(name);
        String clazz = object == null ? "?" : object.getClass().getName();
        Assembler.destroyResource(id, clazz, object);
        globalContext.unbind(name);
    }

    private void unbind(Context context, String name) {
        try {
            context.unbind(name);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private void dumpJndiTree(Context containerSystemContext, String message) {
        System.out.println(message);
        try {
            JndiTreeBrowser.log(containerSystemContext);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoader createAppClassLoader(AppInfo appInfo) throws OpenEJBException, IOException {
        void var4_16;
        HashSet<URL> jars = new HashSet<URL>();
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            if (ejbJarInfo.path == null) continue;
            jars.add(this.toUrl(ejbJarInfo.path));
        }
        for (ClientInfo clientInfo : appInfo.clients) {
            if (clientInfo.path == null) continue;
            jars.add(this.toUrl(clientInfo.path));
        }
        for (ConnectorInfo connectorInfo : appInfo.connectors) {
            for (String jarPath : connectorInfo.libs) {
                jars.add(this.toUrl(jarPath));
            }
        }
        for (String string : appInfo.libs) {
            jars.add(this.toUrl(string));
        }
        if (appInfo.libs.size() > 0) {
            try {
                File jpaIntegrationFile = JarLocation.jarLocation(MakeTxLookup.class);
                URL uRL = jpaIntegrationFile.toURI().toURL();
                if (!jars.contains(uRL)) {
                    jars.add(uRL);
                }
            }
            catch (RuntimeException re) {
                logger.warning("can't find open-jpa-integration jar");
            }
        }
        jars.addAll(Arrays.asList(((ClassLoaderEnricher)SystemInstance.get().getComponent(ClassLoaderEnricher.class)).applicationEnrichment()));
        ParentClassLoaderFinder parentFinder = (ParentClassLoaderFinder)SystemInstance.get().getComponent(ParentClassLoaderFinder.class);
        ClassLoader classLoader = OpenEJB.class.getClassLoader();
        if (parentFinder != null) {
            ClassLoader classLoader2 = parentFinder.getParentClassLoader(classLoader);
        }
        String prefix = appInfo.webAppAlone ? "WEB-INF/" : "META-INF/";
        ClassLoaderConfigurer configurer1 = QuickJarsTxtParser.parse(new File(appInfo.path, prefix + "jars.txt"));
        ClassLoaderConfigurer configurer2 = ClassLoaderUtil.configurer(appInfo.appId);
        if (configurer1 != null || configurer2 != null) {
            CompositeClassLoaderConfigurer configurer = new CompositeClassLoaderConfigurer(configurer1, configurer2);
            ClassLoaderConfigurer.Helper.configure(jars, configurer);
        }
        URL[] filtered = jars.toArray(new URL[jars.size()]);
        if (this.skipLoaderIfPossible) {
            ArrayList<File> urls = new ArrayList<File>();
            for (URL url : ClassLoaders.findUrls((ClassLoader)var4_16)) {
                try {
                    urls.add(URLs.toFile(url));
                }
                catch (Exception ignored) {}
            }
            boolean allIsIntheClasspath = true;
            for (URL url : filtered) {
                try {
                    if (urls.contains(URLs.toFile(url))) continue;
                    allIsIntheClasspath = false;
                }
                catch (Exception ignored) {
                    allIsIntheClasspath = false;
                }
                break;
            }
            if (allIsIntheClasspath) {
                return var4_16;
            }
        }
        if (!appInfo.delegateFirst) {
            return ClassLoaderUtil.createClassLoader(appInfo.path, filtered, (ClassLoader)var4_16);
        }
        return ClassLoaderUtil.createClassLoaderFirst(appInfo.path, filtered, (ClassLoader)var4_16);
    }

    public void createExternalContext(JndiContextInfo contextInfo) throws OpenEJBException {
        InitialContext initialContext;
        logger.getChildLogger("service").info("createService", contextInfo.service, contextInfo.id, contextInfo.className);
        try {
            initialContext = new InitialContext(contextInfo.properties);
        }
        catch (NamingException ne) {
            throw new OpenEJBException(String.format("JndiProvider(id=\"%s\") could not be created.  Failed to create the InitialContext using the supplied properties", contextInfo.id), ne);
        }
        try {
            this.containerSystem.getJNDIContext().bind("openejb/remote_jndi_contexts/" + contextInfo.id, (Object)initialContext);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + contextInfo.service + " with id " + contextInfo.id, e);
        }
        this.config.facilities.remoteJndiContexts.add(contextInfo);
        logger.getChildLogger("service").debug("createService.success", contextInfo.service, contextInfo.id, contextInfo.className);
    }

    public void createContainer(ContainerInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        serviceRecipe.setProperty("id", (Object)serviceInfo.id);
        serviceRecipe.setProperty("transactionManager", this.props.get(TransactionManager.class.getName()));
        serviceRecipe.setProperty("securityService", this.props.get(org.apache.openejb.spi.SecurityService.class.getName()));
        serviceRecipe.setProperty("properties", (Object)new UnsetPropertiesRecipe());
        this.replaceResourceAdapterProperty(serviceRecipe);
        Object service = serviceRecipe.create();
        Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.containerSystem.addContainer(serviceInfo.id, (Container)service);
        this.config.containerSystem.containers.add(serviceInfo);
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
        if (Container.class.isInstance(service) && LocalMBeanServer.isJMXActive()) {
            ObjectName objectName = ObjectNameBuilder.uniqueName("containers", serviceInfo.id, service);
            try {
                LocalMBeanServer.get().registerMBean(new DynamicMBeanWrapper(new JMXContainer(serviceInfo, (Container)service)), objectName);
                this.containerObjectNames.add(objectName);
            }
            catch (Exception e) {
            }
            catch (NoClassDefFoundError ncdfe) {
                // empty catch block
            }
        }
    }

    private void bindService(ServiceInfo serviceInfo, Object service) throws OpenEJBException {
        try {
            this.containerSystem.getJNDIContext().bind("openejb/" + serviceInfo.service + "/" + serviceInfo.id, service);
        }
        catch (NamingException e) {
            throw new OpenEJBException(this.messages.format("assembler.cannotBindServiceWithId", serviceInfo.service, serviceInfo.id), e);
        }
    }

    public void removeContainer(String containerId) {
        this.containerSystem.removeContainer(containerId);
        Iterator<ContainerInfo> iterator = this.config.containerSystem.containers.iterator();
        while (iterator.hasNext()) {
            ContainerInfo containerInfo = iterator.next();
            if (!containerInfo.id.equals(containerId)) continue;
            iterator.remove();
            try {
                this.containerSystem.getJNDIContext().unbind("openejb/" + containerInfo.service + "/" + containerInfo.id);
            }
            catch (Exception e) {
                logger.error("removeContainer.unbindFailed", containerId);
            }
        }
    }

    public void createService(ServiceInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        Object service = serviceRecipe.create();
        SystemInstance.get().addObserver(service);
        Assembler.logUnusedProperties(serviceRecipe, serviceInfo);
        Class<?> serviceClass = service.getClass();
        Assembler.getContext().put(serviceClass.getName(), service);
        this.props.put(serviceClass.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.services.add(serviceInfo);
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createProxyFactory(ProxyFactoryInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        Object service = serviceRecipe.create();
        Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        ProxyManager.registerFactory(serviceInfo.id, (ProxyFactory)service);
        ProxyManager.setDefaultFactory(serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.intraVmServer = serviceInfo;
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    private void replaceResourceAdapterProperty(ObjectRecipe serviceRecipe) throws OpenEJBException {
        Object resourceAdapterId = serviceRecipe.getProperty("ResourceAdapter");
        if (resourceAdapterId instanceof String) {
            String id = (String)resourceAdapterId;
            id = id.trim();
            Object resourceAdapter = null;
            try {
                resourceAdapter = this.containerSystem.getJNDIContext().lookup("openejb/Resource/" + id);
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (resourceAdapter == null) {
                throw new OpenEJBException("No existing resource adapter defined with id '" + id + "'.");
            }
            if (!(resourceAdapter instanceof ResourceAdapter)) {
                throw new OpenEJBException(this.messages.format("assembler.resourceAdapterNotResourceAdapter", id, resourceAdapter.getClass()));
            }
            serviceRecipe.setProperty("ResourceAdapter", resourceAdapter);
        }
    }

    public void createResource(ResourceInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        if ("false".equalsIgnoreCase(serviceInfo.properties.getProperty("SkipImplicitAttributes", "false"))) {
            serviceRecipe.setProperty("transactionManager", (Object)this.transactionManager);
            serviceRecipe.setProperty("ServiceId", (Object)serviceInfo.id);
        }
        serviceInfo.properties.remove("SkipImplicitAttributes");
        serviceRecipe.setProperty("properties", (Object)new UnsetPropertiesRecipe());
        Properties props = PropertyPlaceHolderHelper.holds(serviceInfo.properties);
        if (serviceInfo.properties.containsKey("Definition")) {
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(serviceInfo.properties.getProperty("Definition").getBytes());
                SuperProperties p = new SuperProperties();
                IO.readProperties((InputStream)is, (Properties)p);
                for (Map.Entry<Object, Object> entry : ((Properties)p).entrySet()) {
                    String key = entry.getKey().toString();
                    if (props.containsKey(key) || key.equalsIgnoreCase("url") && props.containsKey("JdbcUrl")) continue;
                    props.put(key, entry.getValue());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        serviceRecipe.setProperty("Definition", (Object)PropertiesHelper.propertiesToString(props));
        this.replaceResourceAdapterProperty(serviceRecipe);
        Object service = serviceRecipe.create();
        if (service instanceof ResourceAdapter) {
            SimpleWorkManager workManager;
            ResourceAdapter resourceAdapter = (ResourceAdapter)service;
            int threadPoolSize = this.getIntProperty(serviceInfo.properties, "threadPoolSize", 30);
            ExecutorService threadPool = threadPoolSize <= 0 ? Executors.newCachedThreadPool(new DaemonThreadFactory(serviceInfo.id + "-worker-")) : Executors.newFixedThreadPool(threadPoolSize, new DaemonThreadFactory(serviceInfo.id + "-worker-"));
            if (GeronimoTransactionManager.class.isInstance(this.transactionManager)) {
                GeronimoTransactionManager geronimoTransactionManager = (GeronimoTransactionManager)this.transactionManager;
                TransactionContextHandler txWorkContextHandler = new TransactionContextHandler((XAWork)geronimoTransactionManager);
                String securityRealmName = this.getStringProperty(serviceInfo.properties, "realm", serviceInfo.id);
                SecurityContextHandler securityContextHandler = new SecurityContextHandler(securityRealmName);
                HintsContextHandler hintsContextHandler = new HintsContextHandler();
                ArrayList<Object> workContextHandlers = new ArrayList<Object>();
                workContextHandlers.add(txWorkContextHandler);
                workContextHandlers.add(securityContextHandler);
                workContextHandlers.add(hintsContextHandler);
                workManager = new GeronimoWorkManager((Executor)threadPool, (Executor)threadPool, (Executor)threadPool, workContextHandlers);
            } else {
                workManager = new SimpleWorkManager(threadPool);
            }
            SimpleBootstrapContext bootstrapContext = this.transactionManager instanceof GeronimoTransactionManager ? new GeronimoBootstrapContext((GeronimoWorkManager)workManager, (XATerminator)((GeronimoTransactionManager)this.transactionManager), (TransactionSynchronizationRegistry)((GeronimoTransactionManager)this.transactionManager)) : (this.transactionManager instanceof XATerminator ? new SimpleBootstrapContext(workManager, (XATerminator)this.transactionManager) : new SimpleBootstrapContext(workManager));
            try {
                logger.debug("createResource.startingResourceAdapter", serviceInfo.id, service.getClass().getName());
                resourceAdapter.start((BootstrapContext)bootstrapContext);
            }
            catch (ResourceAdapterInternalException e) {
                throw new OpenEJBException(e);
            }
            Map unset = serviceRecipe.getUnsetProperties();
            unset.remove("threadPoolSize");
            Assembler.logUnusedProperties(unset, (ServiceInfo)serviceInfo);
        } else if (service instanceof ManagedConnectionFactory) {
            ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)service;
            ObjectRecipe connectionManagerRecipe = new ObjectRecipe(GeronimoConnectionManagerFactory.class, "create");
            connectionManagerRecipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
            connectionManagerRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            connectionManagerRecipe.setAllProperties((Map)serviceInfo.properties);
            connectionManagerRecipe.setProperty("name", (Object)serviceInfo.id);
            connectionManagerRecipe.setProperty("mcf", (Object)managedConnectionFactory);
            connectionManagerRecipe.setProperty("transactionManager", (Object)this.transactionManager);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            connectionManagerRecipe.setProperty("classLoader", (Object)classLoader);
            logger.getChildLogger("service").info("createResource.createConnectionManager", serviceInfo.id, service.getClass().getName());
            ConnectionManager connectionManager = (ConnectionManager)connectionManagerRecipe.create();
            if (connectionManager == null) {
                throw new OpenEJBRuntimeException(this.messages.format("assembler.invalidConnectionManager", serviceInfo.id));
            }
            Map unsetA = serviceRecipe.getUnsetProperties();
            Map unsetB = connectionManagerRecipe.getUnsetProperties();
            HashMap<String, Object> unset = new HashMap<String, Object>();
            for (Map.Entry entry : unsetA.entrySet()) {
                if (!unsetB.containsKey(entry.getKey())) continue;
                unset.put((String)entry.getKey(), entry.getValue());
            }
            service = new ConnectorReference(connectionManager, managedConnectionFactory);
            Object eagerInit = unset.remove("eagerInit");
            if (eagerInit != null && eagerInit instanceof String && "true".equalsIgnoreCase((String)eagerInit) && connectionManager instanceof AbstractConnectionManager) {
                try {
                    ((AbstractConnectionManager)connectionManager).doStart();
                    try {
                        Object cf = managedConnectionFactory.createConnectionFactory(connectionManager);
                        if (cf instanceof ConnectionFactory) {
                            Connection connection = ((ConnectionFactory)cf).getConnection();
                            connection.getMetaData();
                            connection.close();
                        }
                    }
                    catch (Exception e) {}
                }
                catch (Exception e) {
                    logger.warning("Can't start connection manager", e);
                }
            }
            Assembler.logUnusedProperties(unset, (ServiceInfo)serviceInfo);
        } else if (service instanceof DataSource) {
            ImportSql importer;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if ((importer = new ImportSql(classLoader, serviceInfo.id, (DataSource)service)).hasSomethingToImport()) {
                importer.doImport();
            }
            Assembler.logUnusedProperties(DataSourceFactory.forgetRecipe(service, serviceRecipe), (ServiceInfo)serviceInfo);
            Properties prop = serviceInfo.properties;
            String url = prop.getProperty("JdbcUrl", prop.getProperty("url"));
            if (url == null) {
                url = prop.getProperty("jdbcUrl");
            }
            if (url == null) {
                logger.info("can't find url for " + serviceInfo.id + " will not monitor it");
            } else {
                String host = Assembler.extractHost(url);
                if (host != null) {
                    this.remoteResourceMonitor.addHost(host);
                    this.remoteResourceMonitor.registerIfNot();
                }
            }
        } else {
            Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        }
        this.bindResource(serviceInfo.id, service);
        for (String alias : serviceInfo.aliases) {
            this.bindResource(alias, service);
        }
        if (!(serviceInfo.originAppName == null || serviceInfo.originAppName.isEmpty() || "/".equals(serviceInfo.originAppName) || serviceInfo.id.startsWith(GLOBAL_UNIQUE_ID))) {
            String baseJndiName = serviceInfo.id.substring(serviceInfo.originAppName.length() + 1);
            serviceInfo.aliases.add(baseJndiName);
            ContextualJndiReference ref = new ContextualJndiReference(baseJndiName);
            ref.addPrefix(serviceInfo.originAppName);
            this.bindResource(baseJndiName, (Object)ref);
        }
        this.config.facilities.resources.add(serviceInfo);
        if (logger.isDebugEnabled()) {
            logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindResource(String id, Object service) throws OpenEJBException {
        String name = "openejb/Resource/" + id;
        Context jndiContext = this.containerSystem.getJNDIContext();
        Object existing = null;
        try {
            ContextualJndiReference.followReference.set(false);
            existing = jndiContext.lookup(name);
        }
        catch (Exception ignored) {
        }
        finally {
            ContextualJndiReference.followReference.remove();
        }
        boolean rebind = false;
        if (existing != null) {
            boolean existingIsContextual = ContextualJndiReference.class.isInstance(existing);
            boolean serviceIsExisting = ContextualJndiReference.class.isInstance(service);
            if (!existingIsContextual && serviceIsExisting) {
                ((ContextualJndiReference)((Object)ContextualJndiReference.class.cast(service))).setDefaultValue(existing);
                rebind = true;
            } else if (existingIsContextual && !serviceIsExisting) {
                ((ContextualJndiReference)((Object)ContextualJndiReference.class.cast(existing))).setDefaultValue(service);
            } else if (existingIsContextual) {
                ((ContextualJndiReference)((Object)ContextualJndiReference.class.cast(existing))).addPrefix(((ContextualJndiReference)((Object)ContextualJndiReference.class.cast(service))).lastPrefix());
                return;
            }
        }
        try {
            if (rebind) {
                jndiContext.rebind(name, service);
            } else {
                jndiContext.bind(name, service);
            }
        }
        catch (NameAlreadyBoundException nabe) {
            logger.warning("unbounding resource " + name + " can happen because of a redeployment or because of a duplicated id");
            try {
                jndiContext.unbind(name);
                jndiContext.bind(name, service);
            }
            catch (NamingException e) {
                throw new OpenEJBException("Cannot bind resource adapter with id " + id, e);
            }
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind resource adapter with id " + id, e);
        }
    }

    private static String extractHost(String url) {
        if (url == null || !url.contains("://")) {
            return null;
        }
        int idx = url.indexOf("://");
        String subUrl = url.substring(idx + 3);
        int port = subUrl.indexOf(58);
        int slash = subUrl.indexOf(47);
        int end = port;
        if (end < 0 || slash > 0 && slash < end) {
            end = slash;
        }
        if (end > 0) {
            return subUrl.substring(0, end);
        }
        return subUrl;
    }

    private int getIntProperty(Properties properties, String propertyName, int defaultValue) {
        String propertyValue = this.getStringProperty(properties, propertyName, Integer.toString(defaultValue));
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(propertyName + " is not an integer " + propertyValue, e);
        }
    }

    private String getStringProperty(Properties properties, String propertyName, String defaultValue) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    public void createConnectionManager(ConnectionManagerInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        Object object = this.props.get("TransactionManager");
        serviceRecipe.setProperty("transactionManager", object);
        Object service = serviceRecipe.create();
        Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.connectionManagers.add(serviceInfo);
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createSecurityService(SecurityServiceInfo serviceInfo) throws OpenEJBException {
        Object service = SystemInstance.get().getComponent(org.apache.openejb.spi.SecurityService.class);
        if (service == null) {
            ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
            service = serviceRecipe.create();
            Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        }
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        try {
            this.containerSystem.getJNDIContext().bind("openejb/" + serviceInfo.service, service);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + serviceInfo.service + " with id " + serviceInfo.id, e);
        }
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.securityService = (org.apache.openejb.spi.SecurityService)service;
        this.config.facilities.securityService = serviceInfo;
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createTransactionManager(TransactionServiceInfo serviceInfo) throws OpenEJBException {
        Object service = SystemInstance.get().getComponent(TransactionManager.class);
        if (service == null) {
            ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
            service = serviceRecipe.create();
            Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        } else {
            logger.info("Reusing provided TransactionManager " + service);
        }
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        try {
            this.containerSystem.getJNDIContext().bind("openejb/" + serviceInfo.service, service);
            this.containerSystem.getJNDIContext().bind("comp/UserTransaction", (Object)new CoreUserTransaction((TransactionManager)service));
            this.containerSystem.getJNDIContext().bind("comp/TransactionManager", service);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + serviceInfo.service + " with id " + serviceInfo.id, e);
        }
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.transactionManager = (TransactionManager)service;
        this.config.facilities.transactionService = serviceInfo;
        Object synchronizationRegistry = this.transactionManager instanceof TransactionSynchronizationRegistry ? (TransactionSynchronizationRegistry)this.transactionManager : new SimpleTransactionSynchronizationRegistry(this.transactionManager);
        Assembler.getContext().put(TransactionSynchronizationRegistry.class.getName(), synchronizationRegistry);
        SystemInstance.get().setComponent(TransactionSynchronizationRegistry.class, synchronizationRegistry);
        try {
            this.containerSystem.getJNDIContext().bind("comp/TransactionSynchronizationRegistry", (Object)new TransactionSynchronizationRegistryWrapper());
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind java:comp/TransactionSynchronizationRegistry", e);
        }
        JtaEntityManagerRegistry jtaEntityManagerRegistry = new JtaEntityManagerRegistry((TransactionSynchronizationRegistry)synchronizationRegistry);
        Assembler.getContext().put(JtaEntityManagerRegistry.class.getName(), jtaEntityManagerRegistry);
        SystemInstance.get().setComponent(JtaEntityManagerRegistry.class, (Object)jtaEntityManagerRegistry);
        logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public static void logUnusedProperties(ObjectRecipe serviceRecipe, ServiceInfo info) {
        Map unsetProperties = serviceRecipe.getUnsetProperties();
        Assembler.logUnusedProperties(unsetProperties, info);
    }

    private static void logUnusedProperties(Map<String, Object> unsetProperties, ServiceInfo info) {
        for (String property : unsetProperties.keySet()) {
            if (property.equalsIgnoreCase("Definition")) {
                return;
            }
            if (property.equalsIgnoreCase("SkipImplicitAttributes")) {
                return;
            }
            if (property.equalsIgnoreCase("JndiName")) {
                return;
            }
            if (property.equalsIgnoreCase("Origin")) {
                return;
            }
            if (property.equalsIgnoreCase("DatabaseName")) {
                return;
            }
            if (property.equalsIgnoreCase("connectionAttributes")) {
                return;
            }
            if (property.equalsIgnoreCase("properties")) {
                return;
            }
            if (property.equalsIgnoreCase("ApplicationWide")) {
                return;
            }
            if (property.equalsIgnoreCase("transactionManager")) {
                return;
            }
            if (info.types.contains("javax.mail.Session")) {
                return;
            }
            if (info.types.isEmpty() && "class".equalsIgnoreCase(property)) continue;
            logger.getChildLogger("service").warning("unusedProperty", property, info.id);
        }
    }

    public static ObjectRecipe prepareRecipe(ServiceInfo info) {
        String[] constructorArgs = info.constructorArgs.toArray(new String[info.constructorArgs.size()]);
        ObjectRecipe serviceRecipe = new ObjectRecipe(info.className, info.factoryMethod, constructorArgs, null);
        serviceRecipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
        serviceRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        return serviceRecipe;
    }

    private ObjectRecipe createRecipe(ServiceInfo info) {
        Logger serviceLogger = logger.getChildLogger("service");
        if (info instanceof ResourceInfo) {
            List<String> aliasesList = ((ResourceInfo)info).aliases;
            if (!aliasesList.isEmpty()) {
                String aliases = Join.join(", ", aliasesList);
                serviceLogger.info("createServiceWithAliases", info.service, info.id, aliases);
            } else {
                serviceLogger.info("createService", info.service, info.id);
            }
        } else {
            serviceLogger.info("createService", info.service, info.id);
        }
        ObjectRecipe serviceRecipe = Assembler.prepareRecipe(info);
        serviceRecipe.setAllProperties((Map)info.properties);
        if (serviceLogger.isDebugEnabled()) {
            for (Map.Entry entry : serviceRecipe.getProperties().entrySet()) {
                serviceLogger.debug("createService.props", entry.getKey(), entry.getValue());
            }
        }
        return serviceRecipe;
    }

    private void setSystemInstanceComponent(Class interfce, Object service) {
        SystemInstance.get().setComponent(interfce, service);
    }

    private URL toUrl(String jarPath) throws OpenEJBException {
        try {
            return new File(jarPath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OpenEJBException(this.messages.format("cl0001", jarPath, e.getMessage()), e);
        }
    }

    static {
        JULLoggerFactory.class.getName();
        OPENEJB_URL_PKG_PREFIX = IvmContext.class.getPackage().getName();
        logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, Assembler.class);
        lock = new ReentrantLock(true);
        context = new ThreadLocal();
    }

    public static class DeploymentListenerObserver {
        private final DeploymentListener delegate;

        public DeploymentListenerObserver(DeploymentListener deploymentListener) {
            this.delegate = deploymentListener;
        }

        public void afterApplicationCreated(@Observes AssemblerAfterApplicationCreated event) {
            this.delegate.afterApplicationCreated(event.getApp());
        }

        public void beforeApplicationDestroyed(@Observes AssemblerBeforeApplicationDestroyed event) {
            this.delegate.beforeApplicationDestroyed(event.getApp());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeploymentListenerObserver)) {
                return false;
            }
            DeploymentListenerObserver that = (DeploymentListenerObserver)o;
            return !(this.delegate == null ? that.delegate != null : !this.delegate.equals(that.delegate));
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }
    }

    private static class PersistenceClassLoaderHandlerImpl
    implements PersistenceClassLoaderHandler {
        private static boolean logged = false;
        private final Map<String, List<ClassFileTransformer>> transformers = new TreeMap<String, List<ClassFileTransformer>>();

        private PersistenceClassLoaderHandlerImpl() {
        }

        @Override
        public void addTransformer(String unitId, ClassLoader classLoader, ClassFileTransformer classFileTransformer) {
            Instrumentation instrumentation = Agent.getInstrumentation();
            if (instrumentation != null) {
                instrumentation.addTransformer(classFileTransformer);
                if (unitId != null) {
                    List<ClassFileTransformer> transformers = this.transformers.get(unitId);
                    if (transformers == null) {
                        transformers = new ArrayList<ClassFileTransformer>(1);
                        this.transformers.put(unitId, transformers);
                    }
                    transformers.add(classFileTransformer);
                }
            } else if (!logged) {
                logger.warning("assembler.noAgent");
                logged = true;
            }
        }

        @Override
        public void destroy(String unitId) {
            List<ClassFileTransformer> transformers = this.transformers.remove(unitId);
            if (transformers != null) {
                Instrumentation instrumentation = Agent.getInstrumentation();
                if (instrumentation != null) {
                    for (ClassFileTransformer transformer : transformers) {
                        instrumentation.removeTransformer(transformer);
                    }
                } else {
                    logger.error("assembler.noAgent");
                }
            }
        }

        @Override
        public ClassLoader getNewTempClassLoader(ClassLoader classLoader) {
            return ClassLoaderUtil.createTempClassLoader(classLoader);
        }
    }
}

