/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.service.impl;

import com.sun.jersey.api.client.ClientHandlerException;
import java.net.ConnectException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.nutch.webui.client.NutchClientFactory;
import org.apache.nutch.webui.client.model.ConnectionStatus;
import org.apache.nutch.webui.client.model.NutchStatus;
import org.apache.nutch.webui.model.NutchInstance;
import org.apache.nutch.webui.service.NutchInstanceService;
import org.apache.nutch.webui.service.NutchService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NutchServiceImpl
implements NutchService {
    private static final Logger logger = LoggerFactory.getLogger(NutchServiceImpl.class);
    @Resource
    private NutchClientFactory nutchClientFactory;
    @Resource
    private NutchInstanceService instanceService;

    @Override
    public ConnectionStatus getConnectionStatus(Long instanceId) {
        NutchInstance instance = this.instanceService.getInstance(instanceId);
        try {
            NutchStatus nutchStatus = this.nutchClientFactory.getClient(instance).getNutchStatus();
            if (nutchStatus.getStartDate() != null) {
                return ConnectionStatus.CONNECTED;
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConnectException) {
                return ConnectionStatus.DISCONNECTED;
            }
            logger.error("Cannot connect to nutch server!", (Throwable)e);
        }
        return null;
    }

    @Override
    public Map<String, String> getNutchConfig(Long instanceId) {
        NutchInstance instance = this.instanceService.getInstance(instanceId);
        try {
            return this.nutchClientFactory.getClient(instance).getNutchConfig("default");
        }
        catch (ClientHandlerException exception) {
            return Collections.emptyMap();
        }
    }

    @Override
    public NutchStatus getNutchStatus(Long instanceId) {
        NutchInstance instance = this.instanceService.getInstance(instanceId);
        return this.nutchClientFactory.getClient(instance).getNutchStatus();
    }
}

