/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.service.impl;

import com.j256.ormlite.dao.Dao;
import java.sql.SQLException;
import java.util.List;
import javax.annotation.Resource;
import org.apache.nutch.webui.client.NutchClient;
import org.apache.nutch.webui.client.NutchClientFactory;
import org.apache.nutch.webui.client.impl.CrawlingCycle;
import org.apache.nutch.webui.client.impl.CrawlingCycleListener;
import org.apache.nutch.webui.client.impl.RemoteCommand;
import org.apache.nutch.webui.client.impl.RemoteCommandExecutor;
import org.apache.nutch.webui.client.impl.RemoteCommandsBatchFactory;
import org.apache.nutch.webui.client.model.Crawl;
import org.apache.nutch.webui.model.NutchInstance;
import org.apache.nutch.webui.service.CrawlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CrawlServiceImpl
implements CrawlService,
CrawlingCycleListener {
    private Logger log = LoggerFactory.getLogger(CrawlServiceImpl.class);
    @Resource
    private Dao<Crawl, Long> crawlDao;
    @Resource
    private NutchClientFactory nutchClientFactory;
    @Resource
    private RemoteCommandsBatchFactory commandFactory;

    @Override
    @Async
    public void startCrawl(Long crawlId, NutchInstance instance) {
        Crawl crawl = null;
        try {
            crawl = (Crawl)this.crawlDao.queryForId((Object)crawlId);
            NutchClient client = this.nutchClientFactory.getClient(instance);
            String seedDirectory = client.createSeed(crawl.getSeedList());
            crawl.setSeedDirectory(seedDirectory);
            List<RemoteCommand> commands = this.commandFactory.createCommands(crawl);
            RemoteCommandExecutor executor = new RemoteCommandExecutor(client);
            CrawlingCycle cycle = new CrawlingCycle(this, executor, crawl, commands);
            cycle.executeCrawlCycle();
        }
        catch (Exception e) {
            crawl.setStatus(Crawl.CrawlStatus.ERROR);
            this.saveCrawl(crawl);
            this.log.error("exception occured", (Throwable)e);
        }
    }

    @Override
    public List<Crawl> getCrawls() {
        try {
            return this.crawlDao.queryForAll();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void saveCrawl(Crawl crawl) {
        try {
            this.crawlDao.createOrUpdate((Object)crawl);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteCrawl(Long crawlId) {
        try {
            this.crawlDao.deleteById((Object)crawlId);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void crawlingStarted(Crawl crawl) {
        crawl.setStatus(Crawl.CrawlStatus.CRAWLING);
        crawl.setProgress(0);
        this.saveCrawl(crawl);
    }

    @Override
    public void onCrawlError(Crawl crawl, String msg) {
        crawl.setStatus(Crawl.CrawlStatus.ERROR);
        this.saveCrawl(crawl);
    }

    @Override
    public void commandExecuted(Crawl crawl, RemoteCommand command, int progress) {
        crawl.setProgress(progress);
        this.saveCrawl(crawl);
    }

    @Override
    public void crawlingFinished(Crawl crawl) {
        crawl.setStatus(Crawl.CrawlStatus.FINISHED);
        this.saveCrawl(crawl);
    }
}

