/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.pages.seed;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Iterator;
import org.apache.nutch.webui.model.SeedList;
import org.apache.nutch.webui.model.SeedUrl;
import org.apache.nutch.webui.pages.AbstractBasePage;
import org.apache.nutch.webui.pages.components.CpmIteratorAdapter;
import org.apache.nutch.webui.pages.seed.SeedListsPage;
import org.apache.nutch.webui.service.SeedListService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class SeedPage
extends AbstractBasePage<SeedList> {
    @SpringBean
    private SeedListService seedListService;
    private Form<SeedUrl> urlForm;
    private WebMarkupContainer seedUrlsTable;

    public SeedPage() {
        SeedList list = new SeedList();
        list.setSeedUrls(Lists.newArrayList());
        this.initPage((IModel<SeedList>)Model.of((Serializable)list));
    }

    public SeedPage(final PageParameters parameters) {
        this.initPage((IModel<SeedList>)new LoadableDetachableModel<SeedList>(){

            protected SeedList load() {
                Long seedListId = parameters.get("id").toLongObject();
                return SeedPage.this.seedListService.getSeedList(seedListId);
            }
        });
    }

    public void initPage(IModel<SeedList> model) {
        this.setModel((IModel)new CompoundPropertyModel(model));
        this.addBaseForm();
        this.addSeedUrlsList();
        this.addUrlForm();
    }

    private void addBaseForm() {
        Form<SeedList> form = new Form<SeedList>("seedList", this.getModel()){

            protected void onSubmit() {
                SeedPage.this.seedListService.save((SeedList)this.getModelObject());
                this.setResponsePage(SeedListsPage.class);
            }
        };
        form.add(new Component[]{new TextField("name")});
        this.add(new Component[]{form});
    }

    private void addSeedUrlsList() {
        this.seedUrlsTable = new WebMarkupContainer("seedUrlsTable");
        this.seedUrlsTable.setOutputMarkupId(true);
        RefreshingView<SeedUrl> seedUrls = new RefreshingView<SeedUrl>("seedUrls"){

            protected Iterator<IModel<SeedUrl>> getItemModels() {
                return new CpmIteratorAdapter<SeedUrl>(((SeedList)SeedPage.this.getModelObject()).getSeedUrls());
            }

            protected void populateItem(Item<SeedUrl> item) {
                item.add(new Component[]{new Label("url")});
                item.add(new Component[]{new AjaxLink<SeedUrl>("delete", item.getModel()){

                    public void onClick(AjaxRequestTarget target) {
                        SeedPage.this.deleteSeedUrl((SeedUrl)this.getModelObject());
                        target.add(new Component[]{SeedPage.this.seedUrlsTable});
                    }
                }});
            }
        };
        this.seedUrlsTable.add(new Component[]{seedUrls});
        this.add(new Component[]{this.seedUrlsTable});
    }

    private void addUrlForm() {
        this.urlForm = new Form("urlForm", (IModel)CompoundPropertyModel.of((IModel)Model.of((Serializable)new SeedUrl())));
        this.urlForm.setOutputMarkupId(true);
        this.urlForm.add(new Component[]{new TextField("url")});
        this.urlForm.add(new Component[]{new AjaxSubmitLink("addUrl", this.urlForm){

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                SeedPage.this.addSeedUrl();
                SeedPage.this.urlForm.setModelObject((Object)new SeedUrl());
                target.add(new Component[]{SeedPage.this.urlForm});
                target.add(new Component[]{SeedPage.this.seedUrlsTable});
            }
        }});
        this.add(new Component[]{this.urlForm});
    }

    private void addSeedUrl() {
        SeedUrl url = (SeedUrl)this.urlForm.getModelObject();
        SeedList seedList = (SeedList)this.getModelObject();
        url.setSeedList(seedList);
        seedList.getSeedUrls().add(url);
    }

    private void deleteSeedUrl(SeedUrl url) {
        SeedList seedList = (SeedList)this.getModelObject();
        seedList.getSeedUrls().remove(url);
    }
}

