/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.pages.seed;

import java.util.Iterator;
import org.apache.nutch.webui.model.SeedList;
import org.apache.nutch.webui.pages.AbstractBasePage;
import org.apache.nutch.webui.pages.components.CpmIteratorAdapter;
import org.apache.nutch.webui.pages.seed.SeedPage;
import org.apache.nutch.webui.service.SeedListService;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class SeedListsPage
extends AbstractBasePage<Void> {
    @SpringBean
    private SeedListService seedListService;

    public SeedListsPage() {
        RefreshingView<SeedList> seedLists = new RefreshingView<SeedList>("seedLists"){

            protected Iterator<IModel<SeedList>> getItemModels() {
                return new CpmIteratorAdapter<SeedList>(SeedListsPage.this.seedListService.findAll());
            }

            protected void populateItem(final Item<SeedList> item) {
                PageParameters params = new PageParameters();
                params.add("id", (Object)((SeedList)item.getModelObject()).getId());
                BookmarkablePageLink edit = new BookmarkablePageLink("edit", SeedPage.class, params);
                edit.add(new Component[]{new Label("name")});
                item.add(new Component[]{edit});
                item.add(new Component[]{new Label("seedUrlsCount")});
                item.add(new Component[]{new Link<SeedList>("delete", item.getModel()){

                    public void onClick() {
                        SeedListsPage.this.seedListService.delete(((SeedList)item.getModelObject()).getId());
                    }
                }});
            }
        };
        this.add(new Component[]{seedLists});
        this.add(new Component[]{new BookmarkablePageLink("newSeedList", SeedPage.class)});
    }
}

