/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.pages.instances;

import de.agilecoders.wicket.core.markup.html.bootstrap.block.LabelType;
import java.util.Iterator;
import org.apache.nutch.webui.client.model.ConnectionStatus;
import org.apache.nutch.webui.model.NutchInstance;
import org.apache.nutch.webui.pages.AbstractBasePage;
import org.apache.nutch.webui.pages.components.ColorEnumLabel;
import org.apache.nutch.webui.pages.components.ColorEnumLabelBuilder;
import org.apache.nutch.webui.pages.components.CpmIteratorAdapter;
import org.apache.nutch.webui.pages.instances.InstancePanel;
import org.apache.nutch.webui.service.NutchInstanceService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.time.Duration;

public class InstancesPage
extends AbstractBasePage<Void> {
    @SpringBean
    private NutchInstanceService instanceService;
    private InstancePanel instancePanel;
    private WebMarkupContainer instancesTable = new WebMarkupContainer("instancesTable");
    private static final Duration UPDATE_TIMEOUT = Duration.seconds((int)1);

    public InstancesPage() {
        this.instancesTable.setOutputMarkupId(true);
        this.instancesTable.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(UPDATE_TIMEOUT)});
        this.instancePanel = new InstancePanel("instanceForm");
        RefreshingView<NutchInstance> instances = this.refreshingView();
        this.instancesTable.add(new Component[]{instances});
        this.add(new Component[]{this.instancesTable});
        this.add(new Component[]{this.instancePanel});
        this.add(new Component[]{this.addInstanceButton()});
    }

    private RefreshingView<NutchInstance> refreshingView() {
        RefreshingView<NutchInstance> instances = new RefreshingView<NutchInstance>("instances"){

            protected Iterator<IModel<NutchInstance>> getItemModels() {
                return new CpmIteratorAdapter<NutchInstance>(InstancesPage.this.instanceService.getInstances());
            }

            protected void populateItem(Item<NutchInstance> item) {
                InstancesPage.this.populateInstanceRow((Item<NutchInstance>)item);
            }
        };
        return instances;
    }

    private AjaxLink<NutchInstance> addInstanceButton() {
        return new AjaxLink<NutchInstance>("addInstance"){

            public void onClick(AjaxRequestTarget target) {
                InstancesPage.this.instancePanel.setModel((IModel<NutchInstance>)new CompoundPropertyModel((Object)new NutchInstance()));
                target.add(new Component[]{InstancesPage.this.instancePanel});
                InstancesPage.this.instancePanel.appendShowDialogJavaScript(target);
            }
        };
    }

    private void populateInstanceRow(final Item<NutchInstance> item) {
        item.add(new Component[]{new AjaxLink<NutchInstance>("editInstance"){

            public void onClick(AjaxRequestTarget target) {
                InstancesPage.this.instancePanel.setModel((IModel<NutchInstance>)item.getModel());
                target.add(new Component[]{InstancesPage.this.instancePanel});
                InstancesPage.this.instancePanel.appendShowDialogJavaScript(target);
            }
        }.add(new Component[]{new Label("name")})});
        item.add(new Component[]{new Label("host")});
        item.add(new Component[]{new Label("username")});
        item.add(new Component[]{this.createStatusLabel()});
        item.add(new Component[]{new AjaxLink<NutchInstance>("instanceDelete", item.getModel()){

            public void onClick(AjaxRequestTarget target) {
                InstancesPage.this.instanceService.removeInstance(((NutchInstance)this.getModelObject()).getId());
                target.add(new Component[]{InstancesPage.this.instancesTable});
            }
        }});
    }

    private ColorEnumLabel<ConnectionStatus> createStatusLabel() {
        return new ColorEnumLabelBuilder<ConnectionStatus>("connectionStatus").withEnumColor(ConnectionStatus.CONNECTED, LabelType.Success).withEnumColor(ConnectionStatus.CONNECTING, LabelType.Info).withEnumColor(ConnectionStatus.DISCONNECTED, LabelType.Danger).build();
    }
}

