/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.pages.crawls;

import de.agilecoders.wicket.core.markup.html.bootstrap.block.LabelType;
import java.util.Iterator;
import org.apache.nutch.webui.client.model.Crawl;
import org.apache.nutch.webui.pages.AbstractBasePage;
import org.apache.nutch.webui.pages.components.ColorEnumLabelBuilder;
import org.apache.nutch.webui.pages.components.CpmIteratorAdapter;
import org.apache.nutch.webui.pages.crawls.CrawlPanel;
import org.apache.nutch.webui.service.CrawlService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.EnumLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.time.Duration;

public class CrawlsPage
extends AbstractBasePage<Void> {
    private static final Duration UPDATE_TIMEOUT = Duration.seconds((int)2);
    @SpringBean
    private CrawlService crawlService;
    private WebMarkupContainer crawlsTable = new WebMarkupContainer("crawlsTable");
    private CrawlPanel crawlPanel;

    public CrawlsPage() {
        this.crawlsTable.setOutputMarkupId(true);
        this.crawlsTable.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(UPDATE_TIMEOUT)});
        RefreshingView<Crawl> crawls = new RefreshingView<Crawl>("crawls"){

            protected Iterator<IModel<Crawl>> getItemModels() {
                return new CpmIteratorAdapter<Crawl>(CrawlsPage.this.crawlService.getCrawls());
            }

            protected void populateItem(Item<Crawl> item) {
                CrawlsPage.this.populateCrawlRow((Item<Crawl>)item);
            }
        };
        this.crawlsTable.add(new Component[]{crawls});
        this.add(new Component[]{this.crawlsTable});
        this.crawlPanel = new CrawlPanel("crawl");
        this.add(new Component[]{this.crawlPanel});
        this.add(new Component[]{new AjaxLink<Crawl>("newCrawl"){

            public void onClick(AjaxRequestTarget target) {
                CrawlsPage.this.editCrawl(target, (IModel<Crawl>)((IModel)new CompoundPropertyModel((Object)CrawlsPage.this.createNewCrawl())));
            }
        }});
    }

    private void populateCrawlRow(Item<Crawl> item) {
        item.add(new Component[]{new AjaxLink<Crawl>("edit", item.getModel()){

            public void onClick(AjaxRequestTarget target) {
                CrawlsPage.this.editCrawl(target, (IModel<Crawl>)this.getModel());
            }
        }.add(new Component[]{new Label("crawlName")})});
        item.add(new Component[]{new Label("seedList.name")});
        item.add(new Component[]{new Label("progress")});
        item.add(new Component[]{this.createStatusLabel()});
        item.add(new Component[]{new Link<Crawl>("start", item.getModel()){

            public void onClick() {
                CrawlsPage.this.crawlService.startCrawl(((Crawl)this.getModelObject()).getId(), CrawlsPage.this.getCurrentInstance());
            }
        }});
        item.add(new Component[]{new Link<Crawl>("delete", item.getModel()){

            public void onClick() {
                CrawlsPage.this.crawlService.deleteCrawl(((Crawl)this.getModelObject()).getId());
            }
        }});
    }

    private void editCrawl(AjaxRequestTarget target, IModel<Crawl> model) {
        this.crawlPanel.setModel(model);
        target.add(new Component[]{this.crawlPanel});
        this.crawlPanel.appendShowDialogJavaScript(target);
    }

    private Crawl createNewCrawl() {
        return new Crawl();
    }

    private EnumLabel<Crawl.CrawlStatus> createStatusLabel() {
        return new ColorEnumLabelBuilder<Crawl.CrawlStatus>("status").withEnumColor(Crawl.CrawlStatus.NEW, LabelType.Default).withEnumColor(Crawl.CrawlStatus.ERROR, LabelType.Danger).withEnumColor(Crawl.CrawlStatus.FINISHED, LabelType.Success).withEnumColor(Crawl.CrawlStatus.CRAWLING, LabelType.Info).build();
    }
}

