/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.pages.crawls;

import com.google.common.collect.Lists;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.core.markup.html.bootstrap.form.BootstrapForm;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.nutch.webui.client.model.Crawl;
import org.apache.nutch.webui.service.CrawlService;
import org.apache.nutch.webui.service.SeedListService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class CrawlPanel
extends Modal {
    private static final int MAX_ROUNDS = 10;
    private BootstrapForm<Crawl> form;
    @SpringBean
    private CrawlService crawlService;
    @SpringBean
    private SeedListService seedListService;
    private NotificationPanel notificationPanel;

    public CrawlPanel(String markupId) {
        super(markupId);
        this.header((IModel)Model.of((Serializable)((Object)"Crawl")));
        this.notificationPanel = new NotificationPanel("notificationPanel");
        this.notificationPanel.setOutputMarkupId(true);
        this.add(new Component[]{this.notificationPanel});
        this.form = new BootstrapForm("crawlForm");
        this.form.add(new Component[]{new Label("crawlId")});
        this.form.add(new Component[]{new TextField("crawlName").setRequired(true)});
        this.form.add(new Component[]{new DropDownChoice("numberOfRounds", this.getNumbersOfRounds())});
        this.form.add(new Component[]{new DropDownChoice("seedList", this.seedListService.findAll(), (IChoiceRenderer)new ChoiceRenderer("name")).setRequired(true)});
        this.addButton((Component)new AjaxSubmitLink("button", (Form)this.form){

            protected void onSubmit(AjaxRequestTarget target, Form<?> ajaxForm) {
                CrawlPanel.this.crawlService.saveCrawl((Crawl)CrawlPanel.this.form.getModelObject());
                target.add(new Component[]{this.getPage()});
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{CrawlPanel.this.notificationPanel});
            }
        }.setBody((IModel)Model.of((Serializable)((Object)"Save"))));
        this.add(new Component[]{this.form});
    }

    public void setModel(IModel<Crawl> model) {
        this.form.setModel(model);
    }

    private List<Integer> getNumbersOfRounds() {
        ArrayList numbers = Lists.newArrayList();
        for (int i = 1; i <= 10; ++i) {
            numbers.add(i);
        }
        return numbers;
    }
}

