/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.pages;

import org.apache.nutch.webui.client.model.NutchStatus;
import org.apache.nutch.webui.model.NutchInstance;
import org.apache.nutch.webui.pages.AbstractBasePage;
import org.apache.nutch.webui.pages.instances.InstancesPage;
import org.apache.nutch.webui.service.NutchService;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxSelfUpdatingTimerBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.time.Duration;

public class DashboardPage
extends AbstractBasePage<Object> {
    @SpringBean
    private NutchService nutchService;
    private WebMarkupContainer panel = new WebMarkupContainer("panel");

    public DashboardPage() {
        this.panel.setOutputMarkupId(true);
        this.panel.add(new Behavior[]{new AjaxSelfUpdatingTimerBehavior(Duration.ONE_SECOND)});
        this.panel.add(new Component[]{new Label("jobsRunning", (IModel)new JobsModel())});
        this.add(new Component[]{this.panel});
        this.add(new Component[]{new BookmarkablePageLink("viewInstances", InstancesPage.class)});
    }

    private class JobsModel
    extends LoadableDetachableModel<Integer> {
        private JobsModel() {
        }

        protected Integer load() {
            NutchInstance currentInstance = DashboardPage.this.getCurrentInstance();
            Long id = currentInstance.getId();
            NutchStatus nutchStatus = DashboardPage.this.nutchService.getNutchStatus(id);
            return nutchStatus.getRunningJobs().size();
        }
    }
}

