/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.pages;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.DropDownButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.MenuBookmarkablePageLink;
import de.agilecoders.wicket.core.markup.html.bootstrap.button.dropdown.MenuDivider;
import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import de.agilecoders.wicket.core.markup.html.bootstrap.image.IconType;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.Navbar;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarButton;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarComponents;
import de.agilecoders.wicket.core.markup.html.bootstrap.navbar.NavbarDropDownButton;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.icon.FontAwesomeIconType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.nutch.webui.model.NutchInstance;
import org.apache.nutch.webui.pages.DashboardPage;
import org.apache.nutch.webui.pages.LogOutPage;
import org.apache.nutch.webui.pages.SchedulingPage;
import org.apache.nutch.webui.pages.SearchPage;
import org.apache.nutch.webui.pages.StatisticsPage;
import org.apache.nutch.webui.pages.UserSettingsPage;
import org.apache.nutch.webui.pages.crawls.CrawlsPage;
import org.apache.nutch.webui.pages.instances.InstancesPage;
import org.apache.nutch.webui.pages.menu.VerticalMenu;
import org.apache.nutch.webui.pages.seed.SeedListsPage;
import org.apache.nutch.webui.pages.settings.SettingsPage;
import org.apache.nutch.webui.service.NutchInstanceService;
import org.apache.nutch.webui.service.NutchService;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.GenericWebPage;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public abstract class AbstractBasePage<T>
extends GenericWebPage<T> {
    @SpringBean
    private NutchService service;
    @SpringBean
    private NutchInstanceService instanceService;
    private VerticalMenu navbar;
    protected IModel<NutchInstance> currentInstance = new InstanceModel();

    public AbstractBasePage() {
        this.navbar = new VerticalMenu("navigation");
        this.navbar.brandName((IModel)Model.of((Serializable)((Object)"Apache Nutch GUI")));
        this.navbar.setInverted(true);
        this.navbar.setPosition(Navbar.Position.TOP);
        this.add(new Component[]{this.navbar});
        this.addMenuItem(DashboardPage.class, "navbar.menu.dashboard", (IconType)FontAwesomeIconType.dashboard);
        this.addMenuItem(StatisticsPage.class, "navbar.menu.statistics", (IconType)FontAwesomeIconType.bar_chart_o);
        this.addMenuItem(InstancesPage.class, "navbar.menu.instances", (IconType)FontAwesomeIconType.gears);
        this.addMenuItem(SettingsPage.class, "navbar.menu.settings", (IconType)FontAwesomeIconType.wrench);
        this.addMenuItem(CrawlsPage.class, "navbar.menu.crawls", (IconType)FontAwesomeIconType.refresh);
        this.addMenuItem(SchedulingPage.class, "navbar.menu.scheduling", (IconType)FontAwesomeIconType.clock_o);
        this.addMenuItem(SearchPage.class, "navbar.menu.search", (IconType)FontAwesomeIconType.search);
        this.addMenuItem(SeedListsPage.class, "navbar.menu.seedLists", (IconType)FontAwesomeIconType.file);
        this.navbar.addComponents(NavbarComponents.transform((Navbar.ComponentPosition)Navbar.ComponentPosition.RIGHT, (Component[])new Component[]{this.addInstancesMenuMenu()}));
        this.navbar.addComponents(NavbarComponents.transform((Navbar.ComponentPosition)Navbar.ComponentPosition.RIGHT, (Component[])new Component[]{this.addUserMenu()}));
        this.add(new Component[]{new NotificationPanel("globalNotificationPanel")});
        if (this.currentInstance.getObject() == null && !(this instanceof InstancesPage)) {
            this.getSession().error((Serializable)((Object)"No running instances found!"));
            this.setResponsePage(InstancesPage.class);
        }
    }

    protected Component addUserMenu() {
        DropDownButton userMenu = new NavbarDropDownButton((IModel)Model.of((Serializable)((Object)"Username"))){

            protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                ArrayList subMenu = Lists.newArrayList();
                subMenu.add(new MenuBookmarkablePageLink(UserSettingsPage.class, (IModel)new ResourceModel("navbar.userMenu.settings")).setIconType((IconType)FontAwesomeIconType.gear));
                subMenu.add(new MenuDivider());
                subMenu.add(new MenuBookmarkablePageLink(LogOutPage.class, (IModel)new ResourceModel("navbar.userMenu.logout")).setIconType((IconType)FontAwesomeIconType.power_off));
                return subMenu;
            }
        }.setIconType((IconType)FontAwesomeIconType.user);
        return userMenu;
    }

    protected Component addInstancesMenuMenu() {
        PropertyModel instanceName = PropertyModel.of(this.currentInstance, (String)"name");
        DropDownButton instancesMenu = new NavbarDropDownButton((IModel)instanceName){

            protected List<AbstractLink> newSubMenuButtons(String buttonMarkupId) {
                List<NutchInstance> instances = AbstractBasePage.this.instanceService.getInstances();
                ArrayList subMenu = Lists.newArrayList();
                for (NutchInstance instance : instances) {
                    subMenu.add(new Link<NutchInstance>(buttonMarkupId, (IModel)Model.of((Serializable)instance)){

                        public void onClick() {
                            AbstractBasePage.this.currentInstance.setObject(this.getModelObject());
                            this.setResponsePage(DashboardPage.class);
                        }
                    }.setBody((IModel)Model.of((Serializable)((Object)instance.getName()))));
                }
                return subMenu;
            }
        }.setIconType((IconType)FontAwesomeIconType.gears);
        return instancesMenu;
    }

    private <P extends Page> void addMenuItem(Class<P> page, String label, IconType icon) {
        NavbarButton button = new NavbarButton(page, (IModel)Model.of((Serializable)((Object)this.getString(label)))).setIconType(icon);
        this.navbar.addComponents(NavbarComponents.transform((Navbar.ComponentPosition)Navbar.ComponentPosition.LEFT, (Component[])new Component[]{button}));
    }

    protected NutchInstance getCurrentInstance() {
        return (NutchInstance)this.currentInstance.getObject();
    }

    private class InstanceModel
    extends LoadableDetachableModel<NutchInstance> {
        private InstanceModel() {
        }

        public void setObject(NutchInstance instance) {
            super.setObject((Object)instance);
            AbstractBasePage.this.getSession().setAttribute("instanceId", (Serializable)instance.getId());
        }

        protected NutchInstance load() {
            Long instanceId = (Long)AbstractBasePage.this.getSession().getAttribute("instanceId");
            if (instanceId == null) {
                return this.getFirstInstance();
            }
            return AbstractBasePage.this.instanceService.getInstance(instanceId);
        }

        private NutchInstance getFirstInstance() {
            return (NutchInstance)Iterables.getFirst(AbstractBasePage.this.instanceService.getInstances(), null);
        }
    }
}

