/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.config;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.db.H2DatabaseType;
import com.j256.ormlite.jdbc.JdbcConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import org.apache.nutch.webui.client.model.Crawl;
import org.apache.nutch.webui.config.CustomDaoFactory;
import org.apache.nutch.webui.config.CustomTableCreator;
import org.apache.nutch.webui.model.NutchInstance;
import org.apache.nutch.webui.model.SeedList;
import org.apache.nutch.webui.model.SeedUrl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class SpringConfiguration
implements AsyncConfigurer {
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(7);
        executor.setMaxPoolSize(42);
        executor.setQueueCapacity(11);
        executor.setThreadNamePrefix("SpringExecutor-");
        executor.initialize();
        return executor;
    }

    @Bean
    public JdbcConnectionSource getConnectionSource() throws SQLException {
        JdbcConnectionSource source = new JdbcConnectionSource("jdbc:h2:~/.nutch/config", (DatabaseType)new H2DatabaseType());
        source.initialize();
        return source;
    }

    @Bean
    public CustomDaoFactory getDaoFactory() throws SQLException {
        return new CustomDaoFactory((ConnectionSource)this.getConnectionSource());
    }

    @Bean
    public Dao<NutchInstance, Long> createNutchDao() throws SQLException {
        return this.getDaoFactory().createDao(NutchInstance.class);
    }

    @Bean
    public Dao<SeedList, Long> createSeedListDao() throws SQLException {
        return this.getDaoFactory().createDao(SeedList.class);
    }

    @Bean
    public Dao<SeedUrl, Long> createSeedUrlDao() throws SQLException {
        return this.getDaoFactory().createDao(SeedUrl.class);
    }

    @Bean
    public Dao<Crawl, Long> createCrawlDao() throws SQLException {
        return this.getDaoFactory().createDao(Crawl.class);
    }

    @Bean
    public CustomTableCreator createTableCreator() throws SQLException {
        return new CustomTableCreator((ConnectionSource)this.getConnectionSource(), this.getDaoFactory().getCreatedDaos());
    }
}

