/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.config;

import com.j256.ormlite.dao.BaseDaoImpl;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTableConfig;
import com.j256.ormlite.table.TableUtils;
import java.sql.SQLException;
import java.util.List;

public class CustomTableCreator {
    private ConnectionSource connectionSource;
    private List<Dao<?, ?>> configuredDaos;

    public CustomTableCreator(ConnectionSource connectionSource, List<Dao<?, ?>> configuredDaos) {
        this.connectionSource = connectionSource;
        this.configuredDaos = configuredDaos;
        this.initialize();
    }

    private void initialize() {
        if (this.configuredDaos == null) {
            throw new IllegalStateException("configuredDaos was not set in " + this.getClass().getSimpleName());
        }
        for (Dao<?, ?> dao : this.configuredDaos) {
            this.createTableForDao(dao);
        }
    }

    private void createTableForDao(Dao<?, ?> dao) {
        DatabaseTableConfig<?> tableConfig = this.getTableConfig(dao);
        this.createTableIfNotExists(tableConfig);
    }

    private DatabaseTableConfig<?> getTableConfig(Dao<?, ?> dao) {
        Class clazz = dao.getDataClass();
        DatabaseTableConfig tableConfig = null;
        if (dao instanceof BaseDaoImpl) {
            tableConfig = ((BaseDaoImpl)dao).getTableConfig();
        }
        if (tableConfig == null) {
            return this.getConfigFromClass(clazz);
        }
        return tableConfig;
    }

    private DatabaseTableConfig<?> getConfigFromClass(Class<?> clazz) {
        try {
            return DatabaseTableConfig.fromClass((ConnectionSource)this.connectionSource, clazz);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void createTableIfNotExists(DatabaseTableConfig<?> tableConfig) {
        try {
            TableUtils.createTableIfNotExists((ConnectionSource)this.connectionSource, tableConfig);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

