/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.client.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.nutch.webui.client.impl.RemoteCommand;
import org.apache.nutch.webui.client.impl.RemoteCommandBuilder;
import org.apache.nutch.webui.client.model.Crawl;
import org.apache.nutch.webui.client.model.JobInfo;
import org.joda.time.Duration;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RemoteCommandsBatchFactory {
    private List<RemoteCommand> remoteCommands;
    private Crawl crawl;
    private String batchId;

    public List<RemoteCommand> createCommands(Crawl crawl) {
        this.crawl = crawl;
        this.remoteCommands = Lists.newArrayList();
        this.remoteCommands.add(this.inject());
        for (int i = 0; i < crawl.getNumberOfRounds(); ++i) {
            this.remoteCommands.addAll(this.createBatchCommands());
        }
        return this.remoteCommands;
    }

    private List<RemoteCommand> createBatchCommands() {
        this.batchId = UUID.randomUUID().toString();
        ArrayList batchCommands = Lists.newArrayList();
        batchCommands.add(this.createGenerateCommand());
        batchCommands.add(this.createFetchCommand());
        batchCommands.add(this.createParseCommand());
        batchCommands.add(this.createUpdateDbCommand());
        batchCommands.add(this.createIndexCommand());
        return batchCommands;
    }

    private RemoteCommand inject() {
        RemoteCommandBuilder builder = RemoteCommandBuilder.instance(JobInfo.JobType.INJECT).withCrawlId(this.crawl.getCrawlId()).withArgument("seedDir", this.crawl.getSeedDirectory());
        return builder.build();
    }

    private RemoteCommand createGenerateCommand() {
        return this.createBuilder(JobInfo.JobType.GENERATE).build();
    }

    private RemoteCommand createFetchCommand() {
        return this.createBuilder(JobInfo.JobType.FETCH).withTimeout(Duration.standardSeconds((long)50L)).build();
    }

    private RemoteCommand createParseCommand() {
        return this.createBuilder(JobInfo.JobType.PARSE).build();
    }

    private RemoteCommand createIndexCommand() {
        return this.createBuilder(JobInfo.JobType.INDEX).build();
    }

    private RemoteCommand createUpdateDbCommand() {
        return this.createBuilder(JobInfo.JobType.UPDATEDB).build();
    }

    private RemoteCommandBuilder createBuilder(JobInfo.JobType jobType) {
        return RemoteCommandBuilder.instance(jobType).withCrawlId(this.crawl.getCrawlId()).withArgument("batch", this.batchId);
    }
}

