/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.client.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.nutch.webui.client.NutchClient;
import org.apache.nutch.webui.client.impl.RemoteCommand;
import org.apache.nutch.webui.client.model.JobInfo;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteCommandExecutor {
    private Logger log = LoggerFactory.getLogger(RemoteCommandExecutor.class);
    private static final int DEFAULT_TIMEOUT_SEC = 60;
    private Duration requestDelay = new Duration(500L);
    private NutchClient client;
    private ExecutorService executor;

    public RemoteCommandExecutor(NutchClient client) {
        this.client = client;
        this.executor = Executors.newSingleThreadExecutor();
    }

    public JobInfo executeRemoteJob(RemoteCommand command) {
        try {
            String jobId = this.client.executeJob(command.getJobConfig());
            Future<JobInfo> chekerFuture = this.executor.submit(new JobStateChecker(jobId));
            return chekerFuture.get(this.getTimeout(command), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.log.error("Remote command failed", (Throwable)e);
            JobInfo jobInfo = new JobInfo();
            jobInfo.setState(JobInfo.State.FAILED);
            jobInfo.setMsg(ExceptionUtils.getStackTrace((Throwable)e));
            return jobInfo;
        }
    }

    private long getTimeout(RemoteCommand command) {
        if (command.getTimeout() == null) {
            return 60000L;
        }
        return command.getTimeout().getMillis();
    }

    public void setRequestDelay(Duration requestDelay) {
        this.requestDelay = requestDelay;
    }

    public class JobStateChecker
    implements Callable<JobInfo> {
        private String jobId;

        public JobStateChecker(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public JobInfo call() throws Exception {
            while (!Thread.interrupted()) {
                JobInfo jobInfo = RemoteCommandExecutor.this.client.getJobInfo(this.jobId);
                Preconditions.checkState((jobInfo != null ? 1 : 0) != 0, (Object)"Cannot get job info!");
                JobInfo.State state = jobInfo.getState();
                Preconditions.checkState((state != null ? 1 : 0) != 0, (Object)"Unknown job state!");
                if (state == JobInfo.State.RUNNING || state == JobInfo.State.ANY || state == JobInfo.State.IDLE) {
                    Thread.sleep(RemoteCommandExecutor.this.requestDelay.getMillis());
                    continue;
                }
                return jobInfo;
            }
            return null;
        }
    }
}

