/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.client.impl;

import org.apache.nutch.webui.client.impl.RemoteCommand;
import org.apache.nutch.webui.client.model.JobConfig;
import org.apache.nutch.webui.client.model.JobInfo;
import org.joda.time.Duration;

public class RemoteCommandBuilder {
    private JobConfig jobConfig = new JobConfig();
    private Duration timeout = Duration.standardSeconds((long)10L);

    private RemoteCommandBuilder() {
    }

    public static RemoteCommandBuilder instance(JobInfo.JobType jobType) {
        return new RemoteCommandBuilder().withJobType(jobType);
    }

    public RemoteCommandBuilder withJobType(JobInfo.JobType jobType) {
        this.jobConfig.setType(jobType);
        return this;
    }

    public RemoteCommandBuilder withConfigId(String configId) {
        this.jobConfig.setConfId(configId);
        return this;
    }

    public RemoteCommandBuilder withCrawlId(String crawlId) {
        this.jobConfig.setCrawlId(crawlId);
        return this;
    }

    public RemoteCommandBuilder withArgument(String key, String value) {
        this.jobConfig.setArgument(key, value);
        return this;
    }

    public RemoteCommandBuilder withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public RemoteCommand build() {
        RemoteCommand remoteCommand = new RemoteCommand(this.jobConfig);
        remoteCommand.setTimeout(this.timeout);
        return remoteCommand;
    }
}

