/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.client.impl;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.util.Map;
import org.apache.nutch.webui.client.NutchClient;
import org.apache.nutch.webui.client.model.ConnectionStatus;
import org.apache.nutch.webui.client.model.JobConfig;
import org.apache.nutch.webui.client.model.JobInfo;
import org.apache.nutch.webui.client.model.NutchStatus;
import org.apache.nutch.webui.model.NutchInstance;
import org.apache.nutch.webui.model.SeedList;

public class NutchClientImpl
implements NutchClient {
    private Client client;
    private WebResource nutchResource;
    private NutchInstance instance;

    public NutchClientImpl(NutchInstance instance) {
        this.instance = instance;
        this.createClient();
    }

    public void createClient() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", true);
        this.client = Client.create((ClientConfig)clientConfig);
        this.nutchResource = this.client.resource(this.instance.getUrl());
    }

    @Override
    public NutchStatus getNutchStatus() {
        return (NutchStatus)this.nutchResource.path("/admin").type("application/json").get(NutchStatus.class);
    }

    @Override
    public ConnectionStatus getConnectionStatus() {
        this.getNutchStatus();
        return ConnectionStatus.CONNECTED;
    }

    @Override
    public String executeJob(JobConfig jobConfig) {
        return (String)this.nutchResource.path("/job/create").type("application/json").post(String.class, (Object)jobConfig);
    }

    @Override
    public JobInfo getJobInfo(String jobId) {
        return (JobInfo)this.nutchResource.path("/job/" + jobId).type("application/json").get(JobInfo.class);
    }

    @Override
    public NutchInstance getNutchInstance() {
        return this.instance;
    }

    @Override
    public Map<String, String> getNutchConfig(String config) {
        return (Map)this.nutchResource.path("/config/" + config).type("application/json").get(Map.class);
    }

    @Override
    public String createSeed(SeedList seedList) {
        return (String)this.nutchResource.path("/seed/create").type("application/json").post(String.class, (Object)seedList);
    }
}

