/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.client.impl;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.nutch.webui.client.impl.CrawlingCycleListener;
import org.apache.nutch.webui.client.impl.RemoteCommand;
import org.apache.nutch.webui.client.impl.RemoteCommandExecutor;
import org.apache.nutch.webui.client.model.Crawl;
import org.apache.nutch.webui.client.model.JobInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrawlingCycle {
    private Logger log = LoggerFactory.getLogger(CrawlingCycle.class);
    private CrawlingCycleListener listener;
    private RemoteCommandExecutor executor;
    private Crawl crawl;
    private List<RemoteCommand> remoteCommands;
    private List<RemoteCommand> executedCommands = Lists.newArrayList();

    public CrawlingCycle(CrawlingCycleListener listener, RemoteCommandExecutor executor, Crawl crawl, List<RemoteCommand> commands) {
        this.listener = listener;
        this.executor = executor;
        this.crawl = crawl;
        this.remoteCommands = commands;
    }

    public synchronized void executeCrawlCycle() {
        this.listener.crawlingStarted(this.crawl);
        for (RemoteCommand command : this.remoteCommands) {
            JobInfo jobInfo = this.executor.executeRemoteJob(command);
            command.setJobInfo(jobInfo);
            this.log.info("Executed remote command data: {}", (Object)command);
            if (jobInfo.getState() == JobInfo.State.FAILED) {
                this.listener.onCrawlError(this.crawl, jobInfo.getMsg());
                return;
            }
            this.executedCommands.add(command);
            this.listener.commandExecuted(this.crawl, command, this.calculateProgress());
        }
        this.listener.crawlingFinished(this.crawl);
    }

    private int calculateProgress() {
        if (CollectionUtils.isEmpty(this.remoteCommands)) {
            return 0;
        }
        return (int)((float)this.executedCommands.size() / (float)this.remoteCommands.size() * 100.0f);
    }
}

