/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.apache.nutch.webui.client.NutchClient;
import org.apache.nutch.webui.client.impl.NutchClientImpl;
import org.apache.nutch.webui.model.NutchInstance;
import org.springframework.stereotype.Component;

@Component
public class NutchClientFactory {
    private LoadingCache<NutchInstance, NutchClient> cache = CacheBuilder.newBuilder().build((CacheLoader)new NutchClientCacheLoader());

    public NutchClient getClient(NutchInstance instance) {
        try {
            return (NutchClient)this.cache.get((Object)instance);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class NutchClientCacheLoader
    extends CacheLoader<NutchInstance, NutchClient> {
        private NutchClientCacheLoader() {
        }

        public NutchClient load(NutchInstance key) throws Exception {
            return new NutchClientImpl(key);
        }
    }
}

