/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.webui;

import java.util.EventListener;
import javax.servlet.Filter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.util.StringUtils;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.spring.SpringWebApplicationFactory;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.FilterHolder;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public class NutchUiServer {
    private static final String APP_FACTORY_NAME = SpringWebApplicationFactory.class.getName();
    private static final String CONFIG_LOCATION = "org.apache.nutch.webui";
    private static final String CMD_PORT = "port";
    private static Integer port = 8080;

    public static void main(String[] args) throws Exception {
        GnuParser parser = new GnuParser();
        Options options = NutchUiServer.createWebAppOptions();
        CommandLine commandLine = null;
        HelpFormatter formatter = new HelpFormatter();
        try {
            commandLine = parser.parse(options, args);
        }
        catch (Exception e) {
            formatter.printHelp("NutchUiServer", options, true);
            StringUtils.stringifyException((Throwable)e);
        }
        if (commandLine.hasOption("help")) {
            formatter.printHelp("NutchUiServer", options, true);
            return;
        }
        if (commandLine.hasOption(CMD_PORT)) {
            port = Integer.parseInt(commandLine.getOptionValue(CMD_PORT));
        }
        NutchUiServer.startServer();
    }

    private static void startServer() throws Exception, InterruptedException {
        Server server = new Server(port.intValue());
        Context context = new Context((HandlerContainer)server, "/", 1);
        context.addServlet(DefaultServlet.class, "/*");
        context.addEventListener((EventListener)new ContextLoaderListener(NutchUiServer.getContext()));
        context.addEventListener((EventListener)new RequestContextListener());
        WicketFilter filter = new WicketFilter();
        filter.setFilterPath("/");
        FilterHolder holder = new FilterHolder((Filter)filter);
        holder.setInitParameter("applicationFactoryClassName", APP_FACTORY_NAME);
        context.addFilter(holder, "/*", 0);
        server.setHandler((Handler)context);
        server.start();
        server.join();
    }

    private static WebApplicationContext getContext() {
        AnnotationConfigWebApplicationContext context = new AnnotationConfigWebApplicationContext();
        context.setConfigLocation(CONFIG_LOCATION);
        return context;
    }

    private static Options createWebAppOptions() {
        Options options = new Options();
        Option helpOpt = new Option("h", "help", false, "show this help message");
        OptionBuilder.withDescription((String)"Port to run the WebApplication on.");
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)"port number");
        options.addOption(OptionBuilder.create((String)CMD_PORT));
        options.addOption(helpOpt);
        return options;
    }
}

