/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util.domain;

import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import org.apache.gora.mapreduce.GoraMapper;
import org.apache.gora.query.Query;
import org.apache.gora.store.DataStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.storage.StorageUtils;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.NutchJob;
import org.apache.nutch.util.TableUtil;
import org.apache.nutch.util.TimingUtil;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainStatistics
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(DomainStatistics.class);
    private static final Text FETCHED_TEXT = new Text("FETCHED");
    private static final Text NOT_FETCHED_TEXT = new Text("NOT_FETCHED");
    private static final int MODE_HOST = 1;
    private static final int MODE_DOMAIN = 2;
    private static final int MODE_SUFFIX = 3;
    private Configuration conf;

    public int run(String[] args) throws IOException, ClassNotFoundException, InterruptedException {
        if (args.length < 2) {
            System.out.println("usage: DomainStatistics outDir host|domain|suffix [-numReducers n] [-crawlId <id>]");
            return 1;
        }
        String outputDir = args[0];
        int mode = 0;
        if (args[1].equals("host")) {
            mode = 1;
        } else if (args[1].equals("domain")) {
            mode = 2;
        } else if (args[1].equals("suffix")) {
            mode = 3;
        }
        this.getConf().setInt("domain.statistics.mode", mode);
        int numOfReducers = 1;
        for (int i = 0; i < args.length; ++i) {
            if ("-numReducers".equals(args[i])) {
                numOfReducers = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (!"-crawlId".equals(args[i])) continue;
            this.getConf().set("storage.crawl.id", args[i + 1]);
            ++i;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long start = System.currentTimeMillis();
        LOG.info("DomainStatistics: starting at " + sdf.format(start));
        NutchJob job = new NutchJob(this.getConf(), "Domain statistics");
        DataStore<String, WebPage> store = StorageUtils.createWebStore(job.getConfiguration(), String.class, WebPage.class);
        Query query = store.newQuery();
        query.setFields(WebPage._ALL_FIELDS);
        GoraMapper.initMapperJob((Job)job, (Query)query, store, Text.class, LongWritable.class, DomainStatisticsMapper.class, null, (boolean)true);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputDir));
        job.setOutputFormatClass(TextOutputFormat.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(LongWritable.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(LongWritable.class);
        job.setReducerClass(DomainStatisticsReducer.class);
        job.setCombinerClass(DomainStatisticsCombiner.class);
        job.setNumReduceTasks(numOfReducers);
        boolean success = job.waitForCompletion(true);
        long end = System.currentTimeMillis();
        LOG.info("DomainStatistics: finished at " + sdf.format(end) + ", elapsed: " + TimingUtil.elapsedTime(start, end));
        if (!success) {
            return -1;
        }
        return 0;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new DomainStatistics(), (String[])args);
    }

    public static class DomainStatisticsMapper
    extends GoraMapper<String, WebPage, Text, LongWritable> {
        LongWritable COUNT_1 = new LongWritable(1L);
        private int mode = 0;

        public void setup(Mapper.Context context) {
            this.mode = context.getConfiguration().getInt("domain.statistics.mode", 2);
        }

        public void close() {
        }

        protected void map(String key, WebPage value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.getStatus() == 2) {
                try {
                    URL url = new URL(TableUtil.unreverseUrl(key.toString()));
                    String out = null;
                    switch (this.mode) {
                        case 1: {
                            out = url.getHost();
                            break;
                        }
                        case 2: {
                            out = URLUtil.getDomainName(url);
                            break;
                        }
                        case 3: {
                            out = URLUtil.getDomainSuffix(url).getDomain();
                        }
                    }
                    if (out.trim().equals("")) {
                        LOG.info("url : " + url);
                        context.getCounter((Enum)MyCounter.EMPTY_RESULT).increment(1L);
                    }
                    context.write((Object)new Text(out), (Object)this.COUNT_1);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                context.getCounter((Enum)MyCounter.FETCHED).increment(1L);
                context.write((Object)FETCHED_TEXT, (Object)this.COUNT_1);
            } else {
                context.getCounter((Enum)MyCounter.NOT_FETCHED).increment(1L);
                context.write((Object)NOT_FETCHED_TEXT, (Object)this.COUNT_1);
            }
        }
    }

    public static class DomainStatisticsReducer
    extends Reducer<Text, LongWritable, LongWritable, Text> {
        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long total = 0L;
            for (LongWritable val : values) {
                total += val.get();
            }
            context.write((Object)new LongWritable(total), (Object)key);
        }
    }

    public static class DomainStatisticsCombiner
    extends Reducer<Text, LongWritable, Text, LongWritable> {
        public void reduce(Text key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long total = 0L;
            for (LongWritable val : values) {
                total += val.get();
            }
            context.write((Object)key, (Object)new LongWritable(total));
        }
    }

    public static enum MyCounter {
        FETCHED,
        NOT_FETCHED,
        EMPTY_RESULT;

    }
}

