/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.mapreduce.Job;

public abstract class NutchTool
extends Configured {
    protected HashMap<String, Object> results = new HashMap();
    protected Map<String, Object> status = Collections.synchronizedMap(new HashMap());
    protected Job currentJob;
    protected int numJobs;
    protected int currentJobNum;

    public abstract Map<String, Object> run(Map<String, Object> var1) throws Exception;

    public float getProgress() {
        float res = 0.0f;
        if (this.currentJob != null) {
            try {
                res = (this.currentJob.mapProgress() + this.currentJob.reduceProgress()) / 2.0f;
            }
            catch (IOException e) {
                e.printStackTrace();
                res = 0.0f;
            }
            catch (IllegalStateException ile) {
                ile.printStackTrace();
                res = 0.0f;
            }
        }
        if (this.numJobs > 1) {
            res = ((float)this.currentJobNum + res) / (float)this.numJobs;
        }
        this.status.put("progress", Float.valueOf(res));
        return res;
    }

    public Map<String, Object> getStatus() {
        return this.status;
    }

    public boolean stopJob() throws Exception {
        return this.killJob();
    }

    public boolean killJob() throws Exception {
        if (this.currentJob != null && !this.currentJob.isComplete()) {
            try {
                this.currentJob.killJob();
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }
}

