/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.IOException;
import org.apache.avro.util.Utf8;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.nutch.metadata.Nutch;

public class NutchJob
extends Job {
    public NutchJob(Configuration conf) throws IOException {
        super(conf);
        this.setJarByClass(((Object)((Object)this)).getClass());
    }

    public NutchJob(Configuration conf, String jobName) throws IOException {
        super(conf, jobName);
        String crawlId = conf.get("storage.crawl.id");
        if (!StringUtils.isEmpty((String)crawlId)) {
            jobName = "[" + crawlId + "]" + jobName;
            this.setJobName(jobName);
        }
        this.setJarByClass(((Object)((Object)this)).getClass());
    }

    public boolean waitForCompletion(boolean verbose) throws IOException, InterruptedException, ClassNotFoundException {
        boolean succeeded = super.waitForCompletion(verbose);
        if (!succeeded && this.getConfiguration().getBoolean("fail.on.job.failure", true)) {
            throw new RuntimeException("job failed: name=" + this.getJobName() + ", jobid=" + this.getJobID());
        }
        return succeeded;
    }

    public static boolean shouldProcess(CharSequence mark, Utf8 batchId) {
        if (mark == null) {
            return false;
        }
        boolean isAll = batchId.equals((Object)Nutch.ALL_CRAWL_ID);
        return isAll || mark.equals(batchId);
    }
}

