/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.parsers.DOMParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DomUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DomUtil.class);

    public static Element getDom(InputStream is) {
        Element element = null;
        DOMParser parser = new DOMParser();
        try {
            InputSource input = new InputSource(is);
            input.setEncoding("UTF-8");
            parser.parse(input);
            int i = 0;
            while (!(parser.getDocument().getChildNodes().item(i) instanceof Element)) {
                ++i;
            }
            element = (Element)parser.getDocument().getChildNodes().item(i);
        }
        catch (FileNotFoundException e) {
            LOG.error("Failed to find file: ", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error("Failed with the following SAX exception: ", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Failed with the following IOException", (Throwable)e);
        }
        return element;
    }

    public static void saveDom(OutputStream os, Element e) {
        DOMSource source = new DOMSource(e);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(os);
            transformer.transform(source, result);
            os.flush();
        }
        catch (UnsupportedEncodingException e1) {
            LOG.error("Failed with the following UnsupportedEncodingException: ", (Throwable)e1);
        }
        catch (IOException e1) {
            LOG.error("Failed to with the following IOException: ", (Throwable)e1);
        }
        catch (TransformerConfigurationException e2) {
            LOG.error("Failed with the following TransformerConfigurationException: ", (Throwable)e2);
        }
        catch (TransformerException ex) {
            LOG.error("Failed with the following TransformerException: ", (Throwable)ex);
        }
    }
}

