/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools.proxy;

import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.tools.proxy.DelayHandler;
import org.apache.nutch.tools.proxy.FakeHandler;
import org.apache.nutch.tools.proxy.LogDebugHandler;
import org.apache.nutch.tools.proxy.NotFoundHandler;
import org.apache.nutch.util.NutchConfiguration;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.proxy.AsyncProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedProxy {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedProxy.class);

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("TestbedProxy [-port <nnn>] [-forward] [-fake [...]] [-delay nnn] [-debug]");
            System.err.println("-port <nnn>\trun the proxy on port <nnn> (special permissions may be needed for ports < 1024)");
            System.err.println("-forward\tif specified, requests to all unknown urls will be passed to");
            System.err.println("\t\toriginal servers. If false (default) unknown urls generate 404 Not Found.");
            System.err.println("-delay\tdelay every response by nnn seconds. If delay is negative use a random value up to nnn");
            System.err.println("-fake\tif specified, requests to all unknown urls will succeed with fake content");
            System.err.println("\nAdditional options for -fake handler (all optional):");
            System.err.println("\t-hostMode (u | r)\tcreate unique host names, or pick random from a pool");
            System.err.println("\t-pageMode (u | r)\tcreate unique page names, or pick random from a pool");
            System.err.println("\t-numHosts N\ttotal number of hosts when using hostMode r");
            System.err.println("\t-numPages N\ttotal number of pages per host when using pageMode r");
            System.err.println("\t-intLinks N\tnumber of internal (same host) links per page");
            System.err.println("\t-extLinks N\tnumber of external (other host) links per page");
            System.err.println("\nDefaults for -fake handler:");
            System.err.println("\t-hostMode r");
            System.err.println("\t-pageMode r");
            System.err.println("\t-numHosts 1000000");
            System.err.println("\t-numPages 10000");
            System.err.println("\t-intLinks 10");
            System.err.println("\t-extLinks 5");
            System.exit(-1);
        }
        Configuration conf = NutchConfiguration.create();
        int port = conf.getInt("batch.proxy.port", 8181);
        boolean forward = false;
        boolean fake = false;
        boolean delay = false;
        boolean debug = false;
        int delayVal = 0;
        FakeHandler.Mode pageMode = FakeHandler.Mode.RANDOM;
        FakeHandler.Mode hostMode = FakeHandler.Mode.RANDOM;
        int numHosts = 1000000;
        int numPages = 10000;
        int intLinks = 10;
        int extLinks = 5;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-port")) {
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-forward")) {
                forward = true;
                continue;
            }
            if (args[i].equals("-delay")) {
                delay = true;
                delayVal = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-fake")) {
                fake = true;
                continue;
            }
            if (args[i].equals("-hostMode")) {
                if (!args[++i].equals("u")) continue;
                hostMode = FakeHandler.Mode.UNIQUE;
                continue;
            }
            if (args[i].equals("-pageMode")) {
                if (!args[++i].equals("u")) continue;
                pageMode = FakeHandler.Mode.UNIQUE;
                continue;
            }
            if (args[i].equals("-numHosts")) {
                numHosts = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-numPages")) {
                numPages = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-intLinks")) {
                intLinks = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-extLinks")) {
                extLinks = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-debug")) {
                debug = true;
                continue;
            }
            LOG.error("Unknown argument: " + args[i]);
            System.exit(-1);
        }
        Server server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setPort(port);
        connector.setResolveNames(false);
        server.addConnector((Connector)connector);
        HandlerList list = new HandlerList();
        server.addHandler((Handler)list);
        if (debug) {
            LOG.info("* Added debug handler.");
            list.addHandler((Handler)new LogDebugHandler());
        }
        if (delay) {
            LOG.info("* Added delay handler: " + (delayVal < 0 ? "random delay up to " + -delayVal : "constant delay of " + delayVal));
            list.addHandler((Handler)new DelayHandler(delayVal));
        }
        if (forward) {
            LOG.info("* Adding forwarding proxy for all unknown urls ...");
            ServletHandler servlets = new ServletHandler();
            servlets.addServletWithMapping(AsyncProxyServlet.class, "/*");
            servlets.addFilterWithMapping(LogDebugHandler.class, "/*", 15);
            list.addHandler((Handler)servlets);
        }
        if (fake) {
            LOG.info("* Added fake handler for remaining URLs.");
            list.addHandler((Handler)new FakeHandler(hostMode, pageMode, intLinks, extLinks, numHosts, numPages));
        }
        list.addHandler((Handler)new NotFoundHandler());
        server.start();
        server.join();
    }
}

