/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.InetAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.util.StringUtils;
import org.apache.nutch.util.URLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveUrls {
    public static final Logger LOG = LoggerFactory.getLogger(ResolveUrls.class);
    private String urlsFile = null;
    private int numThreads = 100;
    private ExecutorService pool = null;
    private static AtomicInteger numTotal = new AtomicInteger(0);
    private static AtomicInteger numErrored = new AtomicInteger(0);
    private static AtomicInteger numResolved = new AtomicInteger(0);
    private static AtomicLong totalTime = new AtomicLong(0L);

    public void resolveUrls() {
        try {
            this.pool = Executors.newFixedThreadPool(this.numThreads);
            BufferedReader buffRead = new BufferedReader(new FileReader(new File(this.urlsFile)));
            String urlStr = null;
            while ((urlStr = buffRead.readLine()) != null) {
                LOG.info("Starting: " + urlStr);
                this.pool.execute(new ResolverThread(urlStr));
            }
            buffRead.close();
            this.pool.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.pool.shutdownNow();
            LOG.info(StringUtils.stringifyException((Throwable)e));
        }
        this.pool.shutdown();
        LOG.info("Total: " + numTotal.get() + ", Resovled: " + numResolved.get() + ", Errored: " + numErrored.get() + ", Average Time: " + totalTime.get() / (long)numTotal.get());
    }

    public ResolveUrls(String urlsFile) {
        this(urlsFile, 100);
    }

    public ResolveUrls(String urlsFile, int numThreads) {
        this.urlsFile = urlsFile;
        this.numThreads = numThreads;
    }

    public static void main(String[] args) {
        Options options = new Options();
        OptionBuilder.withArgName((String)"help");
        OptionBuilder.withDescription((String)"show this help message");
        Option helpOpts = OptionBuilder.create((String)"help");
        OptionBuilder.withArgName((String)"urls");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"the urls file to check");
        Option urlOpts = OptionBuilder.create((String)"urls");
        OptionBuilder.withArgName((String)"numThreads");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)"the number of threads to use");
        Option numThreadOpts = OptionBuilder.create((String)"numThreads");
        options.addOption(helpOpts);
        options.addOption(urlOpts);
        options.addOption(numThreadOpts);
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help") || !line.hasOption("urls")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("ResolveUrls", options);
                return;
            }
            String urls = line.getOptionValue("urls");
            int numThreads = 100;
            String numThreadsStr = line.getOptionValue("numThreads");
            if (numThreadsStr != null) {
                numThreads = Integer.parseInt(numThreadsStr);
            }
            ResolveUrls resolve = new ResolveUrls(urls, numThreads);
            resolve.resolveUrls();
        }
        catch (Exception e) {
            LOG.error("ResolveUrls: " + StringUtils.stringifyException((Throwable)e));
        }
    }

    private static class ResolverThread
    extends Thread {
        private String url = null;

        public ResolverThread(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            numTotal.incrementAndGet();
            String host = URLUtil.getHost(this.url);
            long start = System.currentTimeMillis();
            try {
                InetAddress.getByName(host);
                LOG.info("Resolved: " + host);
                numResolved.incrementAndGet();
            }
            catch (Exception uhe) {
                LOG.info("Error Resolving: " + host);
                numErrored.incrementAndGet();
            }
            long end = System.currentTimeMillis();
            long total = end - start;
            totalTime.addAndGet(total);
            LOG.info(", " + total + " millis");
        }
    }
}

