/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.tools;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avro.util.Utf8;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.store.DataStore;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.MD5Hash;
import org.apache.nutch.storage.StorageUtils;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.TableUtil;
import org.apache.xerces.util.XMLChar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DmozParser {
    public static final Logger LOG = LoggerFactory.getLogger(DmozParser.class);
    long pages = 0L;
    private static DataStore<String, WebPage> store = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDmozFile(File dmozFile, int subsetDenom, boolean includeAdult, int skew, Pattern topicPattern, boolean snippet) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        RDFProcessor rp = new RDFProcessor(reader, subsetDenom, includeAdult, skew, topicPattern, snippet);
        reader.setContentHandler(rp);
        reader.setErrorHandler(rp);
        LOG.info("skew = " + rp.hashSkew);
        XMLCharFilter in = new XMLCharFilter(new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(dmozFile)), "UTF-8")));
        try {
            InputSource is = new InputSource(in);
            reader.parse(is);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Failed to retieve the InputSource: ", (Object)e.toString());
            }
            System.exit(0);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addTopicsFromFile(String topicFile, Vector<String> topics) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(topicFile), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                topics.addElement(new String(line));
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Failed with the following exception: ", (Object)e.toString());
            }
            System.exit(0);
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) throws Exception {
        if (argv.length < 1) {
            System.err.println("Usage: DmozParser <dmoz_file> [-subset <subsetDenominator>] [-includeAdultMaterial] [-skew skew] [-snippet] [-topicFile <topic list file>] [-topic <topic> [-topic <topic> [...]]]");
            return;
        }
        int subsetDenom = 1;
        int skew = 0;
        String dmozFile = argv[0];
        boolean includeAdult = false;
        boolean snippet = false;
        Pattern topicPattern = null;
        Vector<String> topics = new Vector<String>();
        Configuration conf = NutchConfiguration.create();
        store = StorageUtils.createWebStore(conf, String.class, WebPage.class);
        FileSystem fs = FileSystem.get((Configuration)conf);
        try {
            for (int i = 1; i < argv.length; ++i) {
                if ("-includeAdultMaterial".equals(argv[i])) {
                    includeAdult = true;
                    continue;
                }
                if ("-subset".equals(argv[i])) {
                    subsetDenom = Integer.parseInt(argv[i + 1]);
                    ++i;
                    continue;
                }
                if ("-topic".equals(argv[i])) {
                    topics.addElement(argv[i + 1]);
                    ++i;
                    continue;
                }
                if ("-topicFile".equals(argv[i])) {
                    DmozParser.addTopicsFromFile(argv[i + 1], topics);
                    ++i;
                    continue;
                }
                if ("-skew".equals(argv[i])) {
                    skew = Integer.parseInt(argv[i + 1]);
                    ++i;
                    continue;
                }
                if (!"-snippet".equals(argv[i])) continue;
                snippet = true;
            }
            DmozParser parser = new DmozParser();
            if (!topics.isEmpty()) {
                int j;
                String regExp = new String("^(");
                for (j = 0; j < topics.size() - 1; ++j) {
                    regExp = regExp.concat((String)topics.get(j));
                    regExp = regExp.concat("|");
                }
                regExp = regExp.concat((String)topics.get(j));
                regExp = regExp.concat(").*");
                LOG.info("Topic selection pattern = " + regExp);
                topicPattern = Pattern.compile(regExp);
            }
            parser.parseDmozFile(new File(dmozFile), subsetDenom, includeAdult, skew, topicPattern, snippet);
        }
        finally {
            fs.close();
        }
    }

    private class RDFProcessor
    extends DefaultHandler {
        String curURL = null;
        String curSection = null;
        boolean titlePending = false;
        boolean descPending = false;
        boolean insideAdultSection = false;
        Pattern topicPattern = null;
        StringBuffer title = new StringBuffer();
        StringBuffer desc = new StringBuffer();
        XMLReader reader;
        int subsetDenom;
        int hashSkew;
        boolean includeAdult;
        boolean snippet;
        Locator location;

        public RDFProcessor(XMLReader reader, int subsetDenom, boolean includeAdult, int skew, Pattern topicPattern, boolean snippet) throws IOException {
            this.reader = reader;
            this.subsetDenom = subsetDenom;
            this.includeAdult = includeAdult;
            this.topicPattern = topicPattern;
            this.snippet = snippet;
            this.hashSkew = skew != 0 ? skew : new Random().nextInt();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if ("Topic".equals(qName)) {
                this.curSection = atts.getValue("r:id");
            } else if ("ExternalPage".equals(qName)) {
                if (!this.includeAdult && this.curSection.startsWith("Top/Adult")) {
                    return;
                }
                if (this.topicPattern != null && !this.topicPattern.matcher(this.curSection).matches()) {
                    return;
                }
                String url = atts.getValue("about");
                int hashValue = MD5Hash.digest((String)url).hashCode();
                if ((hashValue = Math.abs(hashValue ^ this.hashSkew)) % this.subsetDenom != 0) {
                    return;
                }
                this.curURL = url;
            } else if (this.curURL != null && "d:Title".equals(qName)) {
                this.titlePending = true;
            } else if (this.curURL != null && "d:Description".equals(qName)) {
                this.descPending = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.titlePending) {
                this.title.append(ch, start, length);
            } else if (this.descPending) {
                this.desc.append(ch, start, length);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this.curURL != null) {
                if ("ExternalPage".equals(qName)) {
                    if (this.snippet) {
                        try {
                            String reversedUrl = TableUtil.reverseUrl(this.curURL);
                            WebPage row = (WebPage)store.get((Object)reversedUrl);
                            if (row != null) {
                                if (this.desc.length() > 0) {
                                    row.getMetadata().put((CharSequence)new Utf8("_dmoz_desc_"), ByteBuffer.wrap(this.desc.toString().getBytes()));
                                    this.desc.delete(0, this.desc.length());
                                }
                                if (this.title.length() > 0) {
                                    row.getMetadata().put((CharSequence)new Utf8("_dmoz_title_"), ByteBuffer.wrap(this.title.toString().getBytes()));
                                    this.title.delete(0, this.title.length());
                                }
                                store.put((Object)reversedUrl, (Persistent)row);
                                store.flush();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        System.out.println(this.curURL);
                        if (this.desc.length() > 0) {
                            this.desc.delete(0, this.desc.length());
                        }
                        if (this.title.length() > 0) {
                            this.title.delete(0, this.title.length());
                        }
                    }
                    ++DmozParser.this.pages;
                    this.curURL = null;
                } else if ("d:Title".equals(qName)) {
                    this.titlePending = false;
                } else if ("d:Description".equals(qName)) {
                    this.descPending = false;
                }
            }
        }

        @Override
        public void startDocument() {
            LOG.info("Begin parse");
        }

        @Override
        public void endDocument() {
            LOG.info("Completed parse.  Found " + DmozParser.this.pages + " pages.");
            store.close();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.location = locator;
        }

        @Override
        public void error(SAXParseException spe) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Error: " + spe.toString() + ": " + spe.getMessage());
            }
        }

        @Override
        public void fatalError(SAXParseException spe) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Fatal err: " + spe.toString() + ": " + spe.getMessage());
                LOG.error("Last known line is " + this.location.getLineNumber() + ", column " + this.location.getColumnNumber());
            }
        }

        @Override
        public void warning(SAXParseException spe) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Warning: " + spe.toString() + ": " + spe.getMessage());
            }
        }
    }

    private static class XMLCharFilter
    extends FilterReader {
        private boolean lastBad = false;

        public XMLCharFilter(Reader reader) {
            super(reader);
        }

        @Override
        public int read() throws IOException {
            int c;
            int value = c = this.in.read();
            if (c != -1 && !XMLChar.isValid((int)c)) {
                value = 88;
            } else if (this.lastBad && c == 60) {
                this.in.mark(1);
                if (this.in.read() != 47) {
                    value = 88;
                }
                this.in.reset();
            }
            this.lastBad = c == 65533;
            return value;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int n = this.in.read(cbuf, off, len);
            if (n != -1) {
                for (int i = 0; i < n; ++i) {
                    int c;
                    int value = c = cbuf[off + i];
                    if (!XMLChar.isValid((int)c)) {
                        value = 88;
                    } else if (this.lastBad && c == 60 && i != n - 1 && cbuf[off + i + 1] != '/') {
                        value = 88;
                    }
                    this.lastBad = c == 65533;
                    cbuf[off + i] = value;
                }
            }
            return n;
        }
    }
}

