/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.storage;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.gora.persistency.Dirtyable;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.DirtyMapWrapper;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.nutch.storage.ParseStatus;
import org.apache.nutch.storage.ProtocolStatus;

public class WebPage
extends PersistentBase
implements SpecificRecord,
Persistent {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"WebPage\",\"namespace\":\"org.apache.nutch.storage\",\"doc\":\"WebPage is the primary data structure in Nutch representing crawl data for a given WebPage at some point in time\",\"fields\":[{\"name\":\"baseUrl\",\"type\":[\"null\",\"string\"],\"doc\":\"The original associated with this WebPage.\",\"default\":null},{\"name\":\"status\",\"type\":\"int\",\"doc\":\"A crawl status associated with the WebPage, can be of value STATUS_UNFETCHED - WebPage was not fetched yet, STATUS_FETCHED - WebPage was successfully fetched, STATUS_GONE - WebPage no longer exists, STATUS_REDIR_TEMP - WebPage temporarily redirects to other page, STATUS_REDIR_PERM - WebPage permanently redirects to other page, STATUS_RETRY - Fetching unsuccessful, needs to be retried e.g. transient errors and STATUS_NOTMODIFIED - fetching successful - page is not modified\",\"default\":0},{\"name\":\"fetchTime\",\"type\":\"long\",\"doc\":\"The system time in milliseconds for when the page was fetched.\",\"default\":0},{\"name\":\"prevFetchTime\",\"type\":\"long\",\"doc\":\"The system time in milliseconds for when the page was last fetched if it was previously fetched which can be used to calculate time delta within a fetching schedule implementation\",\"default\":0},{\"name\":\"fetchInterval\",\"type\":\"int\",\"doc\":\"The default number of seconds between re-fetches of a page. The default is considered as 30 days unless a custom fetch schedle is implemented.\",\"default\":0},{\"name\":\"retriesSinceFetch\",\"type\":\"int\",\"doc\":\"The number of retried attempts at fetching the WebPage since it was last successfully fetched.\",\"default\":0},{\"name\":\"modifiedTime\",\"type\":\"long\",\"doc\":\"The system time in milliseconds for when this WebPage was modified by the WebPage author, if this is not available we default to the server for this information. This is important to understand the changing nature of the WebPage.\",\"default\":0},{\"name\":\"prevModifiedTime\",\"type\":\"long\",\"doc\":\"The system time in milliseconds for when this WebPage was previously modified by the author, if this is not available then we default to the server for this information. This is important to understand the changing nature of a WebPage.\",\"default\":0},{\"name\":\"protocolStatus\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"ProtocolStatus\",\"doc\":\"A nested container representing data captured from web server responses.\",\"fields\":[{\"name\":\"code\",\"type\":\"int\",\"doc\":\"A protocol response code which can be one of SUCCESS - content was retrieved without errors, FAILED - Content was not retrieved. Any further errors may be indicated in args, PROTO_NOT_FOUND - This protocol was not found. Application may attempt to retry later, GONE - Resource is gone, MOVED - Resource has moved permanently. New url should be found in args, TEMP_MOVED - Resource has moved temporarily. New url should be found in args., NOTFOUND - Resource was not found, RETRY - Temporary failure. Application may retry immediately., EXCEPTION - Unspecified exception occured. Further information may be provided in args., ACCESS_DENIED - Access denied - authorization required, but missing/incorrect., ROBOTS_DENIED - Access denied by robots.txt rules., REDIR_EXCEEDED - Too many redirects., NOTFETCHING - Not fetching., NOTMODIFIED - Unchanged since the last fetch., WOULDBLOCK - Request was refused by protocol plugins, because it would block. The expected number of milliseconds to wait before retry may be provided in args., BLOCKED - Thread was blocked http.max.delays times during fetching.\",\"default\":0},{\"name\":\"args\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"Optional arguments supplied to compliment and/or justify the response code.\",\"default\":[]},{\"name\":\"lastModified\",\"type\":\"long\",\"doc\":\"A server reponse indicating when this page was last modified, this can be unreliable at times hence this is used as a default fall back value for the preferred 'modifiedTime' and 'preModifiedTime' obtained from the WebPage itself.\",\"default\":0}]}],\"default\":null},{\"name\":\"content\",\"type\":[\"null\",\"bytes\"],\"doc\":\"The entire raw document content e.g. raw XHTML\",\"default\":null},{\"name\":\"contentType\",\"type\":[\"null\",\"string\"],\"doc\":\"The type of the content contained within the document itself. ContentType is an alias for MimeType. Historically, this parameter was only called MimeType, but since this is actually the value included in the HTTP Content-Type header, it can also include the character set encoding, which makes it more than just a MimeType specification. If MimeType is specified e.g. not None, that value is used. Otherwise, ContentType is used. If neither is given, the DEFAULT_CONTENT_TYPE setting is used.\",\"default\":null},{\"name\":\"prevSignature\",\"type\":[\"null\",\"bytes\"],\"doc\":\"An implementation of a WebPage's previous signature from which it can be identified and referenced at any point in time. This can be used to uniquely identify WebPage deltas based on page fingerprints.\",\"default\":null},{\"name\":\"signature\",\"type\":[\"null\",\"bytes\"],\"doc\":\"An implementation of a WebPage's signature from which it can be identified and referenced at any point in time. This is essentially the WebPage's fingerprint represnting its state for any point in time.\",\"default\":null},{\"name\":\"title\",\"type\":[\"null\",\"string\"],\"doc\":\"The title of the WebPage.\",\"default\":null},{\"name\":\"text\",\"type\":[\"null\",\"string\"],\"doc\":\"The textual content of the WebPage devoid from native markup.\",\"default\":null},{\"name\":\"parseStatus\",\"type\":[\"null\",{\"type\":\"record\",\"name\":\"ParseStatus\",\"doc\":\"A nested container representing parse status data captured from invocation of parsers on fetch of a WebPage\",\"fields\":[{\"name\":\"majorCode\",\"type\":\"int\",\"doc\":\"Major parsing status' including NOTPARSED (Parsing was not performed), SUCCESS (Parsing succeeded), FAILED (General failure. There may be a more specific error message in arguments.)\",\"default\":0},{\"name\":\"minorCode\",\"type\":\"int\",\"doc\":\"Minor parsing status' including SUCCESS_OK - Successful parse devoid of anomalies or issues, SUCCESS_REDIRECT - Parsed content contains a directive to redirect to another URL. The target URL can be retrieved from the arguments., FAILED_EXCEPTION - Parsing failed. An Exception occured which may be retrieved from the arguments., FAILED_TRUNCATED - Parsing failed. Content was truncated, but the parser cannot handle incomplete content., FAILED_INVALID_FORMAT - Parsing failed. Invalid format e.g. the content may be corrupted or of wrong type., FAILED_MISSING_PARTS - Parsing failed. Other related parts of the content are needed to complete parsing. The list of URLs to missing parts may be provided in arguments. The Fetcher may decide to fetch these parts at once, then put them into Content.metadata, and supply them for re-parsing., FAILED_MISING_CONTENT - Parsing failed. There was no content to be parsed - probably caused by errors at protocol stage.\",\"default\":0},{\"name\":\"args\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"Optional arguments supplied to compliment and/or justify the parse status code.\",\"default\":[]}]}],\"default\":null},{\"name\":\"score\",\"type\":\"float\",\"doc\":\"A score used to determine a WebPage's relevance within the web graph it is part of. This score may change over time based on graph characteristics.\",\"default\":0},{\"name\":\"reprUrl\",\"type\":[\"null\",\"string\"],\"doc\":\"In the case where we are given two urls, a source and a destination of a redirect, we should determine and persist the representative url. The logic used to determine this is based largely on Yahoo!'s Slurp Crawler\",\"default\":null},{\"name\":\"headers\",\"type\":{\"type\":\"map\",\"values\":[\"null\",\"string\"]},\"doc\":\"Header information returned from the web server used to server the content which is subsequently fetched from. This includes keys such as TRANSFER_ENCODING, CONTENT_ENCODING, CONTENT_LANGUAGE, CONTENT_LENGTH, CONTENT_LOCATION, CONTENT_DISPOSITION, CONTENT_MD5, CONTENT_TYPE, LAST_MODIFIED and LOCATION.\",\"default\":{}},{\"name\":\"outlinks\",\"type\":{\"type\":\"map\",\"values\":[\"null\",\"string\"]},\"doc\":\"Embedded hyperlinks which direct outside of the current domain.\",\"default\":{}},{\"name\":\"inlinks\",\"type\":{\"type\":\"map\",\"values\":[\"null\",\"string\"]},\"doc\":\"Embedded hyperlinks which link to pages within the current domain.\",\"default\":{}},{\"name\":\"markers\",\"type\":{\"type\":\"map\",\"values\":[\"null\",\"string\"]},\"doc\":\"Markers flags which represent user and machine decisions which have affected influenced a WebPage's current state. Markers can be system specific and user machine driven in nature. They are assigned to a WebPage on a job-by-job basis and thier values indicative of what actions should be associated with a WebPage.\",\"default\":{}},{\"name\":\"metadata\",\"type\":{\"type\":\"map\",\"values\":[\"null\",\"bytes\"]},\"doc\":\"A multi-valued metadata container used for storing everything from structured WebPage characterists, to ad-hoc extraction and metadata augmentation for any given WebPage.\",\"default\":{}},{\"name\":\"batchId\",\"type\":[\"null\",\"string\"],\"doc\":\"A batchId that this WebPage is assigned to. WebPage's are fetched in batches, called fetchlists. Pages are partitioned but can always be associated and fetched alongside pages of similar value (within a crawl cycle) based on batchId.\",\"default\":null}]}");
    public static final String[] _ALL_FIELDS = new String[]{"baseUrl", "status", "fetchTime", "prevFetchTime", "fetchInterval", "retriesSinceFetch", "modifiedTime", "prevModifiedTime", "protocolStatus", "content", "contentType", "prevSignature", "signature", "title", "text", "parseStatus", "score", "reprUrl", "headers", "outlinks", "inlinks", "markers", "metadata", "batchId"};
    private CharSequence baseUrl;
    private int status;
    private long fetchTime;
    private long prevFetchTime;
    private int fetchInterval;
    private int retriesSinceFetch;
    private long modifiedTime;
    private long prevModifiedTime;
    private ProtocolStatus protocolStatus;
    private ByteBuffer content;
    private CharSequence contentType;
    private ByteBuffer prevSignature;
    private ByteBuffer signature;
    private CharSequence title;
    private CharSequence text;
    private ParseStatus parseStatus;
    private float score;
    private CharSequence reprUrl;
    private Map<CharSequence, CharSequence> headers;
    private Map<CharSequence, CharSequence> outlinks;
    private Map<CharSequence, CharSequence> inlinks;
    private Map<CharSequence, CharSequence> markers;
    private Map<CharSequence, ByteBuffer> metadata;
    private CharSequence batchId;
    private static final Tombstone TOMBSTONE = new Tombstone();

    public int getFieldsCount() {
        return _ALL_FIELDS.length;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.baseUrl;
            }
            case 1: {
                return this.status;
            }
            case 2: {
                return this.fetchTime;
            }
            case 3: {
                return this.prevFetchTime;
            }
            case 4: {
                return this.fetchInterval;
            }
            case 5: {
                return this.retriesSinceFetch;
            }
            case 6: {
                return this.modifiedTime;
            }
            case 7: {
                return this.prevModifiedTime;
            }
            case 8: {
                return this.protocolStatus;
            }
            case 9: {
                return this.content;
            }
            case 10: {
                return this.contentType;
            }
            case 11: {
                return this.prevSignature;
            }
            case 12: {
                return this.signature;
            }
            case 13: {
                return this.title;
            }
            case 14: {
                return this.text;
            }
            case 15: {
                return this.parseStatus;
            }
            case 16: {
                return Float.valueOf(this.score);
            }
            case 17: {
                return this.reprUrl;
            }
            case 18: {
                return this.headers;
            }
            case 19: {
                return this.outlinks;
            }
            case 20: {
                return this.inlinks;
            }
            case 21: {
                return this.markers;
            }
            case 22: {
                return this.metadata;
            }
            case 23: {
                return this.batchId;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value) {
        switch (field$) {
            case 0: {
                this.baseUrl = (CharSequence)value;
                break;
            }
            case 1: {
                this.status = (Integer)value;
                break;
            }
            case 2: {
                this.fetchTime = (Long)value;
                break;
            }
            case 3: {
                this.prevFetchTime = (Long)value;
                break;
            }
            case 4: {
                this.fetchInterval = (Integer)value;
                break;
            }
            case 5: {
                this.retriesSinceFetch = (Integer)value;
                break;
            }
            case 6: {
                this.modifiedTime = (Long)value;
                break;
            }
            case 7: {
                this.prevModifiedTime = (Long)value;
                break;
            }
            case 8: {
                this.protocolStatus = (ProtocolStatus)((Object)value);
                break;
            }
            case 9: {
                this.content = (ByteBuffer)value;
                break;
            }
            case 10: {
                this.contentType = (CharSequence)value;
                break;
            }
            case 11: {
                this.prevSignature = (ByteBuffer)value;
                break;
            }
            case 12: {
                this.signature = (ByteBuffer)value;
                break;
            }
            case 13: {
                this.title = (CharSequence)value;
                break;
            }
            case 14: {
                this.text = (CharSequence)value;
                break;
            }
            case 15: {
                this.parseStatus = (ParseStatus)((Object)value);
                break;
            }
            case 16: {
                this.score = ((Float)value).floatValue();
                break;
            }
            case 17: {
                this.reprUrl = (CharSequence)value;
                break;
            }
            case 18: {
                this.headers = (Map)(value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value));
                break;
            }
            case 19: {
                this.outlinks = (Map)(value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value));
                break;
            }
            case 20: {
                this.inlinks = (Map)(value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value));
                break;
            }
            case 21: {
                this.markers = (Map)(value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value));
                break;
            }
            case 22: {
                this.metadata = (Map)(value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value));
                break;
            }
            case 23: {
                this.batchId = (CharSequence)value;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public CharSequence getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(CharSequence value) {
        this.baseUrl = value;
        this.setDirty(0);
    }

    public boolean isBaseUrlDirty(CharSequence value) {
        return this.isDirty(0);
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer value) {
        this.status = value;
        this.setDirty(1);
    }

    public boolean isStatusDirty(Integer value) {
        return this.isDirty(1);
    }

    public Long getFetchTime() {
        return this.fetchTime;
    }

    public void setFetchTime(Long value) {
        this.fetchTime = value;
        this.setDirty(2);
    }

    public boolean isFetchTimeDirty(Long value) {
        return this.isDirty(2);
    }

    public Long getPrevFetchTime() {
        return this.prevFetchTime;
    }

    public void setPrevFetchTime(Long value) {
        this.prevFetchTime = value;
        this.setDirty(3);
    }

    public boolean isPrevFetchTimeDirty(Long value) {
        return this.isDirty(3);
    }

    public Integer getFetchInterval() {
        return this.fetchInterval;
    }

    public void setFetchInterval(Integer value) {
        this.fetchInterval = value;
        this.setDirty(4);
    }

    public boolean isFetchIntervalDirty(Integer value) {
        return this.isDirty(4);
    }

    public Integer getRetriesSinceFetch() {
        return this.retriesSinceFetch;
    }

    public void setRetriesSinceFetch(Integer value) {
        this.retriesSinceFetch = value;
        this.setDirty(5);
    }

    public boolean isRetriesSinceFetchDirty(Integer value) {
        return this.isDirty(5);
    }

    public Long getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Long value) {
        this.modifiedTime = value;
        this.setDirty(6);
    }

    public boolean isModifiedTimeDirty(Long value) {
        return this.isDirty(6);
    }

    public Long getPrevModifiedTime() {
        return this.prevModifiedTime;
    }

    public void setPrevModifiedTime(Long value) {
        this.prevModifiedTime = value;
        this.setDirty(7);
    }

    public boolean isPrevModifiedTimeDirty(Long value) {
        return this.isDirty(7);
    }

    public ProtocolStatus getProtocolStatus() {
        return this.protocolStatus;
    }

    public void setProtocolStatus(ProtocolStatus value) {
        this.protocolStatus = value;
        this.setDirty(8);
    }

    public boolean isProtocolStatusDirty(ProtocolStatus value) {
        return this.isDirty(8);
    }

    public ByteBuffer getContent() {
        return this.content;
    }

    public void setContent(ByteBuffer value) {
        this.content = value;
        this.setDirty(9);
    }

    public boolean isContentDirty(ByteBuffer value) {
        return this.isDirty(9);
    }

    public CharSequence getContentType() {
        return this.contentType;
    }

    public void setContentType(CharSequence value) {
        this.contentType = value;
        this.setDirty(10);
    }

    public boolean isContentTypeDirty(CharSequence value) {
        return this.isDirty(10);
    }

    public ByteBuffer getPrevSignature() {
        return this.prevSignature;
    }

    public void setPrevSignature(ByteBuffer value) {
        this.prevSignature = value;
        this.setDirty(11);
    }

    public boolean isPrevSignatureDirty(ByteBuffer value) {
        return this.isDirty(11);
    }

    public ByteBuffer getSignature() {
        return this.signature;
    }

    public void setSignature(ByteBuffer value) {
        this.signature = value;
        this.setDirty(12);
    }

    public boolean isSignatureDirty(ByteBuffer value) {
        return this.isDirty(12);
    }

    public CharSequence getTitle() {
        return this.title;
    }

    public void setTitle(CharSequence value) {
        this.title = value;
        this.setDirty(13);
    }

    public boolean isTitleDirty(CharSequence value) {
        return this.isDirty(13);
    }

    public CharSequence getText() {
        return this.text;
    }

    public void setText(CharSequence value) {
        this.text = value;
        this.setDirty(14);
    }

    public boolean isTextDirty(CharSequence value) {
        return this.isDirty(14);
    }

    public ParseStatus getParseStatus() {
        return this.parseStatus;
    }

    public void setParseStatus(ParseStatus value) {
        this.parseStatus = value;
        this.setDirty(15);
    }

    public boolean isParseStatusDirty(ParseStatus value) {
        return this.isDirty(15);
    }

    public Float getScore() {
        return Float.valueOf(this.score);
    }

    public void setScore(Float value) {
        this.score = value.floatValue();
        this.setDirty(16);
    }

    public boolean isScoreDirty(Float value) {
        return this.isDirty(16);
    }

    public CharSequence getReprUrl() {
        return this.reprUrl;
    }

    public void setReprUrl(CharSequence value) {
        this.reprUrl = value;
        this.setDirty(17);
    }

    public boolean isReprUrlDirty(CharSequence value) {
        return this.isDirty(17);
    }

    public Map<CharSequence, CharSequence> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<CharSequence, CharSequence> value) {
        this.headers = value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value);
        this.setDirty(18);
    }

    public boolean isHeadersDirty(Map<CharSequence, CharSequence> value) {
        return this.isDirty(18);
    }

    public Map<CharSequence, CharSequence> getOutlinks() {
        return this.outlinks;
    }

    public void setOutlinks(Map<CharSequence, CharSequence> value) {
        this.outlinks = value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value);
        this.setDirty(19);
    }

    public boolean isOutlinksDirty(Map<CharSequence, CharSequence> value) {
        return this.isDirty(19);
    }

    public Map<CharSequence, CharSequence> getInlinks() {
        return this.inlinks;
    }

    public void setInlinks(Map<CharSequence, CharSequence> value) {
        this.inlinks = value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value);
        this.setDirty(20);
    }

    public boolean isInlinksDirty(Map<CharSequence, CharSequence> value) {
        return this.isDirty(20);
    }

    public Map<CharSequence, CharSequence> getMarkers() {
        return this.markers;
    }

    public void setMarkers(Map<CharSequence, CharSequence> value) {
        this.markers = value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value);
        this.setDirty(21);
    }

    public boolean isMarkersDirty(Map<CharSequence, CharSequence> value) {
        return this.isDirty(21);
    }

    public Map<CharSequence, ByteBuffer> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<CharSequence, ByteBuffer> value) {
        this.metadata = value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value);
        this.setDirty(22);
    }

    public boolean isMetadataDirty(Map<CharSequence, ByteBuffer> value) {
        return this.isDirty(22);
    }

    public CharSequence getBatchId() {
        return this.batchId;
    }

    public void setBatchId(CharSequence value) {
        this.batchId = value;
        this.setDirty(23);
    }

    public boolean isBatchIdDirty(CharSequence value) {
        return this.isDirty(23);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(WebPage other) {
        return new Builder(other);
    }

    private static ByteBuffer deepCopyToReadOnlyBuffer(ByteBuffer input) {
        ByteBuffer copy = ByteBuffer.allocate(input.capacity());
        int position = input.position();
        input.reset();
        int mark = input.position();
        int limit = input.limit();
        input.rewind();
        input.limit(input.capacity());
        copy.put(input);
        input.rewind();
        copy.rewind();
        input.position(mark);
        input.mark();
        copy.position(mark);
        copy.mark();
        input.position(position);
        copy.position(position);
        input.limit(limit);
        copy.limit(limit);
        return copy.asReadOnlyBuffer();
    }

    public Tombstone getTombstone() {
        return TOMBSTONE;
    }

    public WebPage newInstance() {
        return WebPage.newBuilder().build();
    }

    public static final class Tombstone
    extends WebPage
    implements org.apache.gora.persistency.Tombstone {
        private Tombstone() {
        }

        @Override
        public CharSequence getBaseUrl() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setBaseUrl(CharSequence value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isBaseUrlDirty(CharSequence value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Integer getStatus() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setStatus(Integer value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isStatusDirty(Integer value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Long getFetchTime() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setFetchTime(Long value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isFetchTimeDirty(Long value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Long getPrevFetchTime() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setPrevFetchTime(Long value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isPrevFetchTimeDirty(Long value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Integer getFetchInterval() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setFetchInterval(Integer value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isFetchIntervalDirty(Integer value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Integer getRetriesSinceFetch() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setRetriesSinceFetch(Integer value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isRetriesSinceFetchDirty(Integer value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Long getModifiedTime() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setModifiedTime(Long value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isModifiedTimeDirty(Long value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Long getPrevModifiedTime() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setPrevModifiedTime(Long value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isPrevModifiedTimeDirty(Long value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public ProtocolStatus getProtocolStatus() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setProtocolStatus(ProtocolStatus value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isProtocolStatusDirty(ProtocolStatus value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public ByteBuffer getContent() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setContent(ByteBuffer value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isContentDirty(ByteBuffer value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public CharSequence getContentType() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setContentType(CharSequence value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isContentTypeDirty(CharSequence value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public ByteBuffer getPrevSignature() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setPrevSignature(ByteBuffer value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isPrevSignatureDirty(ByteBuffer value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public ByteBuffer getSignature() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setSignature(ByteBuffer value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isSignatureDirty(ByteBuffer value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public CharSequence getTitle() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setTitle(CharSequence value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isTitleDirty(CharSequence value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public CharSequence getText() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setText(CharSequence value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isTextDirty(CharSequence value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public ParseStatus getParseStatus() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setParseStatus(ParseStatus value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isParseStatusDirty(ParseStatus value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Float getScore() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setScore(Float value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isScoreDirty(Float value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public CharSequence getReprUrl() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setReprUrl(CharSequence value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isReprUrlDirty(CharSequence value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Map<CharSequence, CharSequence> getHeaders() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setHeaders(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isHeadersDirty(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Map<CharSequence, CharSequence> getOutlinks() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setOutlinks(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isOutlinksDirty(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Map<CharSequence, CharSequence> getInlinks() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setInlinks(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isInlinksDirty(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Map<CharSequence, CharSequence> getMarkers() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setMarkers(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isMarkersDirty(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Map<CharSequence, ByteBuffer> getMetadata() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setMetadata(Map<CharSequence, ByteBuffer> value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isMetadataDirty(Map<CharSequence, ByteBuffer> value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public CharSequence getBatchId() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setBatchId(CharSequence value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isBatchIdDirty(CharSequence value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }
    }

    public static class Builder
    extends SpecificRecordBuilderBase<WebPage>
    implements RecordBuilder<WebPage> {
        private CharSequence baseUrl;
        private int status;
        private long fetchTime;
        private long prevFetchTime;
        private int fetchInterval;
        private int retriesSinceFetch;
        private long modifiedTime;
        private long prevModifiedTime;
        private ProtocolStatus protocolStatus;
        private ByteBuffer content;
        private CharSequence contentType;
        private ByteBuffer prevSignature;
        private ByteBuffer signature;
        private CharSequence title;
        private CharSequence text;
        private ParseStatus parseStatus;
        private float score;
        private CharSequence reprUrl;
        private Map<CharSequence, CharSequence> headers;
        private Map<CharSequence, CharSequence> outlinks;
        private Map<CharSequence, CharSequence> inlinks;
        private Map<CharSequence, CharSequence> markers;
        private Map<CharSequence, ByteBuffer> metadata;
        private CharSequence batchId;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(WebPage other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.baseUrl)) {
                this.baseUrl = (CharSequence)this.data().deepCopy(this.fields()[0].schema(), (Object)other.baseUrl);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.status)) {
                this.status = (Integer)this.data().deepCopy(this.fields()[1].schema(), (Object)other.status);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.fetchTime)) {
                this.fetchTime = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.fetchTime);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[3], (Object)other.prevFetchTime)) {
                this.prevFetchTime = (Long)this.data().deepCopy(this.fields()[3].schema(), (Object)other.prevFetchTime);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[4], (Object)other.fetchInterval)) {
                this.fetchInterval = (Integer)this.data().deepCopy(this.fields()[4].schema(), (Object)other.fetchInterval);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[5], (Object)other.retriesSinceFetch)) {
                this.retriesSinceFetch = (Integer)this.data().deepCopy(this.fields()[5].schema(), (Object)other.retriesSinceFetch);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[6], (Object)other.modifiedTime)) {
                this.modifiedTime = (Long)this.data().deepCopy(this.fields()[6].schema(), (Object)other.modifiedTime);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[7], (Object)other.prevModifiedTime)) {
                this.prevModifiedTime = (Long)this.data().deepCopy(this.fields()[7].schema(), (Object)other.prevModifiedTime);
                this.fieldSetFlags()[7] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[8], (Object)((Object)other.protocolStatus))) {
                this.protocolStatus = (ProtocolStatus)((Object)this.data().deepCopy(this.fields()[8].schema(), (Object)other.protocolStatus));
                this.fieldSetFlags()[8] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[9], (Object)other.content)) {
                this.content = (ByteBuffer)this.data().deepCopy(this.fields()[9].schema(), (Object)other.content);
                this.fieldSetFlags()[9] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[10], (Object)other.contentType)) {
                this.contentType = (CharSequence)this.data().deepCopy(this.fields()[10].schema(), (Object)other.contentType);
                this.fieldSetFlags()[10] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[11], (Object)other.prevSignature)) {
                this.prevSignature = (ByteBuffer)this.data().deepCopy(this.fields()[11].schema(), (Object)other.prevSignature);
                this.fieldSetFlags()[11] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[12], (Object)other.signature)) {
                this.signature = (ByteBuffer)this.data().deepCopy(this.fields()[12].schema(), (Object)other.signature);
                this.fieldSetFlags()[12] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[13], (Object)other.title)) {
                this.title = (CharSequence)this.data().deepCopy(this.fields()[13].schema(), (Object)other.title);
                this.fieldSetFlags()[13] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[14], (Object)other.text)) {
                this.text = (CharSequence)this.data().deepCopy(this.fields()[14].schema(), (Object)other.text);
                this.fieldSetFlags()[14] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[15], (Object)((Object)other.parseStatus))) {
                this.parseStatus = (ParseStatus)((Object)this.data().deepCopy(this.fields()[15].schema(), (Object)other.parseStatus));
                this.fieldSetFlags()[15] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[16], (Object)Float.valueOf(other.score))) {
                this.score = ((Float)this.data().deepCopy(this.fields()[16].schema(), (Object)Float.valueOf(other.score))).floatValue();
                this.fieldSetFlags()[16] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[17], (Object)other.reprUrl)) {
                this.reprUrl = (CharSequence)this.data().deepCopy(this.fields()[17].schema(), (Object)other.reprUrl);
                this.fieldSetFlags()[17] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[18], (Object)other.headers)) {
                this.headers = (Map)this.data().deepCopy(this.fields()[18].schema(), (Object)other.headers);
                this.fieldSetFlags()[18] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[19], (Object)other.outlinks)) {
                this.outlinks = (Map)this.data().deepCopy(this.fields()[19].schema(), (Object)other.outlinks);
                this.fieldSetFlags()[19] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[20], (Object)other.inlinks)) {
                this.inlinks = (Map)this.data().deepCopy(this.fields()[20].schema(), (Object)other.inlinks);
                this.fieldSetFlags()[20] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[21], (Object)other.markers)) {
                this.markers = (Map)this.data().deepCopy(this.fields()[21].schema(), (Object)other.markers);
                this.fieldSetFlags()[21] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[22], (Object)other.metadata)) {
                this.metadata = (Map)this.data().deepCopy(this.fields()[22].schema(), (Object)other.metadata);
                this.fieldSetFlags()[22] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[23], (Object)other.batchId)) {
                this.batchId = (CharSequence)this.data().deepCopy(this.fields()[23].schema(), (Object)other.batchId);
                this.fieldSetFlags()[23] = true;
            }
        }

        public CharSequence getBaseUrl() {
            return this.baseUrl;
        }

        public Builder setBaseUrl(CharSequence value) {
            this.validate(this.fields()[0], value);
            this.baseUrl = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasBaseUrl() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearBaseUrl() {
            this.baseUrl = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Integer getStatus() {
            return this.status;
        }

        public Builder setStatus(int value) {
            this.validate(this.fields()[1], value);
            this.status = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasStatus() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearStatus() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getFetchTime() {
            return this.fetchTime;
        }

        public Builder setFetchTime(long value) {
            this.validate(this.fields()[2], value);
            this.fetchTime = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasFetchTime() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearFetchTime() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Long getPrevFetchTime() {
            return this.prevFetchTime;
        }

        public Builder setPrevFetchTime(long value) {
            this.validate(this.fields()[3], value);
            this.prevFetchTime = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasPrevFetchTime() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearPrevFetchTime() {
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public Integer getFetchInterval() {
            return this.fetchInterval;
        }

        public Builder setFetchInterval(int value) {
            this.validate(this.fields()[4], value);
            this.fetchInterval = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasFetchInterval() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearFetchInterval() {
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Integer getRetriesSinceFetch() {
            return this.retriesSinceFetch;
        }

        public Builder setRetriesSinceFetch(int value) {
            this.validate(this.fields()[5], value);
            this.retriesSinceFetch = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasRetriesSinceFetch() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearRetriesSinceFetch() {
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public Long getModifiedTime() {
            return this.modifiedTime;
        }

        public Builder setModifiedTime(long value) {
            this.validate(this.fields()[6], value);
            this.modifiedTime = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasModifiedTime() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearModifiedTime() {
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Long getPrevModifiedTime() {
            return this.prevModifiedTime;
        }

        public Builder setPrevModifiedTime(long value) {
            this.validate(this.fields()[7], value);
            this.prevModifiedTime = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasPrevModifiedTime() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearPrevModifiedTime() {
            this.fieldSetFlags()[7] = false;
            return this;
        }

        public ProtocolStatus getProtocolStatus() {
            return this.protocolStatus;
        }

        public Builder setProtocolStatus(ProtocolStatus value) {
            this.validate(this.fields()[8], (Object)value);
            this.protocolStatus = value;
            this.fieldSetFlags()[8] = true;
            return this;
        }

        public boolean hasProtocolStatus() {
            return this.fieldSetFlags()[8];
        }

        public Builder clearProtocolStatus() {
            this.protocolStatus = null;
            this.fieldSetFlags()[8] = false;
            return this;
        }

        public ByteBuffer getContent() {
            return this.content;
        }

        public Builder setContent(ByteBuffer value) {
            this.validate(this.fields()[9], value);
            this.content = value;
            this.fieldSetFlags()[9] = true;
            return this;
        }

        public boolean hasContent() {
            return this.fieldSetFlags()[9];
        }

        public Builder clearContent() {
            this.content = null;
            this.fieldSetFlags()[9] = false;
            return this;
        }

        public CharSequence getContentType() {
            return this.contentType;
        }

        public Builder setContentType(CharSequence value) {
            this.validate(this.fields()[10], value);
            this.contentType = value;
            this.fieldSetFlags()[10] = true;
            return this;
        }

        public boolean hasContentType() {
            return this.fieldSetFlags()[10];
        }

        public Builder clearContentType() {
            this.contentType = null;
            this.fieldSetFlags()[10] = false;
            return this;
        }

        public ByteBuffer getPrevSignature() {
            return this.prevSignature;
        }

        public Builder setPrevSignature(ByteBuffer value) {
            this.validate(this.fields()[11], value);
            this.prevSignature = value;
            this.fieldSetFlags()[11] = true;
            return this;
        }

        public boolean hasPrevSignature() {
            return this.fieldSetFlags()[11];
        }

        public Builder clearPrevSignature() {
            this.prevSignature = null;
            this.fieldSetFlags()[11] = false;
            return this;
        }

        public ByteBuffer getSignature() {
            return this.signature;
        }

        public Builder setSignature(ByteBuffer value) {
            this.validate(this.fields()[12], value);
            this.signature = value;
            this.fieldSetFlags()[12] = true;
            return this;
        }

        public boolean hasSignature() {
            return this.fieldSetFlags()[12];
        }

        public Builder clearSignature() {
            this.signature = null;
            this.fieldSetFlags()[12] = false;
            return this;
        }

        public CharSequence getTitle() {
            return this.title;
        }

        public Builder setTitle(CharSequence value) {
            this.validate(this.fields()[13], value);
            this.title = value;
            this.fieldSetFlags()[13] = true;
            return this;
        }

        public boolean hasTitle() {
            return this.fieldSetFlags()[13];
        }

        public Builder clearTitle() {
            this.title = null;
            this.fieldSetFlags()[13] = false;
            return this;
        }

        public CharSequence getText() {
            return this.text;
        }

        public Builder setText(CharSequence value) {
            this.validate(this.fields()[14], value);
            this.text = value;
            this.fieldSetFlags()[14] = true;
            return this;
        }

        public boolean hasText() {
            return this.fieldSetFlags()[14];
        }

        public Builder clearText() {
            this.text = null;
            this.fieldSetFlags()[14] = false;
            return this;
        }

        public ParseStatus getParseStatus() {
            return this.parseStatus;
        }

        public Builder setParseStatus(ParseStatus value) {
            this.validate(this.fields()[15], (Object)value);
            this.parseStatus = value;
            this.fieldSetFlags()[15] = true;
            return this;
        }

        public boolean hasParseStatus() {
            return this.fieldSetFlags()[15];
        }

        public Builder clearParseStatus() {
            this.parseStatus = null;
            this.fieldSetFlags()[15] = false;
            return this;
        }

        public Float getScore() {
            return Float.valueOf(this.score);
        }

        public Builder setScore(float value) {
            this.validate(this.fields()[16], Float.valueOf(value));
            this.score = value;
            this.fieldSetFlags()[16] = true;
            return this;
        }

        public boolean hasScore() {
            return this.fieldSetFlags()[16];
        }

        public Builder clearScore() {
            this.fieldSetFlags()[16] = false;
            return this;
        }

        public CharSequence getReprUrl() {
            return this.reprUrl;
        }

        public Builder setReprUrl(CharSequence value) {
            this.validate(this.fields()[17], value);
            this.reprUrl = value;
            this.fieldSetFlags()[17] = true;
            return this;
        }

        public boolean hasReprUrl() {
            return this.fieldSetFlags()[17];
        }

        public Builder clearReprUrl() {
            this.reprUrl = null;
            this.fieldSetFlags()[17] = false;
            return this;
        }

        public Map<CharSequence, CharSequence> getHeaders() {
            return this.headers;
        }

        public Builder setHeaders(Map<CharSequence, CharSequence> value) {
            this.validate(this.fields()[18], value);
            this.headers = value;
            this.fieldSetFlags()[18] = true;
            return this;
        }

        public boolean hasHeaders() {
            return this.fieldSetFlags()[18];
        }

        public Builder clearHeaders() {
            this.headers = null;
            this.fieldSetFlags()[18] = false;
            return this;
        }

        public Map<CharSequence, CharSequence> getOutlinks() {
            return this.outlinks;
        }

        public Builder setOutlinks(Map<CharSequence, CharSequence> value) {
            this.validate(this.fields()[19], value);
            this.outlinks = value;
            this.fieldSetFlags()[19] = true;
            return this;
        }

        public boolean hasOutlinks() {
            return this.fieldSetFlags()[19];
        }

        public Builder clearOutlinks() {
            this.outlinks = null;
            this.fieldSetFlags()[19] = false;
            return this;
        }

        public Map<CharSequence, CharSequence> getInlinks() {
            return this.inlinks;
        }

        public Builder setInlinks(Map<CharSequence, CharSequence> value) {
            this.validate(this.fields()[20], value);
            this.inlinks = value;
            this.fieldSetFlags()[20] = true;
            return this;
        }

        public boolean hasInlinks() {
            return this.fieldSetFlags()[20];
        }

        public Builder clearInlinks() {
            this.inlinks = null;
            this.fieldSetFlags()[20] = false;
            return this;
        }

        public Map<CharSequence, CharSequence> getMarkers() {
            return this.markers;
        }

        public Builder setMarkers(Map<CharSequence, CharSequence> value) {
            this.validate(this.fields()[21], value);
            this.markers = value;
            this.fieldSetFlags()[21] = true;
            return this;
        }

        public boolean hasMarkers() {
            return this.fieldSetFlags()[21];
        }

        public Builder clearMarkers() {
            this.markers = null;
            this.fieldSetFlags()[21] = false;
            return this;
        }

        public Map<CharSequence, ByteBuffer> getMetadata() {
            return this.metadata;
        }

        public Builder setMetadata(Map<CharSequence, ByteBuffer> value) {
            this.validate(this.fields()[22], value);
            this.metadata = value;
            this.fieldSetFlags()[22] = true;
            return this;
        }

        public boolean hasMetadata() {
            return this.fieldSetFlags()[22];
        }

        public Builder clearMetadata() {
            this.metadata = null;
            this.fieldSetFlags()[22] = false;
            return this;
        }

        public CharSequence getBatchId() {
            return this.batchId;
        }

        public Builder setBatchId(CharSequence value) {
            this.validate(this.fields()[23], value);
            this.batchId = value;
            this.fieldSetFlags()[23] = true;
            return this;
        }

        public boolean hasBatchId() {
            return this.fieldSetFlags()[23];
        }

        public Builder clearBatchId() {
            this.batchId = null;
            this.fieldSetFlags()[23] = false;
            return this;
        }

        public WebPage build() {
            try {
                WebPage record = new WebPage();
                record.baseUrl = this.fieldSetFlags()[0] ? this.baseUrl : (CharSequence)this.defaultValue(this.fields()[0]);
                record.status = this.fieldSetFlags()[1] ? this.status : (Integer)this.defaultValue(this.fields()[1]);
                record.fetchTime = this.fieldSetFlags()[2] ? this.fetchTime : (Long)this.defaultValue(this.fields()[2]);
                record.prevFetchTime = this.fieldSetFlags()[3] ? this.prevFetchTime : (Long)this.defaultValue(this.fields()[3]);
                record.fetchInterval = this.fieldSetFlags()[4] ? this.fetchInterval : (Integer)this.defaultValue(this.fields()[4]);
                record.retriesSinceFetch = this.fieldSetFlags()[5] ? this.retriesSinceFetch : (Integer)this.defaultValue(this.fields()[5]);
                record.modifiedTime = this.fieldSetFlags()[6] ? this.modifiedTime : (Long)this.defaultValue(this.fields()[6]);
                record.prevModifiedTime = this.fieldSetFlags()[7] ? this.prevModifiedTime : (Long)this.defaultValue(this.fields()[7]);
                record.protocolStatus = this.fieldSetFlags()[8] ? this.protocolStatus : (ProtocolStatus)((Object)this.defaultValue(this.fields()[8]));
                record.content = this.fieldSetFlags()[9] ? this.content : (ByteBuffer)this.defaultValue(this.fields()[9]);
                record.contentType = this.fieldSetFlags()[10] ? this.contentType : (CharSequence)this.defaultValue(this.fields()[10]);
                record.prevSignature = this.fieldSetFlags()[11] ? this.prevSignature : (ByteBuffer)this.defaultValue(this.fields()[11]);
                record.signature = this.fieldSetFlags()[12] ? this.signature : (ByteBuffer)this.defaultValue(this.fields()[12]);
                record.title = this.fieldSetFlags()[13] ? this.title : (CharSequence)this.defaultValue(this.fields()[13]);
                record.text = this.fieldSetFlags()[14] ? this.text : (CharSequence)this.defaultValue(this.fields()[14]);
                record.parseStatus = this.fieldSetFlags()[15] ? this.parseStatus : (ParseStatus)((Object)this.defaultValue(this.fields()[15]));
                record.score = this.fieldSetFlags()[16] ? this.score : ((Float)this.defaultValue(this.fields()[16])).floatValue();
                record.reprUrl = this.fieldSetFlags()[17] ? this.reprUrl : (CharSequence)this.defaultValue(this.fields()[17]);
                record.headers = (Map)(this.fieldSetFlags()[18] ? this.headers : new DirtyMapWrapper((Map)this.defaultValue(this.fields()[18])));
                record.outlinks = (Map)(this.fieldSetFlags()[19] ? this.outlinks : new DirtyMapWrapper((Map)this.defaultValue(this.fields()[19])));
                record.inlinks = (Map)(this.fieldSetFlags()[20] ? this.inlinks : new DirtyMapWrapper((Map)this.defaultValue(this.fields()[20])));
                record.markers = (Map)(this.fieldSetFlags()[21] ? this.markers : new DirtyMapWrapper((Map)this.defaultValue(this.fields()[21])));
                record.metadata = (Map)(this.fieldSetFlags()[22] ? this.metadata : new DirtyMapWrapper((Map)this.defaultValue(this.fields()[22])));
                record.batchId = this.fieldSetFlags()[23] ? this.batchId : (CharSequence)this.defaultValue(this.fields()[23]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }

    public static enum Field {
        BASE_URL(0, "baseUrl"),
        STATUS(1, "status"),
        FETCH_TIME(2, "fetchTime"),
        PREV_FETCH_TIME(3, "prevFetchTime"),
        FETCH_INTERVAL(4, "fetchInterval"),
        RETRIES_SINCE_FETCH(5, "retriesSinceFetch"),
        MODIFIED_TIME(6, "modifiedTime"),
        PREV_MODIFIED_TIME(7, "prevModifiedTime"),
        PROTOCOL_STATUS(8, "protocolStatus"),
        CONTENT(9, "content"),
        CONTENT_TYPE(10, "contentType"),
        PREV_SIGNATURE(11, "prevSignature"),
        SIGNATURE(12, "signature"),
        TITLE(13, "title"),
        TEXT(14, "text"),
        PARSE_STATUS(15, "parseStatus"),
        SCORE(16, "score"),
        REPR_URL(17, "reprUrl"),
        HEADERS(18, "headers"),
        OUTLINKS(19, "outlinks"),
        INLINKS(20, "inlinks"),
        MARKERS(21, "markers"),
        METADATA(22, "metadata"),
        BATCH_ID(23, "batchId");

        private int index;
        private String name;

        private Field(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

