/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.storage;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.gora.filter.Filter;
import org.apache.gora.mapreduce.GoraMapper;
import org.apache.gora.mapreduce.GoraOutputFormat;
import org.apache.gora.mapreduce.GoraReducer;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.query.Query;
import org.apache.gora.store.DataStore;
import org.apache.gora.store.DataStoreFactory;
import org.apache.gora.util.GoraException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.nutch.storage.Host;
import org.apache.nutch.storage.WebPage;

public class StorageUtils {
    public static <K, V extends Persistent> DataStore<K, V> createWebStore(Configuration conf, Class<K> keyClass, Class<V> persistentClass) throws ClassNotFoundException, GoraException {
        String schema;
        String crawlId = conf.get("storage.crawl.id", "");
        String schemaPrefix = "";
        if (!crawlId.isEmpty()) {
            schemaPrefix = crawlId + "_";
        }
        if (WebPage.class.equals(persistentClass)) {
            schema = conf.get("storage.schema.webpage", "webpage");
            conf.set("preferred.schema.name", schemaPrefix + "webpage");
        } else if (Host.class.equals(persistentClass)) {
            schema = conf.get("storage.schema.host", "host");
            conf.set("preferred.schema.name", schemaPrefix + "host");
        } else {
            throw new UnsupportedOperationException("Unable to create store for class " + persistentClass);
        }
        Class<DataStore<K, V>> dataStoreClass = StorageUtils.getDataStoreClass(conf);
        return DataStoreFactory.createDataStore(dataStoreClass, keyClass, persistentClass, (Configuration)conf, (String)schema);
    }

    public static <K, V extends Persistent> Class<? extends DataStore<K, V>> getDataStoreClass(Configuration conf) throws ClassNotFoundException {
        return Class.forName(conf.get("storage.data.store.class", "org.apache.gora.sql.store.SqlStore"));
    }

    public static <K, V> void initMapperJob(Job job, Collection<WebPage.Field> fields, Class<K> outKeyClass, Class<V> outValueClass, Class<? extends GoraMapper<String, WebPage, K, V>> mapperClass) throws ClassNotFoundException, IOException {
        StorageUtils.initMapperJob(job, fields, outKeyClass, outValueClass, mapperClass, null, true);
    }

    public static <K, V> void initMapperJob(Job job, Collection<WebPage.Field> fields, Class<K> outKeyClass, Class<V> outValueClass, Class<? extends GoraMapper<String, WebPage, K, V>> mapperClass, Class<? extends Partitioner<K, V>> partitionerClass) throws ClassNotFoundException, IOException {
        StorageUtils.initMapperJob(job, fields, outKeyClass, outValueClass, mapperClass, partitionerClass, true);
    }

    public static <K, V> void initMapperJob(Job job, Collection<WebPage.Field> fields, Class<K> outKeyClass, Class<V> outValueClass, Class<? extends GoraMapper<String, WebPage, K, V>> mapperClass, Class<? extends Partitioner<K, V>> partitionerClass, boolean reuseObjects) throws ClassNotFoundException, IOException {
        StorageUtils.initMapperJob(job, fields, outKeyClass, outValueClass, mapperClass, partitionerClass, null, reuseObjects);
    }

    public static <K, V> void initMapperJob(Job job, Collection<WebPage.Field> fields, Class<K> outKeyClass, Class<V> outValueClass, Class<? extends GoraMapper<String, WebPage, K, V>> mapperClass, Class<? extends Partitioner<K, V>> partitionerClass, Filter<String, WebPage> filter, boolean reuseObjects) throws ClassNotFoundException, IOException {
        DataStore<String, WebPage> store = StorageUtils.createWebStore(job.getConfiguration(), String.class, WebPage.class);
        if (store == null) {
            throw new RuntimeException("Could not create datastore");
        }
        Query query = store.newQuery();
        query.setFields(StorageUtils.toStringArray(fields));
        if (filter != null) {
            query.setFilter(filter);
        }
        GoraMapper.initMapperJob((Job)job, (Query)query, store, outKeyClass, outValueClass, mapperClass, partitionerClass, (boolean)reuseObjects);
        GoraOutputFormat.setOutput((Job)job, store, (boolean)true);
    }

    public static <K, V> void initMapperJob(Job job, Collection<WebPage.Field> fields, Class<K> outKeyClass, Class<V> outValueClass, Class<? extends GoraMapper<String, WebPage, K, V>> mapperClass, Filter<String, WebPage> filter) throws ClassNotFoundException, IOException {
        StorageUtils.initMapperJob(job, fields, outKeyClass, outValueClass, mapperClass, null, filter, true);
    }

    public static <K, V> void initReducerJob(Job job, Class<? extends GoraReducer<K, V, String, WebPage>> reducerClass) throws ClassNotFoundException, GoraException {
        Configuration conf = job.getConfiguration();
        DataStore<String, WebPage> store = StorageUtils.createWebStore(conf, String.class, WebPage.class);
        GoraReducer.initReducerJob((Job)job, store, reducerClass);
        GoraOutputFormat.setOutput((Job)job, store, (boolean)true);
    }

    public static String[] toStringArray(Collection<WebPage.Field> fields) {
        String[] arr = new String[fields.size()];
        Iterator<WebPage.Field> iter = fields.iterator();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = iter.next().getName();
        }
        return arr;
    }
}

