/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.storage;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.gora.persistency.Dirtyable;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.DirtyListWrapper;
import org.apache.gora.persistency.impl.PersistentBase;

public class ProtocolStatus
extends PersistentBase
implements SpecificRecord,
Persistent {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"ProtocolStatus\",\"namespace\":\"org.apache.nutch.storage\",\"doc\":\"A nested container representing data captured from web server responses.\",\"fields\":[{\"name\":\"code\",\"type\":\"int\",\"doc\":\"A protocol response code which can be one of SUCCESS - content was retrieved without errors, FAILED - Content was not retrieved. Any further errors may be indicated in args, PROTO_NOT_FOUND - This protocol was not found. Application may attempt to retry later, GONE - Resource is gone, MOVED - Resource has moved permanently. New url should be found in args, TEMP_MOVED - Resource has moved temporarily. New url should be found in args., NOTFOUND - Resource was not found, RETRY - Temporary failure. Application may retry immediately., EXCEPTION - Unspecified exception occured. Further information may be provided in args., ACCESS_DENIED - Access denied - authorization required, but missing/incorrect., ROBOTS_DENIED - Access denied by robots.txt rules., REDIR_EXCEEDED - Too many redirects., NOTFETCHING - Not fetching., NOTMODIFIED - Unchanged since the last fetch., WOULDBLOCK - Request was refused by protocol plugins, because it would block. The expected number of milliseconds to wait before retry may be provided in args., BLOCKED - Thread was blocked http.max.delays times during fetching.\",\"default\":0},{\"name\":\"args\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"Optional arguments supplied to compliment and/or justify the response code.\",\"default\":[]},{\"name\":\"lastModified\",\"type\":\"long\",\"doc\":\"A server reponse indicating when this page was last modified, this can be unreliable at times hence this is used as a default fall back value for the preferred 'modifiedTime' and 'preModifiedTime' obtained from the WebPage itself.\",\"default\":0}]}");
    public static final String[] _ALL_FIELDS = new String[]{"code", "args", "lastModified"};
    private int code;
    private List<CharSequence> args;
    private long lastModified;
    private static final Tombstone TOMBSTONE = new Tombstone();

    public int getFieldsCount() {
        return _ALL_FIELDS.length;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.code;
            }
            case 1: {
                return this.args;
            }
            case 2: {
                return this.lastModified;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value) {
        switch (field$) {
            case 0: {
                this.code = (Integer)value;
                break;
            }
            case 1: {
                this.args = (List)(value instanceof Dirtyable ? value : new DirtyListWrapper((List)value));
                break;
            }
            case 2: {
                this.lastModified = (Long)value;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer value) {
        this.code = value;
        this.setDirty(0);
    }

    public boolean isCodeDirty(Integer value) {
        return this.isDirty(0);
    }

    public List<CharSequence> getArgs() {
        return this.args;
    }

    public void setArgs(List<CharSequence> value) {
        this.args = value instanceof Dirtyable ? value : new DirtyListWrapper((List)value);
        this.setDirty(1);
    }

    public boolean isArgsDirty(List<CharSequence> value) {
        return this.isDirty(1);
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long value) {
        this.lastModified = value;
        this.setDirty(2);
    }

    public boolean isLastModifiedDirty(Long value) {
        return this.isDirty(2);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(ProtocolStatus other) {
        return new Builder(other);
    }

    private static ByteBuffer deepCopyToReadOnlyBuffer(ByteBuffer input) {
        ByteBuffer copy = ByteBuffer.allocate(input.capacity());
        int position = input.position();
        input.reset();
        int mark = input.position();
        int limit = input.limit();
        input.rewind();
        input.limit(input.capacity());
        copy.put(input);
        input.rewind();
        copy.rewind();
        input.position(mark);
        input.mark();
        copy.position(mark);
        copy.mark();
        input.position(position);
        copy.position(position);
        input.limit(limit);
        copy.limit(limit);
        return copy.asReadOnlyBuffer();
    }

    public Tombstone getTombstone() {
        return TOMBSTONE;
    }

    public ProtocolStatus newInstance() {
        return ProtocolStatus.newBuilder().build();
    }

    public boolean isSuccess() {
        return this.code == 1;
    }

    public static final class Tombstone
    extends ProtocolStatus
    implements org.apache.gora.persistency.Tombstone {
        private Tombstone() {
        }

        @Override
        public Integer getCode() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setCode(Integer value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isCodeDirty(Integer value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public List<CharSequence> getArgs() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setArgs(List<CharSequence> value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isArgsDirty(List<CharSequence> value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Long getLastModified() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setLastModified(Long value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isLastModifiedDirty(Long value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }
    }

    public static class Builder
    extends SpecificRecordBuilderBase<ProtocolStatus>
    implements RecordBuilder<ProtocolStatus> {
        private int code;
        private List<CharSequence> args;
        private long lastModified;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(ProtocolStatus other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.code)) {
                this.code = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.code);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.args)) {
                this.args = (List)this.data().deepCopy(this.fields()[1].schema(), (Object)other.args);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.lastModified)) {
                this.lastModified = (Long)this.data().deepCopy(this.fields()[2].schema(), (Object)other.lastModified);
                this.fieldSetFlags()[2] = true;
            }
        }

        public Integer getCode() {
            return this.code;
        }

        public Builder setCode(int value) {
            this.validate(this.fields()[0], value);
            this.code = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasCode() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearCode() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public List<CharSequence> getArgs() {
            return this.args;
        }

        public Builder setArgs(List<CharSequence> value) {
            this.validate(this.fields()[1], value);
            this.args = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasArgs() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearArgs() {
            this.args = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getLastModified() {
            return this.lastModified;
        }

        public Builder setLastModified(long value) {
            this.validate(this.fields()[2], value);
            this.lastModified = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasLastModified() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearLastModified() {
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public ProtocolStatus build() {
            try {
                ProtocolStatus record = new ProtocolStatus();
                record.code = this.fieldSetFlags()[0] ? this.code : (Integer)this.defaultValue(this.fields()[0]);
                record.args = (List)(this.fieldSetFlags()[1] ? this.args : new DirtyListWrapper((List)this.defaultValue(this.fields()[1])));
                record.lastModified = this.fieldSetFlags()[2] ? this.lastModified : (Long)this.defaultValue(this.fields()[2]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }

    public static enum Field {
        CODE(0, "code"),
        ARGS(1, "args"),
        LAST_MODIFIED(2, "lastModified");

        private int index;
        private String name;

        private Field(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

