/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.storage;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.gora.persistency.Dirtyable;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.DirtyListWrapper;
import org.apache.gora.persistency.impl.PersistentBase;

public class ParseStatus
extends PersistentBase
implements SpecificRecord,
Persistent {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"ParseStatus\",\"namespace\":\"org.apache.nutch.storage\",\"doc\":\"A nested container representing parse status data captured from invocation of parsers on fetch of a WebPage\",\"fields\":[{\"name\":\"majorCode\",\"type\":\"int\",\"doc\":\"Major parsing status' including NOTPARSED (Parsing was not performed), SUCCESS (Parsing succeeded), FAILED (General failure. There may be a more specific error message in arguments.)\",\"default\":0},{\"name\":\"minorCode\",\"type\":\"int\",\"doc\":\"Minor parsing status' including SUCCESS_OK - Successful parse devoid of anomalies or issues, SUCCESS_REDIRECT - Parsed content contains a directive to redirect to another URL. The target URL can be retrieved from the arguments., FAILED_EXCEPTION - Parsing failed. An Exception occured which may be retrieved from the arguments., FAILED_TRUNCATED - Parsing failed. Content was truncated, but the parser cannot handle incomplete content., FAILED_INVALID_FORMAT - Parsing failed. Invalid format e.g. the content may be corrupted or of wrong type., FAILED_MISSING_PARTS - Parsing failed. Other related parts of the content are needed to complete parsing. The list of URLs to missing parts may be provided in arguments. The Fetcher may decide to fetch these parts at once, then put them into Content.metadata, and supply them for re-parsing., FAILED_MISING_CONTENT - Parsing failed. There was no content to be parsed - probably caused by errors at protocol stage.\",\"default\":0},{\"name\":\"args\",\"type\":{\"type\":\"array\",\"items\":\"string\"},\"doc\":\"Optional arguments supplied to compliment and/or justify the parse status code.\",\"default\":[]}]}");
    public static final String[] _ALL_FIELDS = new String[]{"majorCode", "minorCode", "args"};
    private int majorCode;
    private int minorCode;
    private List<CharSequence> args;
    private static final Tombstone TOMBSTONE = new Tombstone();

    public int getFieldsCount() {
        return _ALL_FIELDS.length;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.majorCode;
            }
            case 1: {
                return this.minorCode;
            }
            case 2: {
                return this.args;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value) {
        switch (field$) {
            case 0: {
                this.majorCode = (Integer)value;
                break;
            }
            case 1: {
                this.minorCode = (Integer)value;
                break;
            }
            case 2: {
                this.args = (List)(value instanceof Dirtyable ? value : new DirtyListWrapper((List)value));
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Integer getMajorCode() {
        return this.majorCode;
    }

    public void setMajorCode(Integer value) {
        this.majorCode = value;
        this.setDirty(0);
    }

    public boolean isMajorCodeDirty(Integer value) {
        return this.isDirty(0);
    }

    public Integer getMinorCode() {
        return this.minorCode;
    }

    public void setMinorCode(Integer value) {
        this.minorCode = value;
        this.setDirty(1);
    }

    public boolean isMinorCodeDirty(Integer value) {
        return this.isDirty(1);
    }

    public List<CharSequence> getArgs() {
        return this.args;
    }

    public void setArgs(List<CharSequence> value) {
        this.args = value instanceof Dirtyable ? value : new DirtyListWrapper((List)value);
        this.setDirty(2);
    }

    public boolean isArgsDirty(List<CharSequence> value) {
        return this.isDirty(2);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(ParseStatus other) {
        return new Builder(other);
    }

    private static ByteBuffer deepCopyToReadOnlyBuffer(ByteBuffer input) {
        ByteBuffer copy = ByteBuffer.allocate(input.capacity());
        int position = input.position();
        input.reset();
        int mark = input.position();
        int limit = input.limit();
        input.rewind();
        input.limit(input.capacity());
        copy.put(input);
        input.rewind();
        copy.rewind();
        input.position(mark);
        input.mark();
        copy.position(mark);
        copy.mark();
        input.position(position);
        copy.position(position);
        input.limit(limit);
        copy.limit(limit);
        return copy.asReadOnlyBuffer();
    }

    public Tombstone getTombstone() {
        return TOMBSTONE;
    }

    public ParseStatus newInstance() {
        return ParseStatus.newBuilder().build();
    }

    public static final class Tombstone
    extends ParseStatus
    implements org.apache.gora.persistency.Tombstone {
        private Tombstone() {
        }

        @Override
        public Integer getMajorCode() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setMajorCode(Integer value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isMajorCodeDirty(Integer value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Integer getMinorCode() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setMinorCode(Integer value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isMinorCodeDirty(Integer value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public List<CharSequence> getArgs() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setArgs(List<CharSequence> value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isArgsDirty(List<CharSequence> value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }
    }

    public static class Builder
    extends SpecificRecordBuilderBase<ParseStatus>
    implements RecordBuilder<ParseStatus> {
        private int majorCode;
        private int minorCode;
        private List<CharSequence> args;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(ParseStatus other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.majorCode)) {
                this.majorCode = (Integer)this.data().deepCopy(this.fields()[0].schema(), (Object)other.majorCode);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.minorCode)) {
                this.minorCode = (Integer)this.data().deepCopy(this.fields()[1].schema(), (Object)other.minorCode);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.args)) {
                this.args = (List)this.data().deepCopy(this.fields()[2].schema(), (Object)other.args);
                this.fieldSetFlags()[2] = true;
            }
        }

        public Integer getMajorCode() {
            return this.majorCode;
        }

        public Builder setMajorCode(int value) {
            this.validate(this.fields()[0], value);
            this.majorCode = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasMajorCode() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearMajorCode() {
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Integer getMinorCode() {
            return this.minorCode;
        }

        public Builder setMinorCode(int value) {
            this.validate(this.fields()[1], value);
            this.minorCode = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasMinorCode() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearMinorCode() {
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public List<CharSequence> getArgs() {
            return this.args;
        }

        public Builder setArgs(List<CharSequence> value) {
            this.validate(this.fields()[2], value);
            this.args = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasArgs() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearArgs() {
            this.args = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public ParseStatus build() {
            try {
                ParseStatus record = new ParseStatus();
                record.majorCode = this.fieldSetFlags()[0] ? this.majorCode : (Integer)this.defaultValue(this.fields()[0]);
                record.minorCode = this.fieldSetFlags()[1] ? this.minorCode : (Integer)this.defaultValue(this.fields()[1]);
                record.args = (List)(this.fieldSetFlags()[2] ? this.args : new DirtyListWrapper((List)this.defaultValue(this.fields()[2])));
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }

    public static enum Field {
        MAJOR_CODE(0, "majorCode"),
        MINOR_CODE(1, "minorCode"),
        ARGS(2, "args");

        private int index;
        private String name;

        private Field(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

