/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.storage;

import org.apache.avro.util.Utf8;
import org.apache.nutch.storage.WebPage;

public enum Mark {
    INJECT_MARK("_injmrk_"),
    GENERATE_MARK("_gnmrk_"),
    FETCH_MARK("_ftcmrk_"),
    PARSE_MARK("__prsmrk__"),
    UPDATEDB_MARK("_updmrk_"),
    INDEX_MARK("_idxmrk_");

    private Utf8 name;

    private Mark(String name) {
        this.name = new Utf8(name);
    }

    public void putMark(WebPage page, Utf8 markValue) {
        page.getMarkers().put((CharSequence)this.name, (CharSequence)markValue);
    }

    public void putMark(WebPage page, String markValue) {
        this.putMark(page, new Utf8(markValue));
    }

    public Utf8 removeMark(WebPage page) {
        return page.getMarkers().put((CharSequence)this.name, null);
    }

    public Utf8 checkMark(WebPage page) {
        return (Utf8)page.getMarkers().get(this.name);
    }

    public Utf8 removeMarkIfExist(WebPage page) {
        if (this.checkMark(page) != null) {
            return this.removeMark(page);
        }
        return null;
    }

    public Utf8 getName() {
        return this.name;
    }
}

