/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.storage;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBuilderBase;
import org.apache.avro.util.Utf8;
import org.apache.gora.persistency.Dirtyable;
import org.apache.gora.persistency.Persistent;
import org.apache.gora.persistency.impl.DirtyMapWrapper;
import org.apache.gora.persistency.impl.PersistentBase;
import org.apache.nutch.util.Bytes;

public class Host
extends PersistentBase
implements SpecificRecord,
Persistent {
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"Host\",\"namespace\":\"org.apache.nutch.storage\",\"doc\":\"Host represents a store of webpages or other data which resides on a server or other computer so that it can be accessed over the Internet\",\"fields\":[{\"name\":\"metadata\",\"type\":{\"type\":\"map\",\"values\":[\"null\",\"bytes\"]},\"doc\":\"A multivalued metadata container used for storing a wide variety of host metadata such as structured web server characterists etc\",\"default\":{}},{\"name\":\"outlinks\",\"type\":{\"type\":\"map\",\"values\":[\"null\",\"string\"]},\"doc\":\"Hyperlinks which direct outside of the current host domain these can used in a histogram style manner to generate host statistics\",\"default\":{}},{\"name\":\"inlinks\",\"type\":{\"type\":\"map\",\"values\":[\"null\",\"string\"]},\"doc\":\"Hyperlinks which link to pages within the current host domain these can used in a histogram style manner to generate host statistics\",\"default\":{}}]}");
    public static final String[] _ALL_FIELDS = new String[]{"metadata", "outlinks", "inlinks"};
    private Map<CharSequence, ByteBuffer> metadata;
    private Map<CharSequence, CharSequence> outlinks;
    private Map<CharSequence, CharSequence> inlinks;
    private static final Tombstone TOMBSTONE = new Tombstone();

    public int getFieldsCount() {
        return _ALL_FIELDS.length;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.metadata;
            }
            case 1: {
                return this.outlinks;
            }
            case 2: {
                return this.inlinks;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value) {
        switch (field$) {
            case 0: {
                this.metadata = (Map)(value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value));
                break;
            }
            case 1: {
                this.outlinks = (Map)(value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value));
                break;
            }
            case 2: {
                this.inlinks = (Map)(value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value));
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public Map<CharSequence, ByteBuffer> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<CharSequence, ByteBuffer> value) {
        this.metadata = value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value);
        this.setDirty(0);
    }

    public boolean isMetadataDirty(Map<CharSequence, ByteBuffer> value) {
        return this.isDirty(0);
    }

    public Map<CharSequence, CharSequence> getOutlinks() {
        return this.outlinks;
    }

    public void setOutlinks(Map<CharSequence, CharSequence> value) {
        this.outlinks = value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value);
        this.setDirty(1);
    }

    public boolean isOutlinksDirty(Map<CharSequence, CharSequence> value) {
        return this.isDirty(1);
    }

    public Map<CharSequence, CharSequence> getInlinks() {
        return this.inlinks;
    }

    public void setInlinks(Map<CharSequence, CharSequence> value) {
        this.inlinks = value instanceof Dirtyable ? value : new DirtyMapWrapper((Map)value);
        this.setDirty(2);
    }

    public boolean isInlinksDirty(Map<CharSequence, CharSequence> value) {
        return this.isDirty(2);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(Host other) {
        return new Builder(other);
    }

    private static ByteBuffer deepCopyToReadOnlyBuffer(ByteBuffer input) {
        ByteBuffer copy = ByteBuffer.allocate(input.capacity());
        int position = input.position();
        input.reset();
        int mark = input.position();
        int limit = input.limit();
        input.rewind();
        input.limit(input.capacity());
        copy.put(input);
        input.rewind();
        copy.rewind();
        input.position(mark);
        input.mark();
        copy.position(mark);
        copy.mark();
        input.position(position);
        copy.position(position);
        input.limit(limit);
        copy.limit(limit);
        return copy.asReadOnlyBuffer();
    }

    public Tombstone getTombstone() {
        return TOMBSTONE;
    }

    public Host newInstance() {
        return Host.newBuilder().build();
    }

    public boolean contains(String key) {
        return this.metadata.containsKey(new Utf8(key));
    }

    public String getValue(String key, String defaultValue) {
        if (!this.contains(key)) {
            return defaultValue;
        }
        return Bytes.toString(this.metadata.get(new Utf8(key)));
    }

    public int getInt(String key, int defaultValue) {
        if (!this.contains(key)) {
            return defaultValue;
        }
        return Integer.parseInt(this.getValue(key, null));
    }

    public long getLong(String key, long defaultValue) {
        if (!this.contains(key)) {
            return defaultValue;
        }
        return Long.parseLong(this.getValue(key, null));
    }

    public static final class Tombstone
    extends Host
    implements org.apache.gora.persistency.Tombstone {
        private Tombstone() {
        }

        @Override
        public Map<CharSequence, ByteBuffer> getMetadata() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setMetadata(Map<CharSequence, ByteBuffer> value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isMetadataDirty(Map<CharSequence, ByteBuffer> value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Map<CharSequence, CharSequence> getOutlinks() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setOutlinks(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isOutlinksDirty(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }

        @Override
        public Map<CharSequence, CharSequence> getInlinks() {
            throw new UnsupportedOperationException("Get is not supported on tombstones");
        }

        @Override
        public void setInlinks(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("Set is not supported on tombstones");
        }

        @Override
        public boolean isInlinksDirty(Map<CharSequence, CharSequence> value) {
            throw new UnsupportedOperationException("IsDirty is not supported on tombstones");
        }
    }

    public static class Builder
    extends SpecificRecordBuilderBase<Host>
    implements RecordBuilder<Host> {
        private Map<CharSequence, ByteBuffer> metadata;
        private Map<CharSequence, CharSequence> outlinks;
        private Map<CharSequence, CharSequence> inlinks;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
        }

        private Builder(Host other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.metadata)) {
                this.metadata = (Map)this.data().deepCopy(this.fields()[0].schema(), (Object)other.metadata);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.outlinks)) {
                this.outlinks = (Map)this.data().deepCopy(this.fields()[1].schema(), (Object)other.outlinks);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[2], (Object)other.inlinks)) {
                this.inlinks = (Map)this.data().deepCopy(this.fields()[2].schema(), (Object)other.inlinks);
                this.fieldSetFlags()[2] = true;
            }
        }

        public Map<CharSequence, ByteBuffer> getMetadata() {
            return this.metadata;
        }

        public Builder setMetadata(Map<CharSequence, ByteBuffer> value) {
            this.validate(this.fields()[0], value);
            this.metadata = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasMetadata() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearMetadata() {
            this.metadata = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Map<CharSequence, CharSequence> getOutlinks() {
            return this.outlinks;
        }

        public Builder setOutlinks(Map<CharSequence, CharSequence> value) {
            this.validate(this.fields()[1], value);
            this.outlinks = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasOutlinks() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearOutlinks() {
            this.outlinks = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Map<CharSequence, CharSequence> getInlinks() {
            return this.inlinks;
        }

        public Builder setInlinks(Map<CharSequence, CharSequence> value) {
            this.validate(this.fields()[2], value);
            this.inlinks = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasInlinks() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearInlinks() {
            this.inlinks = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Host build() {
            try {
                Host record = new Host();
                record.metadata = (Map)(this.fieldSetFlags()[0] ? this.metadata : new DirtyMapWrapper((Map)this.defaultValue(this.fields()[0])));
                record.outlinks = (Map)(this.fieldSetFlags()[1] ? this.outlinks : new DirtyMapWrapper((Map)this.defaultValue(this.fields()[1])));
                record.inlinks = (Map)(this.fieldSetFlags()[2] ? this.inlinks : new DirtyMapWrapper((Map)this.defaultValue(this.fields()[2])));
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }

    public static enum Field {
        METADATA(0, "metadata"),
        OUTLINKS(1, "outlinks"),
        INLINKS(2, "inlinks");

        private int index;
        private String name;

        private Field(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

