/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.scoring.ScoreDatum;
import org.apache.nutch.scoring.ScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.ObjectCache;

public class ScoringFilters
extends Configured
implements ScoringFilter {
    private ScoringFilter[] filters;

    public ScoringFilters(Configuration conf) {
        super(conf);
        ObjectCache objectCache = ObjectCache.get(conf);
        String order = conf.get("scoring.filter.order");
        this.filters = (ScoringFilter[])objectCache.getObject(ScoringFilter.class.getName());
        if (this.filters == null) {
            String[] orderedFilters = null;
            if (order != null && !order.trim().equals("")) {
                orderedFilters = order.split("\\s+");
            }
            try {
                ExtensionPoint point = PluginRepository.get(conf).getExtensionPoint(ScoringFilter.X_POINT_ID);
                if (point == null) {
                    throw new RuntimeException(ScoringFilter.X_POINT_ID + " not found.");
                }
                Extension[] extensions = point.getExtensions();
                HashMap<String, ScoringFilter> filterMap = new HashMap<String, ScoringFilter>();
                for (int i = 0; i < extensions.length; ++i) {
                    Extension extension = extensions[i];
                    ScoringFilter filter = (ScoringFilter)extension.getExtensionInstance();
                    if (filterMap.containsKey(filter.getClass().getName())) continue;
                    filterMap.put(filter.getClass().getName(), filter);
                }
                if (orderedFilters == null) {
                    objectCache.setObject(ScoringFilter.class.getName(), filterMap.values().toArray(new ScoringFilter[0]));
                } else {
                    ScoringFilter[] filter = new ScoringFilter[orderedFilters.length];
                    for (int i = 0; i < orderedFilters.length; ++i) {
                        filter[i] = (ScoringFilter)filterMap.get(orderedFilters[i]);
                    }
                    objectCache.setObject(ScoringFilter.class.getName(), filter);
                }
            }
            catch (PluginRuntimeException e) {
                throw new RuntimeException(e);
            }
            this.filters = (ScoringFilter[])objectCache.getObject(ScoringFilter.class.getName());
        }
    }

    @Override
    public float generatorSortValue(String url, WebPage row, float initSort) throws ScoringFilterException {
        for (ScoringFilter filter : this.filters) {
            initSort = filter.generatorSortValue(url, row, initSort);
        }
        return initSort;
    }

    @Override
    public void initialScore(String url, WebPage row) throws ScoringFilterException {
        for (ScoringFilter filter : this.filters) {
            filter.initialScore(url, row);
        }
    }

    @Override
    public void injectedScore(String url, WebPage row) throws ScoringFilterException {
        for (ScoringFilter filter : this.filters) {
            filter.injectedScore(url, row);
        }
    }

    @Override
    public void distributeScoreToOutlinks(String fromUrl, WebPage row, Collection<ScoreDatum> scoreData, int allCount) throws ScoringFilterException {
        for (ScoringFilter filter : this.filters) {
            filter.distributeScoreToOutlinks(fromUrl, row, scoreData, allCount);
        }
    }

    @Override
    public void updateScore(String url, WebPage row, List<ScoreDatum> inlinkedScoreData) throws ScoringFilterException {
        for (ScoringFilter filter : this.filters) {
            filter.updateScore(url, row, inlinkedScoreData);
        }
    }

    @Override
    public float indexerScore(String url, NutchDocument doc, WebPage row, float initScore) throws ScoringFilterException {
        for (ScoringFilter filter : this.filters) {
            initScore = filter.indexerScore(url, doc, row, initScore);
        }
        return initScore;
    }

    @Override
    public Collection<WebPage.Field> getFields() {
        HashSet<WebPage.Field> fields = new HashSet<WebPage.Field>();
        for (ScoringFilter filter : this.filters) {
            Collection pluginFields = filter.getFields();
            if (pluginFields == null) continue;
            fields.addAll(pluginFields);
        }
        return fields;
    }
}

