/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.nutch.util.Bytes;

public class ScoreDatum
implements Writable {
    private float score;
    private String url;
    private String anchor;
    private int distance;
    private Map<String, byte[]> metaData = new HashMap<String, byte[]>();

    public ScoreDatum() {
    }

    public ScoreDatum(float score, String url, String anchor, int depth) {
        this.score = score;
        this.url = url;
        this.anchor = anchor;
        this.distance = depth;
    }

    public void readFields(DataInput in) throws IOException {
        this.score = in.readFloat();
        this.url = Text.readString((DataInput)in);
        this.anchor = Text.readString((DataInput)in);
        this.distance = WritableUtils.readVInt((DataInput)in);
        this.metaData.clear();
        int size = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            byte[] value = Bytes.readByteArray(in);
            this.metaData.put(key, value);
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeFloat(this.score);
        Text.writeString((DataOutput)out, (String)this.url);
        Text.writeString((DataOutput)out, (String)this.anchor);
        WritableUtils.writeVInt((DataOutput)out, (int)this.distance);
        WritableUtils.writeVInt((DataOutput)out, (int)this.metaData.size());
        for (Map.Entry<String, byte[]> e : this.metaData.entrySet()) {
            Text.writeString((DataOutput)out, (String)e.getKey());
            Bytes.writeByteArray(out, e.getValue());
        }
    }

    public byte[] getMeta(String key) {
        return this.metaData.get(key);
    }

    public void setMeta(String key, byte[] value) {
        this.metaData.put(key, value);
    }

    public byte[] deleteMeta(String key) {
        return this.metaData.remove(key);
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public int getDistance() {
        return this.distance;
    }

    public String toString() {
        return "ScoreDatum [score=" + this.score + ", url=" + this.url + ", anchor=" + this.anchor + ", distance=" + this.distance + ", metaData=" + this.metaData + "]";
    }
}

