/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol;

import com.google.common.io.Files;
import crawlercommons.robots.BaseRobotRules;
import crawlercommons.robots.SimpleRobotRules;
import crawlercommons.robots.SimpleRobotRulesParser;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.protocol.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RobotRulesParser
implements Configurable {
    public static final Logger LOG = LoggerFactory.getLogger(RobotRulesParser.class);
    protected static final Hashtable<String, BaseRobotRules> CACHE = new Hashtable();
    public static final BaseRobotRules EMPTY_RULES = new SimpleRobotRules(SimpleRobotRules.RobotRulesMode.ALLOW_ALL);
    public static BaseRobotRules FORBID_ALL_RULES = new SimpleRobotRules(SimpleRobotRules.RobotRulesMode.ALLOW_NONE);
    private static SimpleRobotRulesParser robotParser = new SimpleRobotRulesParser();
    private Configuration conf;
    protected String agentNames;

    public RobotRulesParser() {
    }

    public RobotRulesParser(Configuration conf) {
        this.setConf(conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String agentName = conf.get("http.agent.name");
        if (agentName == null || (agentName = agentName.trim()).isEmpty()) {
            throw new RuntimeException("Agent name not configured!");
        }
        this.agentNames = agentName;
        String otherAgents = conf.get("http.robots.agents");
        if (otherAgents != null && !otherAgents.trim().isEmpty()) {
            StringTokenizer tok = new StringTokenizer(otherAgents, ",");
            StringBuilder sb = new StringBuilder(this.agentNames);
            while (tok.hasMoreTokens()) {
                String str = tok.nextToken().trim();
                if (str.equals("*") || str.equals(agentName)) continue;
                sb.append(",").append(str);
            }
            this.agentNames = sb.toString();
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public BaseRobotRules parseRules(String url, byte[] content, String contentType, String robotName) {
        return robotParser.parseContent(url, content, contentType, robotName);
    }

    public BaseRobotRules getRobotRulesSet(Protocol protocol, String url) {
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (Exception e) {
            return EMPTY_RULES;
        }
        return this.getRobotRulesSet(protocol, u);
    }

    public abstract BaseRobotRules getRobotRulesSet(Protocol var1, URL var2);

    public static void main(String[] argv) {
        if (argv.length != 3) {
            System.err.println("Usage: RobotRulesParser <robots-file> <url-file> <agent-names>\n");
            System.err.println("    <robots-file> - Input robots.txt file which will be parsed.");
            System.err.println("    <url-file>    - Contains input URLs (1 per line) which are tested against the rules.");
            System.err.println("    <agent-names> - Input agent names. Multiple agent names can be provided using");
            System.err.println("                    comma as a delimiter without any spaces.");
            System.exit(-1);
        }
        try {
            byte[] robotsBytes = Files.toByteArray((File)new File(argv[0]));
            BaseRobotRules rules = robotParser.parseContent(argv[0], robotsBytes, "text/plain", argv[2]);
            LineNumberReader testsIn = new LineNumberReader(new FileReader(argv[1]));
            String testPath = testsIn.readLine().trim();
            while (testPath != null) {
                System.out.println((rules.isAllowed(testPath) ? "allowed" : "not allowed") + ":\t" + testPath);
                testPath = testsIn.readLine();
            }
            testsIn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

