/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.util.Utf8;
import org.apache.nutch.protocol.ProtocolStatusCodes;
import org.apache.nutch.storage.ProtocolStatus;
import org.apache.nutch.util.TableUtil;

public class ProtocolStatusUtils
implements ProtocolStatusCodes {
    public static final ProtocolStatus STATUS_SUCCESS = ProtocolStatusUtils.makeStatus(1);
    public static final ProtocolStatus STATUS_FAILED = ProtocolStatusUtils.makeStatus(2);
    public static final ProtocolStatus STATUS_GONE = ProtocolStatusUtils.makeStatus(11);
    public static final ProtocolStatus STATUS_NOTFOUND = ProtocolStatusUtils.makeStatus(14);
    public static final ProtocolStatus STATUS_RETRY = ProtocolStatusUtils.makeStatus(15);
    public static final ProtocolStatus STATUS_ROBOTS_DENIED = ProtocolStatusUtils.makeStatus(18);
    public static final ProtocolStatus STATUS_REDIR_EXCEEDED = ProtocolStatusUtils.makeStatus(19);
    public static final ProtocolStatus STATUS_NOTFETCHING = ProtocolStatusUtils.makeStatus(20);
    public static final ProtocolStatus STATUS_NOTMODIFIED = ProtocolStatusUtils.makeStatus(21);
    public static final ProtocolStatus STATUS_WOULDBLOCK = ProtocolStatusUtils.makeStatus(22);
    public static final ProtocolStatus STATUS_BLOCKED = ProtocolStatusUtils.makeStatus(23);

    public static String getName(int code) {
        if (code == 1) {
            return "SUCCESS";
        }
        if (code == 2) {
            return "FAILED";
        }
        if (code == 10) {
            return "PROTO_NOT_FOUND";
        }
        if (code == 11) {
            return "GONE";
        }
        if (code == 12) {
            return "MOVED";
        }
        if (code == 13) {
            return "TEMP_MOVED";
        }
        if (code == 14) {
            return "NOTFOUND";
        }
        if (code == 15) {
            return "RETRY";
        }
        if (code == 16) {
            return "EXCEPTION";
        }
        if (code == 17) {
            return "ACCESS_DENIED";
        }
        if (code == 18) {
            return "ROBOTS_DENIED";
        }
        if (code == 19) {
            return "REDIR_EXCEEDED";
        }
        if (code == 20) {
            return "NOTFETCHING";
        }
        if (code == 21) {
            return "NOTMODIFIED";
        }
        if (code == 22) {
            return "WOULDBLOCK";
        }
        if (code == 23) {
            return "BLOCKED";
        }
        return "UNKNOWN_CODE_" + code;
    }

    public static ProtocolStatus makeStatus(int code) {
        ProtocolStatus pstatus = ProtocolStatus.newBuilder().build();
        pstatus.setCode(code);
        pstatus.setLastModified(0L);
        return pstatus;
    }

    public static ProtocolStatus makeStatus(int code, String message) {
        ProtocolStatus pstatus = ProtocolStatusUtils.makeStatus(code);
        pstatus.getArgs().add((CharSequence)new Utf8(message));
        return pstatus;
    }

    public static ProtocolStatus makeStatus(int code, URL url) {
        return ProtocolStatusUtils.makeStatus(code, url.toString());
    }

    public static String getMessage(ProtocolStatus pstatus) {
        List<CharSequence> args = pstatus.getArgs();
        if (args == null || args.size() == 0) {
            return null;
        }
        return TableUtil.toString(args.iterator().next());
    }

    public static String toString(ProtocolStatus status) {
        if (status == null) {
            return "(null)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ProtocolStatusUtils.getName(status.getCode()));
        sb.append(", args=[");
        List<CharSequence> args = status.getArgs();
        if (args != null) {
            int i = 0;
            Iterator<CharSequence> it = args.iterator();
            while (it.hasNext()) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(it.next());
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

