/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.util.Utf8;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.parse.Outlink;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseStatusCodes;
import org.apache.nutch.storage.ParseStatus;
import org.apache.nutch.util.TableUtil;

public class ParseStatusUtils {
    public static ParseStatus STATUS_SUCCESS = ParseStatus.newBuilder().build();
    public static final HashMap<Short, String> minorCodes = new HashMap();

    public static boolean isSuccess(ParseStatus status) {
        if (status == null) {
            return false;
        }
        return status.getMajorCode() == 1;
    }

    public static String getMessage(ParseStatus status) {
        List<CharSequence> args = status.getArgs();
        if (args != null && args.size() > 0) {
            return TableUtil.toString(args.iterator().next());
        }
        return null;
    }

    public static String getArg(ParseStatus status, int n) {
        List<CharSequence> args = status.getArgs();
        if (args == null) {
            return null;
        }
        int i = 0;
        for (CharSequence arg : args) {
            if (i == n) {
                return TableUtil.toString(arg);
            }
            ++i;
        }
        return null;
    }

    public static Parse getEmptyParse(Exception e, Configuration conf) {
        ParseStatus status = ParseStatus.newBuilder().build();
        status.setMajorCode(2);
        status.setMinorCode(200);
        status.getArgs().add((CharSequence)new Utf8(e.toString()));
        return new Parse("", "", new Outlink[0], status);
    }

    public static Parse getEmptyParse(int minorCode, String message, Configuration conf) {
        ParseStatus status = ParseStatus.newBuilder().build();
        status.setMajorCode(2);
        status.setMinorCode(minorCode);
        status.getArgs().add((CharSequence)new Utf8(message));
        return new Parse("", "", new Outlink[0], status);
    }

    public static String toString(ParseStatus status) {
        if (status == null) {
            return "(null)";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ParseStatusCodes.majorCodes[status.getMajorCode()] + "/" + minorCodes.get(status.getMinorCode().shortValue()));
        sb.append(" (" + status.getMajorCode() + "/" + status.getMinorCode() + ")");
        sb.append(", args=[");
        List<CharSequence> args = status.getArgs();
        if (args != null) {
            int i = 0;
            Iterator<CharSequence> it = args.iterator();
            while (it.hasNext()) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(it.next());
                ++i;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    static {
        STATUS_SUCCESS.setMajorCode(1);
        minorCodes.put((short)0, "ok");
        minorCodes.put((short)100, "redirect");
        minorCodes.put((short)200, "exception");
        minorCodes.put((short)203, "invalid_format");
        minorCodes.put((short)205, "missing_content");
        minorCodes.put((short)204, "missing_parts");
        minorCodes.put((short)202, "truncated");
    }
}

