/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.parse.HTMLMetaTags;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseFilter;
import org.apache.nutch.parse.ParseStatusUtils;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.storage.WebPage;
import org.apache.nutch.util.ObjectCache;
import org.w3c.dom.DocumentFragment;

public class ParseFilters {
    private ParseFilter[] parseFilters;
    public static final String HTMLPARSEFILTER_ORDER = "htmlparsefilter.order";

    public ParseFilters(Configuration conf) {
        String order = conf.get(HTMLPARSEFILTER_ORDER);
        ObjectCache objectCache = ObjectCache.get(conf);
        this.parseFilters = (ParseFilter[])objectCache.getObject(ParseFilter.class.getName());
        if (this.parseFilters == null) {
            String[] orderedFilters = null;
            if (order != null && !order.trim().equals("")) {
                orderedFilters = order.split("\\s+");
            }
            HashMap<String, ParseFilter> filterMap = new HashMap<String, ParseFilter>();
            try {
                ExtensionPoint point = PluginRepository.get(conf).getExtensionPoint(ParseFilter.X_POINT_ID);
                if (point == null) {
                    throw new RuntimeException(ParseFilter.X_POINT_ID + " not found.");
                }
                Extension[] extensions = point.getExtensions();
                for (int i = 0; i < extensions.length; ++i) {
                    Extension extension = extensions[i];
                    ParseFilter parseFilter = (ParseFilter)extension.getExtensionInstance();
                    if (filterMap.containsKey(parseFilter.getClass().getName())) continue;
                    filterMap.put(parseFilter.getClass().getName(), parseFilter);
                }
                ParseFilter[] htmlParseFilters = filterMap.values().toArray(new ParseFilter[filterMap.size()]);
                if (orderedFilters == null) {
                    objectCache.setObject(ParseFilter.class.getName(), htmlParseFilters);
                } else {
                    ArrayList<ParseFilter> filters = new ArrayList<ParseFilter>();
                    for (int i = 0; i < orderedFilters.length; ++i) {
                        ParseFilter filter = (ParseFilter)filterMap.get(orderedFilters[i]);
                        if (filter == null) continue;
                        filters.add(filter);
                    }
                    objectCache.setObject(ParseFilter.class.getName(), filters.toArray(new ParseFilter[filters.size()]));
                }
            }
            catch (PluginRuntimeException e) {
                throw new RuntimeException(e);
            }
            this.parseFilters = (ParseFilter[])objectCache.getObject(ParseFilter.class.getName());
        }
    }

    public Parse filter(String url, WebPage page, Parse parse, HTMLMetaTags metaTags, DocumentFragment doc) {
        for (ParseFilter parseFilter : this.parseFilters) {
            if (ParseStatusUtils.isSuccess((parse = parseFilter.filter(url, page, parse, metaTags, doc)).getParseStatus())) continue;
            return parse;
        }
        return parse;
    }

    public Collection<WebPage.Field> getFields() {
        HashSet<WebPage.Field> fields = new HashSet<WebPage.Field>();
        for (ParseFilter htmlParseFilter : this.parseFilters) {
            Collection<WebPage.Field> pluginFields = htmlParseFilter.getFields();
            if (pluginFields == null) continue;
            fields.addAll(pluginFields);
        }
        return fields;
    }
}

