/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLNormalizer;
import org.apache.nutch.net.URLNormalizers;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.util.NutchConfiguration;

public class URLNormalizerChecker {
    private Configuration conf;

    public URLNormalizerChecker(Configuration conf) {
        this.conf = conf;
    }

    private void checkOne(String normalizerName, String scope) throws Exception {
        String line;
        Extension extension;
        URLNormalizer normalizer = null;
        ExtensionPoint point = PluginRepository.get(this.conf).getExtensionPoint(URLNormalizer.X_POINT_ID);
        if (point == null) {
            throw new RuntimeException(URLNormalizer.X_POINT_ID + " not found.");
        }
        Extension[] extensions = point.getExtensions();
        for (int i = 0; i < extensions.length && !(normalizer = (URLNormalizer)(extension = extensions[i]).getExtensionInstance()).getClass().getName().equals(normalizerName); ++i) {
            normalizer = null;
        }
        if (normalizer == null) {
            throw new RuntimeException("URLNormalizer " + normalizerName + " not found.");
        }
        System.out.println("Checking URLNormalizer " + normalizerName);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null) {
            String out = normalizer.normalize(line, scope);
            System.out.println(out);
        }
    }

    private void checkAll(String scope) throws Exception {
        String line;
        System.out.println("Checking combination of all URLNormalizers available");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        URLNormalizers normalizers = new URLNormalizers(this.conf, scope);
        while ((line = in.readLine()) != null) {
            String out = normalizers.normalize(line, scope);
            System.out.println(out);
        }
    }

    public static void main(String[] args) throws Exception {
        String usage = "Usage: URLNormalizerChecker [-normalizer <normalizerName>] [-scope <scope>]\n\tscope can be one of: default,partition,generate_host_count,fetcher,crawldb,linkdb,inject,outlink";
        String normalizerName = null;
        String scope = "default";
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-normalizer")) {
                normalizerName = args[++i];
                continue;
            }
            if (args[i].equals("-scope")) {
                scope = args[++i];
                continue;
            }
            System.err.println(usage);
            System.exit(-1);
        }
        URLNormalizerChecker checker = new URLNormalizerChecker(NutchConfiguration.create());
        if (normalizerName != null) {
            checker.checkOne(normalizerName, scope);
        } else {
            checker.checkAll(scope);
        }
        System.exit(0);
    }
}

