/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLFilter;
import org.apache.nutch.net.URLFilterException;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.plugin.PluginRuntimeException;
import org.apache.nutch.util.ObjectCache;

public class URLFilters {
    public static final String URLFILTER_ORDER = "urlfilter.order";
    private URLFilter[] filters;

    public URLFilters(Configuration conf) {
        String order = conf.get(URLFILTER_ORDER);
        ObjectCache objectCache = ObjectCache.get(conf);
        this.filters = (URLFilter[])objectCache.getObject(URLFilter.class.getName());
        if (this.filters == null) {
            String[] orderedFilters = null;
            if (order != null && !order.trim().equals("")) {
                orderedFilters = order.split("\\s+");
            }
            try {
                URLFilter filter;
                ExtensionPoint point = PluginRepository.get(conf).getExtensionPoint(URLFilter.X_POINT_ID);
                if (point == null) {
                    throw new RuntimeException(URLFilter.X_POINT_ID + " not found.");
                }
                Extension[] extensions = point.getExtensions();
                HashMap<String, URLFilter> filterMap = new HashMap<String, URLFilter>();
                for (int i = 0; i < extensions.length; ++i) {
                    Extension extension = extensions[i];
                    filter = (URLFilter)extension.getExtensionInstance();
                    if (filterMap.containsKey(filter.getClass().getName())) continue;
                    filterMap.put(filter.getClass().getName(), filter);
                }
                if (orderedFilters == null) {
                    objectCache.setObject(URLFilter.class.getName(), filterMap.values().toArray(new URLFilter[0]));
                } else {
                    ArrayList<URLFilter> filters = new ArrayList<URLFilter>();
                    for (int i = 0; i < orderedFilters.length; ++i) {
                        filter = (URLFilter)filterMap.get(orderedFilters[i]);
                        if (filter == null) continue;
                        filters.add(filter);
                    }
                    objectCache.setObject(URLFilter.class.getName(), filters.toArray(new URLFilter[filters.size()]));
                }
            }
            catch (PluginRuntimeException e) {
                throw new RuntimeException(e);
            }
            this.filters = (URLFilter[])objectCache.getObject(URLFilter.class.getName());
        }
    }

    public String filter(String urlString) throws URLFilterException {
        for (int i = 0; i < this.filters.length; ++i) {
            if (urlString == null) {
                return null;
            }
            urlString = this.filters[i].filter(urlString);
        }
        return urlString;
    }
}

