/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLFilter;
import org.apache.nutch.net.URLFilters;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.ExtensionPoint;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.util.NutchConfiguration;

public class URLFilterChecker {
    private Configuration conf;

    public URLFilterChecker(Configuration conf) {
        this.conf = conf;
    }

    private void checkOne(String filterName) throws Exception {
        String line;
        Extension extension;
        URLFilter filter = null;
        ExtensionPoint point = PluginRepository.get(this.conf).getExtensionPoint(URLFilter.X_POINT_ID);
        if (point == null) {
            throw new RuntimeException(URLFilter.X_POINT_ID + " not found.");
        }
        Extension[] extensions = point.getExtensions();
        for (int i = 0; i < extensions.length && !(filter = (URLFilter)(extension = extensions[i]).getExtensionInstance()).getClass().getName().equals(filterName); ++i) {
            filter = null;
        }
        if (filter == null) {
            throw new RuntimeException("Filter " + filterName + " not found.");
        }
        System.out.println("Checking URLFilter " + filterName);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null) {
            String out = filter.filter(line);
            if (out != null) {
                System.out.print("+");
                System.out.println(out);
                continue;
            }
            System.out.print("-");
            System.out.println(line);
        }
    }

    private void checkAll() throws Exception {
        String line;
        System.out.println("Checking combination of all URLFilters available");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null) {
            URLFilters filters = new URLFilters(this.conf);
            String out = filters.filter(line);
            if (out != null) {
                System.out.print("+");
                System.out.println(out);
                continue;
            }
            System.out.print("-");
            System.out.println(line);
        }
    }

    public static void main(String[] args) throws Exception {
        String usage = "Usage: URLFilterChecker (-filterName filterName | -allCombined)";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        String filterName = null;
        if (args[0].equals("-filterName")) {
            if (args.length != 2) {
                System.err.println(usage);
                System.exit(-1);
            }
            filterName = args[1];
        }
        URLFilterChecker checker = new URLFilterChecker(NutchConfiguration.create());
        if (filterName != null) {
            checker.checkOne(filterName);
        } else {
            checker.checkAll();
        }
        System.exit(0);
    }
}

