/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.metadata;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.metadata.CreativeCommons;
import org.apache.nutch.metadata.DublinCore;
import org.apache.nutch.metadata.Feed;
import org.apache.nutch.metadata.HttpHeaders;
import org.apache.nutch.metadata.Nutch;

public class Metadata
implements Writable,
CreativeCommons,
DublinCore,
HttpHeaders,
Nutch,
Feed {
    private Map<String, String[]> metadata = new HashMap<String, String[]>();

    public boolean isMultiValued(String name) {
        return this.metadata.get(name) != null && this.metadata.get(name).length > 1;
    }

    public String[] names() {
        return this.metadata.keySet().toArray(new String[this.metadata.keySet().size()]);
    }

    public String get(String name) {
        String[] values = this.metadata.get(name);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    public String[] getValues(String name) {
        return this._getValues(name);
    }

    private String[] _getValues(String name) {
        String[] values = this.metadata.get(name);
        if (values == null) {
            values = new String[]{};
        }
        return values;
    }

    public void add(String name, String value) {
        String[] values = this.metadata.get(name);
        if (values == null) {
            this.set(name, value);
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[newValues.length - 1] = value;
            this.metadata.put(name, newValues);
        }
    }

    public void setAll(Properties properties) {
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.metadata.put(name, new String[]{properties.getProperty(name)});
        }
    }

    public void set(String name, String value) {
        this.metadata.put(name, new String[]{value});
    }

    public void remove(String name) {
        this.metadata.remove(name);
    }

    public int size() {
        return this.metadata.size();
    }

    public void clear() {
        this.metadata.clear();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        Metadata other = null;
        try {
            other = (Metadata)o;
        }
        catch (ClassCastException cce) {
            return false;
        }
        if (other.size() != this.size()) {
            return false;
        }
        String[] names = this.names();
        for (int i = 0; i < names.length; ++i) {
            String[] thisValues;
            String[] otherValues = other._getValues(names[i]);
            if (otherValues.length != (thisValues = this._getValues(names[i])).length) {
                return false;
            }
            for (int j = 0; j < otherValues.length; ++j) {
                if (otherValues[j].equals(thisValues[j])) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String[] names = this.names();
        for (int i = 0; i < names.length; ++i) {
            String[] values = this._getValues(names[i]);
            for (int j = 0; j < values.length; ++j) {
                buf.append(names[i]).append("=").append(values[j]).append(" ");
            }
        }
        return buf.toString();
    }

    public final void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        String[] values = null;
        String[] names = this.names();
        for (int i = 0; i < names.length; ++i) {
            int j;
            Text.writeString((DataOutput)out, (String)names[i]);
            values = this._getValues(names[i]);
            int cnt = 0;
            for (j = 0; j < values.length; ++j) {
                if (values[j] == null) continue;
                ++cnt;
            }
            out.writeInt(cnt);
            for (j = 0; j < values.length; ++j) {
                if (values[j] == null) continue;
                Text.writeString((DataOutput)out, (String)values[j]);
            }
        }
    }

    public final void readFields(DataInput in) throws IOException {
        int keySize = in.readInt();
        for (int i = 0; i < keySize; ++i) {
            String key = Text.readString((DataInput)in);
            int valueSize = in.readInt();
            for (int j = 0; j < valueSize; ++j) {
                this.add(key, Text.readString((DataInput)in));
            }
        }
    }
}

