/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.solr;

import java.net.MalformedURLException;
import org.apache.hadoop.conf.Configuration;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrUtils {
    public static Logger LOG = LoggerFactory.getLogger(SolrUtils.class);

    public static HttpSolrServer getHttpSolrServer(Configuration job) throws MalformedURLException {
        DefaultHttpClient client = new DefaultHttpClient();
        if (job.getBoolean("solr.auth", false)) {
            String username = job.get("solr.auth.username");
            LOG.info("Authenticating as: " + username);
            AuthScope scope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME);
            client.getCredentialsProvider().setCredentials(scope, (Credentials)new UsernamePasswordCredentials(username, job.get("solr.auth.password")));
            HttpParams params = client.getParams();
            HttpClientParams.setAuthenticating((HttpParams)params, (boolean)true);
            client.setParams(params);
        }
        return new HttpSolrServer(job.get("solr.server.url"), (HttpClient)client);
    }

    public static String stripNonCharCodepoints(String input) {
        StringBuilder retval = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch % 65536 == 65535 || ch % 65536 == 65534 || ch > '\ufdd0' && ch < '\ufdef' || ch <= '\u001f' && ch != '\t' && ch != '\n' && ch != '\r') continue;
            retval.append(ch);
        }
        return retval.toString();
    }
}

