/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.nutch.metadata.Metadata;

public class NutchDocument
implements Writable,
Iterable<Map.Entry<String, List<String>>> {
    public static final byte VERSION = 1;
    private Map<String, List<String>> fields = new HashMap<String, List<String>>();
    private Metadata documentMeta = new Metadata();
    private float score = 0.0f;

    public void add(String name, String value) {
        List<String> fieldValues = this.fields.get(name);
        if (fieldValues == null) {
            fieldValues = new ArrayList<String>();
        }
        fieldValues.add(value);
        this.fields.put(name, fieldValues);
    }

    private void addFieldUnprotected(String name, String value) {
        this.fields.get(name).add(value);
    }

    public String getFieldValue(String name) {
        List<String> fieldValues = this.fields.get(name);
        if (fieldValues == null) {
            return null;
        }
        if (fieldValues.size() == 0) {
            return null;
        }
        return fieldValues.get(0);
    }

    public List<String> getFieldValues(String name) {
        return this.fields.get(name);
    }

    public List<String> removeField(String name) {
        return this.fields.remove(name);
    }

    public Collection<String> getFieldNames() {
        return this.fields.keySet();
    }

    @Override
    public Iterator<Map.Entry<String, List<String>>> iterator() {
        return this.fields.entrySet().iterator();
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public Metadata getDocumentMeta() {
        return this.documentMeta;
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version != 1) {
            throw new VersionMismatchException(1, version);
        }
        int size = WritableUtils.readVInt((DataInput)in);
        for (int i = 0; i < size; ++i) {
            String name = Text.readString((DataInput)in);
            int numValues = WritableUtils.readVInt((DataInput)in);
            this.fields.put(name, new ArrayList());
            for (int j = 0; j < numValues; ++j) {
                String value = Text.readString((DataInput)in);
                this.addFieldUnprotected(name, value);
            }
        }
        this.score = in.readFloat();
        this.documentMeta.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(1);
        WritableUtils.writeVInt((DataOutput)out, (int)this.fields.size());
        for (Map.Entry<String, List<String>> entry : this.fields.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            List<String> values = entry.getValue();
            WritableUtils.writeVInt((DataOutput)out, (int)values.size());
            for (String value : values) {
                Text.writeString((DataOutput)out, (String)value);
            }
        }
        out.writeFloat(this.score);
        this.documentMeta.write(out);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("doc {\n");
        for (Map.Entry<String, List<String>> entry : this.fields.entrySet()) {
            sb.append("\t");
            sb.append(entry.getKey());
            sb.append(":\t");
            sb.append(entry.getValue());
            sb.append("\n");
        }
        sb.append("}\n");
        return sb.toString();
    }
}

